/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.bulidMaterialMdm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bulidMaterialMdm.bean.MadRecordEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MadUserEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MaterialUserEntity;
import com.ejianc.foundation.bulidMaterialMdm.bean.MaterialUserTransferEntity;
import com.ejianc.foundation.bulidMaterialMdm.mapper.OrgMapper;
import com.ejianc.foundation.bulidMaterialMdm.mapper.UserMapper;
import com.ejianc.foundation.bulidMaterialMdm.service.ISystemRequestService;
import com.ejianc.foundation.bulidMaterialMdm.service.IUserService;
import com.ejianc.foundation.bulidMaterialMdm.vo.RoleVO;
import com.ejianc.foundation.bulidMaterialMdm.vo.UserVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class UserService
implements IUserService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISystemRequestService requestService;
    @Autowired
    private UserMapper mapper;
    @Autowired
    private OrgMapper orgMapper;
    private static final String AES_ALGORITHM = "AES";

    @Override
    public String performHandover(Integer targetUserId, Integer userId) {
        if (targetUserId == null || userId == null) {
            throw new BusinessException("\u627f\u63a5\u5de5\u4f5c\u7684\u4eba\u5458id\u3001\u7528\u6237ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = new JSONObject();
        param.put("targetUserId", (Object)targetUserId);
        param.put("userId", (Object)userId);
        String responseBody = this.requestService.sendPostRequest("user/performHandover", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        if (code != 0) {
            message = jsonObject.getString("message");
            throw new BusinessException("\u5de5\u4f5c\u4ea4\u63a5\u5931\u8d25\uff01" + message);
        }
        message = jsonObject.getString("message");
        return message;
    }

    @Override
    public JSONObject updateUser(UserVO userVO) {
        if (userVO.getUserId() == null) {
            throw new BusinessException("\u7528\u6237ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = new JSONObject();
        if (userVO.getDuty() != null) {
            param.put("duty", (Object)userVO.getDuty());
        }
        if (userVO.getPassword() != null) {
            param.put("password", (Object)userVO.getPassword());
        }
        if (userVO.getPhone() != null) {
            param.put("phone", (Object)userVO.getPhone());
        }
        if (userVO.getRealName() != null) {
            param.put("realName", (Object)userVO.getRealName());
        }
        if (userVO.getRoleId() != null) {
            param.put("roleId", (Object)userVO.getRoleId());
        }
        if (userVO.getUserId() != null) {
            param.put("userId", (Object)userVO.getUserId());
        }
        String responseBody = this.requestService.sendPostRequest("user/update", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        return jsonObject;
    }

    @Override
    public JSONObject deleteUser(Integer userId) {
        if (userId == null) {
            throw new BusinessException("\u7528\u6237id\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = new JSONObject();
        param.put("userId", (Object)userId);
        String responseBody = this.requestService.sendPostRequest("user/delete/", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        return jsonObject;
    }

    @Override
    public List<RoleVO> getRoleList() {
        String url = "user/getRoleList";
        JSONObject param = new JSONObject();
        String responseBody = this.requestService.sendPostRequest(url, param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        List roleVO = null;
        if (code != 0) {
            message = jsonObject.getString("message");
            throw new BusinessException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff01" + message);
        }
        roleVO = JSONObject.parseArray((String)jsonObject.getString("object"), RoleVO.class);
        return roleVO;
    }

    @Override
    public List<UserVO> getAllUser() {
        String url = "user/getAllUser";
        JSONObject param = new JSONObject();
        String responseBody = this.requestService.sendPostRequest(url, param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        List userVOS = null;
        if (code != 0) {
            message = jsonObject.getString("message");
            throw new BusinessException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff01" + message);
        }
        userVOS = JSONObject.parseArray((String)jsonObject.getJSONObject("object").getString("users"), UserVO.class);
        return userVOS;
    }

    @Override
    public List<UserVO> getUsersUnderDepartment(Integer departmentId) {
        if (departmentId == null) {
            throw new BusinessException("\u90e8\u95e8ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        String url = "user/getUsersUnderDepartment";
        JSONObject param = new JSONObject();
        param.put("departmentId", (Object)departmentId);
        String responseBody = this.requestService.sendPostRequest(url, param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        Integer code = jsonObject.getInteger("code");
        List userVOS = null;
        if (code != 0) {
            message = jsonObject.getString("message");
            throw new BusinessException("\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff01" + message);
        }
        userVOS = JSONObject.parseArray((String)jsonObject.getString("object"), UserVO.class);
        return userVOS;
    }

    @Override
    public JSONObject addUser(UserVO userVO) {
        if (userVO.getDepartmentId() == null || userVO.getDuty() == null || userVO.getPassword() == null || userVO.getPhone() == null || userVO.getRealName() == null || userVO.getRoleId() == null || userVO.getUsername() == null) {
            throw new BusinessException("\u804c\u4f4d\u3001\u5bc6\u7801\u3001\u7535\u8bdd\u3001\u59d3\u540d\u3001\u89d2\u8272Id\uff0c\u7528\u6237\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        try {
            byte[] encrypted = this.encrypt(userVO.getPassword(), "227d756c4eb9dc9071e423021c72b75f");
            String encryptedBase64 = Base64.getEncoder().encodeToString(encrypted);
            this.logger.info("\u52a0\u5bc6\u8fc7\u540e\u7684\u5bc6\u7801\uff1a{}", (Object)encryptedBase64);
            userVO.setPassword(encryptedBase64);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject param = JSONObject.parseObject((String)JSONObject.toJSONString((Object)userVO));
        this.logger.info("\u65b0\u589e\u7528\u6237\u7684\u53c2\u6570:{}", (Object)param.toString());
        String responseBody = this.requestService.sendPostRequest("user/add", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        return jsonObject;
    }

    @Override
    public JSONObject transfer(Integer departmentId, Integer departmentIdOld, Integer userId) {
        if (departmentId == null || userId == null) {
            throw new BusinessException("\u90e8\u95e8Id\u3001\u7528\u6237ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        }
        JSONObject param = new JSONObject();
        param.put("departmentId", (Object)departmentId);
        param.put("userId", (Object)userId);
        String responseBody = this.requestService.sendPostRequest("user/transfer", param);
        String message = "";
        JSONObject jsonObject = JSONObject.parseObject((String)responseBody);
        return jsonObject;
    }

    @Override
    public List<UserVO> queryUserData(Page<UserVO> page, Integer departmentId) {
        return this.mapper.queryUserData(page, departmentId);
    }

    public byte[] encrypt(String plaintext, String key) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), AES_ALGORITHM);
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        UserService.removeJceLimit();
        cipher.init(1, secretKeySpec);
        return cipher.doFinal(plaintext.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] decrypt(byte[] ciphertext, String key) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), AES_ALGORITHM);
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        UserService.removeJceLimit();
        cipher.init(2, secretKeySpec);
        return cipher.doFinal(ciphertext);
    }

    @Override
    public String userInfoSyncFirst(Integer page) {
        this.logger.info("\u7b51\u6750\u7f51\u540c\u6b65\u7528\u6237\u4fe1\u606f\u5f00\u59cb---------------->");
        List<MadUserEntity> todayUpdateData = this.mapper.selectWithPage(page * 50);
        if (todayUpdateData != null && todayUpdateData.size() > 0) {
            for (MadUserEntity todayUpdateDatum : todayUpdateData) {
                MadRecordEntity entity;
                Integer materialIdByMdmId = this.orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                if (todayUpdateDatum.getOrgid().equals(1502571152642412546L) || todayUpdateDatum.getOrgid().equals(1502571152701132801L) || todayUpdateDatum.getOrgid().equals(1502571152793407490L) || todayUpdateDatum.getOrgid().equals(1502571152847933442L) || todayUpdateDatum.getOrgid().equals(1502571155922358273L) || todayUpdateDatum.getOrgid().equals(1502571152583692289L)) {
                    materialIdByMdmId = 76236;
                } else if (materialIdByMdmId == null) {
                    this.logger.info("\u7ec4\u7ec7:{} \u7684\u4e0a\u7ea7\u7ec4\u7ec7\u672a\u540c\u6b65\uff01", (Object)todayUpdateDatum.getOrgid());
                    continue;
                }
                this.logger.info("\u7b51\u6750\u7f51\u7528\u6237\u4fe1\u606f\u65b0\u589e\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                UserVO userVO = new UserVO();
                userVO.setDepartmentId(materialIdByMdmId);
                userVO.setDuty("\u65e0");
                userVO.setPassword("1234qwer");
                userVO.setPhone(todayUpdateDatum.getMobilephone());
                userVO.setRealName(todayUpdateDatum.getEmployeename());
                userVO.setRoleId("396872");
                userVO.setUsername(todayUpdateDatum.getMobilephone());
                JSONObject jsonObject = this.addUser(userVO);
                Integer code = jsonObject.getInteger("code");
                if (code == 0) {
                    this.logger.info("\u7b51\u6750\u7f51\u65b0\u589e\u6210\u529f\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                    UserVO userVO1 = (UserVO)JSONObject.parseObject((String)jsonObject.getString("object"), UserVO.class);
                    entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u7528\u6237", 1, "");
                    this.mapper.insertSendRecord(entity);
                    MaterialUserEntity materialUserEntity = new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(), 1, materialIdByMdmId, userVO.getDuty(), userVO.getPassword(), userVO.getPhone(), userVO.getRealName(), userVO.getRoleId(), userVO.getUsername(), userVO1.getUserId());
                    this.mapper.insertUserInfo(materialUserEntity);
                } else {
                    String message = jsonObject.getString("message");
                    this.logger.info("\u7b51\u6750\u7f51\u65b0\u589e\u5931\u8d25\uff0cmessage\uff1a{}", (Object)message);
                    entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u7528\u6237", 2, message);
                    this.mapper.insertSendRecord(entity);
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.logger.info("\u9875\u9762\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        return "\u540c\u6b65\u6210\u529f\uff01";
    }

    @Override
    public String userInfoSync() {
        this.logger.info("\u7b51\u6750\u7f51\u540c\u6b65\u7528\u6237\u4fe1\u606f\u5f00\u59cb---------------->");
        List<MadUserEntity> todayUpdateData = this.mapper.getTodayUpdateData();
        if (todayUpdateData != null) {
            for (MadUserEntity todayUpdateDatum : todayUpdateData) {
                MaterialUserEntity materialUserEntity;
                if (todayUpdateDatum.getDataType() == 1) {
                    MadRecordEntity entity;
                    Integer materialIdByMdmId = this.orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                    if (todayUpdateDatum.getOrgid().equals(1502571152642412546L) || todayUpdateDatum.getOrgid().equals(1502571152701132801L) || todayUpdateDatum.getOrgid().equals(1502571152793407490L) || todayUpdateDatum.getOrgid().equals(1502571152847933442L) || todayUpdateDatum.getOrgid().equals(1502571155922358273L) || todayUpdateDatum.getOrgid().equals(1502571152583692289L)) {
                        materialIdByMdmId = 396872;
                    } else if (materialIdByMdmId == null) {
                        this.logger.info("\u7ec4\u7ec7:{} \u7684\u4e0a\u7ea7\u7ec4\u7ec7\u672a\u540c\u6b65\uff01", (Object)todayUpdateDatum.getOrgid());
                        continue;
                    }
                    this.logger.info("\u7b51\u6750\u7f51\u7528\u6237\u4fe1\u606f\u65b0\u589e\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                    UserVO userVO = new UserVO();
                    userVO.setDepartmentId(materialIdByMdmId);
                    userVO.setDuty("\u65e0");
                    userVO.setPassword("1234qwer");
                    userVO.setPhone(todayUpdateDatum.getMobilephone());
                    userVO.setRealName(todayUpdateDatum.getEmployeename());
                    userVO.setRoleId("396872");
                    userVO.setUsername(todayUpdateDatum.getMobilephone());
                    JSONObject jsonObject = this.addUser(userVO);
                    Integer code = jsonObject.getInteger("code");
                    if (code == 0) {
                        UserVO userVO1 = (UserVO)JSONObject.parseObject((String)jsonObject.getString("object"), UserVO.class);
                        entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u7528\u6237", 1, "");
                        this.mapper.insertSendRecord(entity);
                        materialUserEntity = new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(), 1, materialIdByMdmId, userVO.getDuty(), userVO.getPassword(), userVO.getPhone(), userVO.getRealName(), userVO.getRoleId(), userVO.getUsername(), userVO1.getUserId());
                        this.mapper.insertUserInfo(materialUserEntity);
                    } else {
                        String message = jsonObject.getString("message");
                        entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u65b0\u589e\u7528\u6237", 2, message);
                        this.mapper.insertSendRecord(entity);
                    }
                } else if (todayUpdateDatum.getDataType() == 2) {
                    MaterialUserEntity materialUserEntity2;
                    MadRecordEntity entity;
                    String message;
                    Integer code;
                    JSONObject jsonObject;
                    UserVO userVO;
                    Integer materialId;
                    MaterialUserEntity materialUser = this.mapper.getUserInfoByMdmId(todayUpdateDatum.getMasterDataId());
                    Integer n = materialId = materialUser != null ? materialUser.getUserId() : null;
                    if (materialId != null) {
                        Integer materialparentId = 396872;
                        if (!(todayUpdateDatum.getOrgid() == null || todayUpdateDatum.getOrgid().equals(1502571152642412546L) || todayUpdateDatum.getOrgid().equals(1502571152701132801L) || todayUpdateDatum.getOrgid().equals(1502571152793407490L) || todayUpdateDatum.getOrgid().equals(1502571152847933442L) || todayUpdateDatum.getOrgid().equals(1502571155922358273L) || todayUpdateDatum.getOrgid().equals(1502571152583692289L))) {
                            materialparentId = this.orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                        }
                        if (materialUser.getDepartmentId().equals(materialparentId)) {
                            this.logger.info("\u7b51\u6750\u7f51\u7528\u6237\u4fe1\u606f\u66f4\u65b0\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                            userVO = new UserVO();
                            if (!materialUser.getPhone().equals(todayUpdateDatum.getMobilephone())) {
                                userVO.setPhone(todayUpdateDatum.getMobilephone());
                            }
                            if (!materialUser.getRealName().equals(todayUpdateDatum.getEmployeename())) {
                                userVO.setRealName(todayUpdateDatum.getEmployeename());
                            }
                            userVO.setUserId(materialId);
                            jsonObject = this.updateUser(userVO);
                            code = jsonObject.getInteger("code");
                            if (code == 0) {
                                message = jsonObject.getString("object") + "";
                                entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u7528\u6237", 1, message);
                                this.mapper.insertSendRecord(entity);
                                materialUserEntity2 = new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(), 2, materialparentId, userVO.getDuty(), userVO.getPassword(), todayUpdateDatum.getMobilephone(), todayUpdateDatum.getEmployeename(), userVO.getRoleId(), userVO.getUsername(), materialId);
                                this.mapper.updateUserInfo(materialUserEntity2);
                            } else {
                                message = jsonObject.getString("message");
                                entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u7528\u6237", 2, message);
                                this.mapper.insertSendRecord(entity);
                            }
                        } else {
                            MadRecordEntity entity2;
                            String message2;
                            JSONObject transfer = this.transfer(materialparentId, materialUser.getDepartmentId(), materialId);
                            Integer code2 = transfer.getInteger("code");
                            if (code2 == 0) {
                                message2 = transfer.getString("message");
                                entity2 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u7528\u6237\u8f6c\u6362\u90e8\u95e8", 1, message2);
                                this.mapper.insertSendRecord(entity2);
                                MaterialUserEntity materialUserEntity3 = new MaterialUserEntity();
                                materialUserEntity3.setUserId(materialId);
                                materialUserEntity3.setLastUpdateTime(new Date());
                                materialUserEntity3.setDepartmentId(materialparentId);
                                this.mapper.updateUserDeptId(materialUserEntity3);
                            } else {
                                message2 = transfer.getString("message");
                                entity2 = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u7528\u6237\u8f6c\u6362\u90e8\u95e8", 2, message2);
                                this.mapper.insertSendRecord(entity2);
                                MaterialUserTransferEntity map = (MaterialUserTransferEntity)((Object)BeanMapper.map((Object)materialUser, MaterialUserTransferEntity.class));
                                map.setDepartmentIdNew(materialparentId);
                                map.setTransferState(2);
                                map.setErrorMessage(message2);
                                this.mapper.insertTransferRecord(map);
                            }
                        }
                    } else {
                        Integer materialIdByMdmId = this.orgMapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                        if (todayUpdateDatum.getOrgid().equals(1502571152642412546L) || todayUpdateDatum.getOrgid().equals(1502571152701132801L) || todayUpdateDatum.getOrgid().equals(1502571152793407490L) || todayUpdateDatum.getOrgid().equals(1502571152847933442L) || todayUpdateDatum.getOrgid().equals(1502571155922358273L) || todayUpdateDatum.getOrgid().equals(1502571152583692289L)) {
                            materialIdByMdmId = 396872;
                        } else if (materialIdByMdmId == null) {
                            this.logger.info("\u7ec4\u7ec7:{} \u7684\u4e0a\u7ea7\u7ec4\u7ec7\u672a\u540c\u6b65\uff01", (Object)todayUpdateDatum.getOrgid());
                            continue;
                        }
                        this.logger.info("\u7b51\u6750\u7f51\u7528\u6237\u4fe1\u606f\u4fee\u6539\u65b0\u589e\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                        userVO = new UserVO();
                        userVO.setDepartmentId(materialIdByMdmId);
                        userVO.setDuty("\u65e0");
                        userVO.setPassword("1234qwer");
                        userVO.setPhone(todayUpdateDatum.getMobilephone());
                        userVO.setRealName(todayUpdateDatum.getEmployeename());
                        userVO.setRoleId("396872");
                        userVO.setUsername(todayUpdateDatum.getMobilephone());
                        jsonObject = this.addUser(userVO);
                        code = jsonObject.getInteger("code");
                        if (code == 0) {
                            UserVO userVO1 = (UserVO)JSONObject.parseObject((String)jsonObject.getString("object"), UserVO.class);
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u65b0\u589e\u7528\u6237", 1, "");
                            this.mapper.insertSendRecord(entity);
                            materialUserEntity2 = new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(), 1, materialIdByMdmId, userVO.getDuty(), userVO.getPassword(), userVO.getPhone(), userVO.getRealName(), userVO.getRoleId(), userVO.getUsername(), userVO1.getUserId());
                            this.mapper.insertUserInfo(materialUserEntity2);
                        } else {
                            message = jsonObject.getString("message");
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u4fee\u6539\u65b0\u589e\u7528\u6237", 2, message);
                            this.mapper.insertSendRecord(entity);
                        }
                    }
                } else if (todayUpdateDatum.getDataType() == 3) {
                    Integer materialId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getMasterDataId());
                    this.logger.info("\u7b51\u6750\u7f51\u7ec4\u7ec7\u4fe1\u606f\u5220\u9664\uff0cid\uff1a{}", (Object)todayUpdateDatum.getMasterDataId());
                    if (materialId != null) {
                        MadRecordEntity entity;
                        String message;
                        JSONObject jsonObject = this.deleteUser(materialId);
                        Integer code = jsonObject.getInteger("code");
                        if (code == 0) {
                            message = jsonObject.getString("object") + "";
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u5220\u9664\u7528\u6237", 1, message);
                            this.mapper.insertSendRecord(entity);
                            Integer materialparentId = null;
                            if (todayUpdateDatum.getOrgid() != null) {
                                materialparentId = this.mapper.getMaterialIdByMdmId(todayUpdateDatum.getOrgid());
                            }
                            materialUserEntity = new MaterialUserEntity(todayUpdateDatum.getMasterDataId(), new Date(), 3, materialId);
                            this.mapper.deleteUserInfo(materialUserEntity);
                        } else {
                            message = jsonObject.getString("message");
                            entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u5220\u9664\u7528\u6237", 2, message);
                            this.mapper.insertSendRecord(entity);
                        }
                    } else {
                        MadRecordEntity entity = new MadRecordEntity(todayUpdateDatum.getMasterDataId(), new Date(), "\u5220\u9664\u7528\u6237", 2, "\u4e2d\u95f4\u8868\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
                        this.mapper.insertSendRecord(entity);
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return "\u540c\u6b65\u6210\u529f\uff01";
    }

    private static void removeJceLimit() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, false);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public UserVO getUserInfoByMdmId(Long mdmId) {
        MaterialUserEntity materialUser = this.mapper.getUserInfoByMdmId(mdmId);
        return (UserVO)BeanMapper.map((Object)materialUser, UserVO.class);
    }
}

