package com.ejianc.foundation.metadata.api;

import com.ejianc.foundation.metadata.hystrix.MdProjectHystrix;
import com.ejianc.foundation.metadata.vo.MdProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name= "ejc-metadata-web", url="${common.env.feign-client-url}", path="ejc-metadata-web", fallback = MdProjectHystrix.class)
public interface IMdProjectApi {

    /**
     * 根据refcode查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/api/mdProject/queryDetail", method= RequestMethod.GET)
    public CommonResponse<MdProjectVO> queryDetail(@RequestParam Long id);
}
