package com.ejianc.foundation.metadata.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.metadata.hystrix.MdHystrix;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.framework.core.response.CommonResponse;

/**
 * 模块rpc服务
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-metadata-web", url="${common.env.feign-client-url}", path="ejc-metadata-web", fallback = MdHystrix.class)
public interface IMdApi {

	/**
	 * 根据refcode查询详情
	 * 
	 * @param refCode
	 * @return
	 */
	@RequestMapping(value = "/api/queryByRefCode", method=RequestMethod.GET)
	public CommonResponse<MdReferVO> queryByRefCode(@RequestParam(value="refCode", required=true) String refCode);
}