package com.ejianc.foundation.metadata.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.metadata.hystrix.MdAttributeHystrix;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.response.CommonResponse;

@FeignClient(name= "ejc-metadata-web", url="${common.env.feign-client-url}", path="ejc-metadata-web", fallback = MdAttributeHystrix.class)
public interface IMdAttributeApi {
	
	/**
	 * 根据元数据实体ID查询其下所有属性值， 包括其关系表的属性
	 * 
	 * @param metadataId
	 * @return
	 */
	@RequestMapping(value = "/api/mdAttribute/queryListByEntityId", method= RequestMethod.GET)
	public CommonResponse<List<MdAttributeVO>> queryMdAttributeList(@RequestParam(value="metadataId", required=true) Long metadataId);

}
