package com.ejianc.foundation.metadata.api;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.metadata.hystrix.MdHystrix;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 模块rpc服务
 * 
 * @author liyongjia
 *
 */
@FeignClient(name= "ejc-metadata-web", url="${common.env.feign-client-url}", path="ejc-metadata-web", fallback = MdHystrix.class)
public interface IMdApi {

	/**
	 * 根据refcode查询详情
	 * 
	 * @param refCode
	 * @return
	 */
	@RequestMapping(value = "/api/queryByRefCode", method=RequestMethod.GET)
	public CommonResponse<MdReferVO> queryByRefCode(@RequestParam(value="refCode", required=true) String refCode);
	
	/**
	 * 根据实体id查询详情
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/api/queryMetadataById", method=RequestMethod.GET)
	public CommonResponse<MdReferVO> queryMetadataById(@RequestParam(value="id", required=true) Long id);

	/**
	 * 根据主实体Id及主表数据Id查询对应的通用打印数详情
	 *
	 * @param metaId 主实体Id
	 * @param dataId 主表数据Id
	 * @return
	 */
	@RequestMapping(value = "queryCommonPrintData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<JSONObject> queryCommonPrintData(@RequestParam(value = "metaId") Long metaId, @RequestParam(value = "dataId") Long dataId);
}