package com.ejianc.foundation.metadata.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.metadata.hystrix.MdAttributeHystrix;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.response.CommonResponse;

@FeignClient(name= "ejc-metadata-web", url="${common.env.feign-client-url}", path="ejc-metadata-web", fallback = MdAttributeHystrix.class)
public interface IMdAttributeApi {
	
	/**
	 * 根据元数据实体ID查询其下所有属性值， 包括其关系表的属性
	 * 
	 * @param metadataId
	 * @param range (children:主子；print：打印；quote：引用；不传：不查询关系表数据)
	 * @return
	 */
	@RequestMapping(value = "/api/mdAttribute/queryMdAttributeList", method= RequestMethod.GET)
	public CommonResponse<List<MdAttributeVO>> queryMdAttributeList(@RequestParam(value="metadataId", required=true) Long metadataId,@RequestParam(value="range", required=false) String range);

	/**
	 * 查询主实体的属性列表
	 * 
	 * @param parseLong
	 * @return
	 */
	@RequestMapping(value = "/api/mdAttribute/queryMainListByEntityId", method= RequestMethod.GET)
	public CommonResponse<List<MdAttributeVO>> queryMainAttributeList(@RequestParam(value="metadataId", required=true) Long metadataId);

}
