package com.ejianc.foundation.metadata.vo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;

import cn.hutool.core.util.ReferenceUtil;

public class MdRelationVO extends BaseVO {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Long id; //主键ID
	
	private String relationName;// 关系名称

	private String displayName;// 关系显示名称

	private Long sourceEntityId;// 来源实体ID
	
	private String sourceEntityName;// 来源实体name

	private Long sourceAttributeId;// 来源实体属性id
	
	private String sourceAttributeName;// 来源实体name

	private Long targetEntityId;// 目标实体id
	
	private String targetEntityName;// 来源实体name

	private Long targetAttributeId;// 目标实体属性id
	
	private String targetAttributeName;// 来源实体name

	private Long projectId;// 项目id

	private Integer type;// 关系类型（1一对一;2一对多;3多对多;4引用;5打印）
	
	private Long tenantId; //租户名称
	private Integer dr;
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getRelationName() {
		return relationName;
	}
	public void setRelationName(String relationName) {
		this.relationName = relationName;
	}
	public String getDisplayName() {
		return displayName;
	}
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}
	public Long getSourceEntityId() {
		return sourceEntityId;
	}
	public void setSourceEntityId(Long sourceEntityId) {
		this.sourceEntityId = sourceEntityId;
	}
	public Long getSourceAttributeId() {
		return sourceAttributeId;
	}
	public void setSourceAttributeId(Long sourceAttributeId) {
		this.sourceAttributeId = sourceAttributeId;
	}
	public Long getTargetEntityId() {
		return targetEntityId;
	}
	public void setTargetEntityId(Long targetEntityId) {
		this.targetEntityId = targetEntityId;
	}
	public Long getTargetAttributeId() {
		return targetAttributeId;
	}
	public void setTargetAttributeId(Long targetAttributeId) {
		this.targetAttributeId = targetAttributeId;
	}
	public Long getProjectId() {
		return projectId;
	}
	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}
	public Integer getType() {
		return type;
	}
	public void setType(Integer type) {
		this.type = type;
	}
	public Long getTenantId() {
		return tenantId;
	}
	public void setTenantId(Long tenantId) {
		this.tenantId = tenantId;
	}
	public Integer getDr() {
		return dr;
	}
	public void setDr(Integer dr) {
		this.dr = dr;
	}
	public String getSourceEntityName() {
		try {
			JSONArray jArray = ReferObjectUtil.getReferEntityValue(sourceEntityId.toString(), "mdclass");
			if(jArray!=null&&jArray.size()>0){
				JSONObject json = (JSONObject) jArray.get(0);
				String name = json.get("name").toString();
				String code = json.get("code").toString();
				return code+"("+name+")";
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return sourceEntityName;
	}

	public String getSourceAttributeName() {
		try {
			JSONArray jArray = ReferObjectUtil.getReferEntityValue(sourceAttributeId.toString(), "md-attribute");
			if(jArray!=null&&jArray.size()>0){
				JSONObject json = (JSONObject) jArray.get(0);
				String name = json.get("name").toString();
				String code = json.get("code").toString();
				return code+"("+name+")";
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return sourceAttributeName;
	}

	public String getTargetEntityName() {
		try {
			JSONArray jArray = ReferObjectUtil.getReferEntityValue(targetEntityId.toString(), "mdclass");
			if(jArray!=null&&jArray.size()>0){
				JSONObject json = (JSONObject) jArray.get(0);
				String name = json.get("name").toString();
				String code = json.get("code").toString();
				return code+"("+name+")";
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return targetEntityName;
	}

	public String getTargetAttributeName() {
		try {
			JSONArray jArray = ReferObjectUtil.getReferEntityValue(targetAttributeId.toString(), "md-attribute");
			if(jArray!=null&&jArray.size()>0){
				JSONObject json = (JSONObject) jArray.get(0);
				String name = json.get("name").toString();
				String code = json.get("code").toString();
				return code+"("+name+")";
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return targetAttributeName;
	}
	
}
