package com.ejianc.foundation.metadata.api;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.metadata.hystrix.MdRelationHystrix;
import com.ejianc.foundation.metadata.vo.MdQuoteVO;
import com.ejianc.framework.core.response.CommonResponse;

@FeignClient(name= "ejc-metadata-web", url="${common.env.feign-client-url}", path="ejc-metadata-web", fallback = MdRelationHystrix.class)
public interface IMdRelationApi {

    /**
     * 根据id查询引用信息
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/api/mdRelationApi/queryQuoteById", method= RequestMethod.GET)
    public CommonResponse<List<MdQuoteVO>> queryQuoteById(@RequestParam(value="id", required = true) Long id);
}
