package com.ejianc.foundation.metadata.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 元数据实体与自定义组织字段关系表
 * 
 * @author generator
 * 
 */
public class CustomObjVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer sequence; // 排序字段
    private Boolean compatible; // 是否向所选组织下级兼容，是：则下级也使用该字段配置，否：则仅仅所选组织使用该字段配置
    private Long orgId; // 使用该字段的组织
    private Long projectId; // 元数据工程项目id 非业务上面的项目id
    private Long entityId; // 元数据实体ID
    private String entityName; // 元数据实体名称

    private List<CustomFieldVO> customFieldList = new ArrayList<>(); // 自定定义字段列表
    /**
     * 排序字段
     */
    public Integer getSequence() {
        return sequence;
    }

    /**
     * 排序字段
     */
    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }
    /**
     * 是否向所选组织下级兼容，是：则下级也使用该字段配置，否：则仅仅所选组织使用该字段配置
     */
    public Boolean getCompatible() {
        return compatible;
    }

    /**
     * 是否向所选组织下级兼容，是：则下级也使用该字段配置，否：则仅仅所选组织使用该字段配置
     */
    public void setCompatible(Boolean compatible) {
        this.compatible = compatible;
    }
    /**
     * 使用该字段的组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 使用该字段的组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 元数据工程项目id 非业务上面的项目id
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 元数据工程项目id 非业务上面的项目id
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 元数据实体ID
     */
    @ReferSerialTransfer(referCode="mdclass")
    public Long getEntityId() {
        return entityId;
    }

    /**
     * 元数据实体ID
     */
    @ReferDeserialTransfer
    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }
    /**
     * 元数据实体名称
     */
    public String getEntityName() {
        return entityName;
    }

    /**
     * 元数据实体名称
     */
    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public List<CustomFieldVO> getCustomFieldList() {
        return customFieldList;
    }

    public void setCustomFieldList(List<CustomFieldVO> customFieldList) {
        this.customFieldList = customFieldList;
    }
}
