package com.ejianc.foundation.metadata.api;

import com.ejianc.foundation.metadata.hystrix.MdClassHystrix;
import com.ejianc.foundation.metadata.vo.CustomObjVO;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "ejc-metadata-web", url="${common.env.feign-client-url}", path="ejc-metadata-web", fallback = MdClassHystrix.class)
public interface IMdClassApi {

    /**
     * 根据id查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/api/mdClassApi/queryDetail", method= RequestMethod.GET)
    public CommonResponse<MdClassVO> queryDetail(@RequestParam(value="id") Long id);

    @GetMapping(value = "/api/mdClassApi/findAllByParentEntityId")
    public CommonResponse<List<MdClassVO>> findAllByParentEntityId(@RequestParam(value="entityId") Long entityId);

    /**
     * 根据元数据实体，查询当前组织拥有的扩展字段信息
     * */
    @GetMapping(value = "/api/mdClassApi/queryCustomObjInfoByEntityId")
    CommonResponse<CustomObjVO> queryCustomObjInfoByEntityId(@RequestParam(value="entityId") Long entityId);
}
