package com.ejianc.foundation.metadata.api;

import java.util.List;
import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.hystrix.MdAttributeHystrix;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.framework.core.response.CommonResponse;

@FeignClient(name= "ejc-metadata-web", url="${common.env.feign-client-url}", path="ejc-metadata-web", fallback = MdAttributeHystrix.class)
public interface IMdAttributeApi {
	
	/**
	 * 根据元数据实体ID查询其下所有属性值， 包括其关系表的属性
	 * 
	 * @param metadataId
	 * @param range (approve:审批查询（主子，审批单据可改字段）；children:主子；print：打印；quote：引用；不传：不查询关系表数据)
	 * @return
	 */
	@RequestMapping(value = "/api/mdAttribute/queryMdAttributeList", method= RequestMethod.GET)
	public CommonResponse<List<MdAttributeVO>> queryMdAttributeList(@RequestParam(value="metadataId", required=true) Long metadataId,
			@RequestParam(value="range", required=false) String range);

	/**
	 * 查询主实体的属性列表
	 * 
	 * @param parseLong
	 * @return
	 */
	@RequestMapping(value = "/api/mdAttribute/queryMainListByEntityId", method= RequestMethod.GET)
	public CommonResponse<List<MdAttributeVO>> queryMainAttributeList(@RequestParam(value="metadataId", required=true) Long metadataId);

	/**
	 * 根据实体元数据Id和属性名，查询对应属性信息
	 *
	 * @param metadataId 主实体元数据Id
	 * @param attrName 属性名
	 * @return
	 */
	@GetMapping(value = "/api/mdAttribute/queryAttrInfoByAttName")
	public CommonResponse<MdAttributeVO> queryAttrInfoByAttName(@RequestParam(value="metadataId") Long metadataId,
																@RequestParam(value="attrName") String attrName);

	@RequestMapping(value = "/api/mdAttribute/queryApproveFieldValue", method= RequestMethod.GET)
	public CommonResponse<JSONObject> queryApproveFieldValue(
			@RequestParam(value="billId", required=true) String billId,
			@RequestParam(value="targetAttribute", required=false) String targetAttribute,
			@RequestParam(value="billtypeId", required=false) String billtypeId,
			@RequestParam(value="sourceAttribute", required=false) String sourceAttribute);


	/**
	 * @description:  业财中台 - 根据单据类型获取实体主子表字段以及关联实体字段
	 *
	 * @param billTypeCode 单据类型
	 * @return {@link List< MdAttributeVO>}
	 * @author songlx
	 * @date: 2023/12/26
	 */
	@RequestMapping(value = "/api/mdAttribute/getAttrMap", method = RequestMethod.GET)
	CommonResponse<Map<String, MdAttributeVO>> getAttrMap(@RequestParam(value = "billTypeCode") String billTypeCode);

	/**
	 * @description: 业财中台 - 根据来源字段值查询关联实体数据
	 *
	 * @param billTypeCode
	 * @param sourceAttributeId
	 * @param sourceAttributeValue
	 * @return {@link CommonResponse< Map< String, Object>>}
	 * @author songlx
	 * @date: 2023/12/27
	 */
	@RequestMapping(value = "/api/mdAttribute/queryRelationEntityValue", method= RequestMethod.GET)
	CommonResponse<Map<String, Object>> queryRelationEntityValue(
			@RequestParam(value = "billTypeCode", required = false) String billTypeCode,
			@RequestParam(value = "metadataId", required = false) Long metadataId,
			@RequestParam(value = "sourceAttributeId") Long sourceAttributeId,
			@RequestParam(value = "sourceAttributeValue") String sourceAttributeValue,
			@RequestParam(value = "targetAttributeList", required = false) List<String> targetAttributeList
	);
}
