/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.mongodb;

import com.ejianc.framework.mongodb.MongoClientOptionProperties;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDbFactory;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

@Configuration
@EnableConfigurationProperties(value={MongoClientOptionProperties.class})
public class MongodbConfiguration {
    @Bean
    public MappingMongoConverter mappingMongoConverter(MongoDbFactory factory, MongoMappingContext context, BeanFactory beanFactory) {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(factory);
        MappingMongoConverter mappingConverter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)context);
        try {
            mappingConverter.setCustomConversions((CustomConversions)beanFactory.getBean(CustomConversions.class));
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        mappingConverter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        return mappingConverter;
    }

    @Bean
    public MongoTypeMapper defaultMongoTypeMapper() {
        return new DefaultMongoTypeMapper(null);
    }

    @Bean
    public MongoTemplate mongoTemplate(MongoDbFactory mongoDbFactory, MappingMongoConverter converter) {
        MongoTemplate mongoTemplate = new MongoTemplate(mongoDbFactory, (MongoConverter)converter);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        return mongoTemplate;
    }

    @Bean
    public MongoDbFactory mongoDbFactory(MongoClientOptionProperties properties) {
        MongoClientSettings mongoClientOptions = this.mongoClientSettings(properties);
        MongoDriverInformation info = MongoDriverInformation.builder().build();
        MongoClientImpl mongoClient = new MongoClientImpl(mongoClientOptions, info);
        return new SimpleMongoClientDbFactory((MongoClient)mongoClient, properties.getDatabase());
    }

    @Bean
    public MongoClientSettings mongoClientSettings(MongoClientOptionProperties properties) {
        MongoCredential mongoCredential = this.getCredential(properties);
        List<ServerAddress> serverAddressList = this.getServerAddress(properties.getAddress());
        return MongoClientSettings.builder().applicationName(properties.getClientName()).applyToClusterSettings(i -> i.hosts(serverAddressList)).credential(mongoCredential).applyToSocketSettings(i -> i.readTimeout(properties.getReadTimeoutMs(), TimeUnit.MILLISECONDS).connectTimeout(properties.getConnectionTimeoutMs(), TimeUnit.MILLISECONDS)).applyToConnectionPoolSettings(i -> i.maxConnectionIdleTime((long)properties.getMaxConnectionIdleTimeMs(), TimeUnit.MILLISECONDS).maxConnectionLifeTime((long)properties.getMaxConnectionIdleTimeMs(), TimeUnit.MILLISECONDS).maxWaitTime((long)properties.getMaxWaitTimeMs(), TimeUnit.MILLISECONDS).maxSize(properties.getConnectionsPerHost()).minSize(properties.getMinConnectionsPerHost())).applyToServerSettings(i -> i.heartbeatFrequency((long)properties.getHeartbeatFrequencyMs(), TimeUnit.MILLISECONDS).minHeartbeatFrequency((long)properties.getMinHeartbeatFrequencyMs(), TimeUnit.MILLISECONDS)).build();
    }

    private MongoCredential getCredential(MongoClientOptionProperties properties) {
        if (StringUtils.isNotBlank((String)properties.getUsername()) && StringUtils.isNotEmpty((String)properties.getPassword())) {
            String database = StringUtils.isBlank((String)properties.getAuthenticationDatabase()) ? properties.getDatabase() : properties.getAuthenticationDatabase();
            return MongoCredential.createCredential((String)properties.getUsername(), (String)database, (char[])properties.getPassword().toCharArray());
        }
        return null;
    }

    private List<ServerAddress> getServerAddress(String mongoAddress) {
        String[] mongoAddressArray = mongoAddress.trim().split(",");
        ArrayList<ServerAddress> serverAddressList = new ArrayList<ServerAddress>(4);
        for (String address : mongoAddressArray) {
            String[] hostAndPort = address.split(":");
            serverAddressList.add(new ServerAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
        }
        return serverAddressList;
    }
}

