/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.framework.mongodb.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Component;

@Component
public class MongodbCrudTemplate {
    @Autowired
    private MongoTemplate mongoTemplate;

    public void insertOne(JSONObject jsonObject, String tableName) {
        Document document = Document.parse((String)jsonObject.toJSONString());
        MongoCollection collection = this.mongoTemplate.getCollection(tableName);
        collection.insertOne((Object)document);
    }

    public void updateById(JSONObject jsonObject, String tableName) {
        Document document = Document.parse((String)jsonObject.toJSONString());
        MongoCollection collection = this.mongoTemplate.getCollection(tableName);
        Bson bson = Filters.eq((String)"id", (Object)jsonObject.getLong("id"));
        collection.updateOne(bson, (Bson)new Document("$set", (Object)document), new UpdateOptions().upsert(true));
    }

    public void deleteById(Long pkId, String tableName) {
        MongoCollection collection = this.mongoTemplate.getCollection(tableName);
        Bson bson = Filters.eq((String)"id", (Object)pkId);
        collection.deleteOne(bson);
    }

    public JSONObject selectById(Long pkId, String tableName) {
        MongoCollection collection = this.mongoTemplate.getCollection(tableName);
        Bson bson = Filters.eq((String)"id", (Object)pkId);
        FindIterable find = collection.find(bson);
        MongoCursor iterator = find.iterator();
        JSONObject jsonObject = null;
        try {
            if (iterator.hasNext()) {
                Document document = (Document)iterator.next();
                jsonObject = JSON.parseObject((String)document.toJson());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject;
    }

    private static List<String> getMonthRange(String startDateStr, String endDateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(startDateStr);
            endDate = sdf.parse(endDateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<String> monthList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (!calendar.getTime().after(endDate)) {
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            String monthStr = String.format("%04d-%02d", year, month);
            monthList.add(monthStr);
            calendar.add(2, 1);
        }
        return monthList;
    }

    private Bson getSearchParam(final QueryParam queryParam) {
        final ArrayList<Bson> searchParamList = new ArrayList<Bson>();
        Bson fuzzyBson = null;
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchText()) && !ListUtil.isEmpty((List)queryParam.getFuzzyFields())) {
            final String searchText = queryParam.getSearchText();
            final List fuzzyFields = queryParam.getFuzzyFields();
            fuzzyBson = queryParam.getFuzzyFields().size() == 1 ? Filters.regex((String)((String)queryParam.getFuzzyFields().get(0)), (String)searchText) : Filters.or((Iterable)new Iterable<Bson>(){

                @Override
                public Iterator<Bson> iterator() {
                    ArrayList<Bson> bsonList = new ArrayList<Bson>();
                    for (int i = 0; i < fuzzyFields.size(); ++i) {
                        bsonList.add(Filters.regex((String)((String)queryParam.getFuzzyFields().get(i)), (String)searchText));
                    }
                    return bsonList.iterator();
                }
            });
        }
        if (fuzzyBson != null) {
            searchParamList.add(fuzzyBson);
        }
        final ArrayList<Bson> paramBsonList = new ArrayList<Bson>();
        Map params = queryParam.getParams();
        for (Map.Entry entry : params.entrySet()) {
            Parameter param = (Parameter)entry.getValue();
            String type = param.getType();
            switch (type) {
                case "eq": {
                    paramBsonList.add(Filters.eq((String)((String)entry.getKey()), (Object)(null == param.getValue() ? null : param.getValue())));
                    break;
                }
                case "ne": {
                    paramBsonList.add(Filters.ne((String)((String)entry.getKey()), (Object)(null == param.getValue() ? null : param.getValue())));
                    break;
                }
                case "in": {
                    if (param.getValue() instanceof List) {
                        paramBsonList.add(Filters.in((String)((String)entry.getKey()), (Object[])new Iterator[]{((List)param.getValue()).iterator()}));
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    paramBsonList.add(Filters.in((String)((String)entry.getKey()), (Object[])paramArr));
                    break;
                }
                case "not_in": {
                    if (param.getValue() instanceof List) {
                        paramBsonList.add(Filters.nin((String)((String)entry.getKey()), (Object[])new Iterator[]{((List)param.getValue()).iterator()}));
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    paramBsonList.add(Filters.nin((String)((String)entry.getKey()), (Object[])paramArr));
                    break;
                }
                case "like": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    paramBsonList.add(Filters.regex((String)((String)entry.getKey()), (String)param.getValue().toString()));
                    break;
                }
                case "between": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    if ("dateInSelect".equals(param.getInputType()) && ((String)paramArr[0]).length() == 7) {
                        if (((String)paramArr[0]).equals(paramArr[1])) {
                            paramBsonList.add(Filters.regex((String)((String)entry.getKey()), (String)paramArr[0]));
                            break;
                        }
                        paramBsonList.add(Filters.in((String)((String)entry.getKey()), (Object[])new Iterator[]{MongodbCrudTemplate.getMonthRange((String)paramArr[0], (String)paramArr[1]).iterator()}));
                        break;
                    }
                    paramBsonList.add(Filters.and((Bson[])new Bson[]{Filters.lte((String)((String)entry.getKey()), (Object)paramArr[0]), Filters.gte((String)((String)entry.getKey()), (Object)paramArr[1])}));
                    break;
                }
                case "lt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    paramBsonList.add(Filters.lt((String)((String)entry.getKey()), (Object)param.getValue()));
                    break;
                }
                case "le": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    paramBsonList.add(Filters.lte((String)((String)entry.getKey()), (Object)param.getValue()));
                    break;
                }
                case "gt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    paramBsonList.add(Filters.gt((String)((String)entry.getKey()), (Object)param.getValue()));
                    break;
                }
                case "ge": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    paramBsonList.add(Filters.gte((String)((String)entry.getKey()), (Object)param.getValue()));
                }
            }
        }
        Bson paramBson = null;
        if (paramBsonList.size() > 0) {
            paramBson = Filters.and((Iterable)new Iterable<Bson>(){

                @Override
                public Iterator<Bson> iterator() {
                    return paramBsonList.iterator();
                }
            });
        }
        if (paramBson != null) {
            searchParamList.add(paramBson);
        }
        final ArrayList<Bson> searchObjectList = new ArrayList<Bson>();
        Bson searchObjectBson = null;
        if (StringUtils.isNotBlank((CharSequence)queryParam.getSearchObject())) {
            JSONObject searchObject = JSONObject.parseObject((String)queryParam.getSearchObject());
            for (String key : searchObject.keySet()) {
                searchObjectList.add(Filters.regex((String)key, (String)searchObject.getString(key)));
            }
            searchObjectBson = Filters.and((Iterable)new Iterable<Bson>(){

                @Override
                public Iterator<Bson> iterator() {
                    return searchObjectList.iterator();
                }
            });
        }
        if (searchObjectBson != null) {
            searchParamList.add(searchObjectBson);
        }
        if (searchParamList.size() > 0) {
            return Filters.and((Iterable)new Iterable<Bson>(){

                @Override
                public Iterator<Bson> iterator() {
                    return searchParamList.iterator();
                }
            });
        }
        return null;
    }

    public List<JSONObject> selectList(QueryParam queryParam, String tableName) {
        MongoCollection collection = this.mongoTemplate.getCollection(tableName);
        Bson queryBson = this.getSearchParam(queryParam);
        BasicDBObject sortField = new BasicDBObject();
        LinkedHashMap orderMap = queryParam.getOrderMap();
        for (String key : orderMap.keySet()) {
            String value = (String)orderMap.get(key);
            if ("asc".equals(value.toLowerCase())) {
                sortField.put((Object)key, (Object)1);
                continue;
            }
            if (!"desc".equals(value.toLowerCase())) continue;
            sortField.put((Object)key, (Object)-1);
        }
        FindIterable find = null;
        find = queryBson != null ? collection.find(queryBson) : collection.find();
        if (!sortField.isEmpty()) {
            find.sort((Bson)sortField);
        }
        MongoCursor iterator = find.iterator();
        ArrayList<JSONObject> resultJson = new ArrayList<JSONObject>();
        try {
            while (iterator.hasNext()) {
                Document document = (Document)iterator.next();
                resultJson.add(JSON.parseObject((String)document.toJson()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultJson;
    }

    public Long selectCount(QueryParam queryParam, String tableName) {
        MongoCollection collection = this.mongoTemplate.getCollection(tableName);
        Bson queryBson = this.getSearchParam(queryParam);
        long totalCount = 0L;
        totalCount = queryBson != null ? collection.countDocuments(queryBson) : collection.countDocuments();
        return totalCount;
    }

    public IPage<JSONObject> queryPage(QueryParam queryParam, String tableName) {
        Page page = new Page();
        if (queryParam.getPageSize() == -1) {
            page.setRecords(this.selectList(queryParam, tableName));
            return page;
        }
        MongoCollection collection = this.mongoTemplate.getCollection(tableName);
        Bson queryBson = this.getSearchParam(queryParam);
        BasicDBObject sortField = new BasicDBObject();
        LinkedHashMap orderMap = queryParam.getOrderMap();
        for (String key : orderMap.keySet()) {
            String value = (String)orderMap.get(key);
            if ("asc".equals(value.toLowerCase())) {
                sortField.put((Object)key, (Object)1);
                continue;
            }
            if (!"desc".equals(value.toLowerCase())) continue;
            sortField.put((Object)key, (Object)-1);
        }
        FindIterable find = null;
        find = queryBson != null ? collection.find(queryBson) : collection.find();
        if (!sortField.isEmpty()) {
            find.sort((Bson)sortField);
        }
        if (queryParam.getPageIndex() < 1) {
            queryParam.setPageIndex(1);
        }
        find.skip((queryParam.getPageIndex() - 1) * queryParam.getPageSize()).limit(queryParam.getPageSize());
        MongoCursor iterator = find.iterator();
        ArrayList<JSONObject> resultJson = new ArrayList<JSONObject>();
        try {
            while (iterator.hasNext()) {
                Document document = (Document)iterator.next();
                resultJson.add(JSON.parseObject((String)document.toJson()));
            }
        }
        catch (Exception document) {
            // empty catch block
        }
        page.setRecords(resultJson);
        long totalCount = 0L;
        totalCount = queryBson != null ? collection.countDocuments(queryBson) : collection.countDocuments();
        page.setTotal(totalCount);
        return page;
    }
}

