package com.ejianc.framework.mongodb;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "ejc.mongo")
public class MongoClientOptionProperties {

	private String database; // 要连接的数据库

	private String username; // 用户名

	private String password; // 密码

	private String address; // ip和端口

	private String authenticationDatabase; // 设置认证数据库，如果有的话

	private String clientName; // 客户端的标识，用于定位请求来源等，一般用程序名

	private int connectionTimeoutMs = 10000; // TCP（socket）连接超时时间，毫秒

	private int maxConnectionIdleTimeMs = 10000; // TCP（socket）连接闲置时间，毫秒

	private int maxConnectionLifeTimeMs = 10000; // TCP（socket）连接最多可以使用多久，毫秒

	private int readTimeoutMs = 15000; // TCP（socket）读取超时时间，毫秒

	private int maxWaitTimeMs = 1000; // 当连接池无可用连接时客户端阻塞等待的最大时长，毫秒

	private int heartbeatFrequencyMs = 10000; // 心跳检测发送频率，毫秒

	private int minHeartbeatFrequencyMs = 300; // 最小的心跳检测发送频率，毫秒

	private int heartbeatConnectionTimeoutMs = 200; // 心跳检测连接超时时间，毫秒

	private int heartbeatReadTimeoutMs = 200; // 心跳检测读取超时时间，毫秒

	private int connectionsPerHost = 200; // 线程池允许的最大连接数

	private int minConnectionsPerHost = 50; // 线程池空闲时保持的最小连接数

	private int threadsAllowedToBlockForConnectionMultiplier; // 计算允许多少个线程阻塞等待时的乘数，算法：threadsAllowedToBlockForConnectionMultiplier*maxConnectionsPerHost

	public String getDatabase() {
		return database;
	}

	public void setDatabase(String database) {
		this.database = database;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getAuthenticationDatabase() {
		return authenticationDatabase;
	}

	public void setAuthenticationDatabase(String authenticationDatabase) {
		this.authenticationDatabase = authenticationDatabase;
	}

	public String getClientName() {
		return clientName;
	}

	public void setClientName(String clientName) {
		this.clientName = clientName;
	}

	public int getConnectionTimeoutMs() {
		return connectionTimeoutMs;
	}

	public void setConnectionTimeoutMs(int connectionTimeoutMs) {
		this.connectionTimeoutMs = connectionTimeoutMs;
	}

	public int getMaxConnectionIdleTimeMs() {
		return maxConnectionIdleTimeMs;
	}

	public void setMaxConnectionIdleTimeMs(int maxConnectionIdleTimeMs) {
		this.maxConnectionIdleTimeMs = maxConnectionIdleTimeMs;
	}

	public int getMaxConnectionLifeTimeMs() {
		return maxConnectionLifeTimeMs;
	}

	public void setMaxConnectionLifeTimeMs(int maxConnectionLifeTimeMs) {
		this.maxConnectionLifeTimeMs = maxConnectionLifeTimeMs;
	}

	public int getReadTimeoutMs() {
		return readTimeoutMs;
	}

	public void setReadTimeoutMs(int readTimeoutMs) {
		this.readTimeoutMs = readTimeoutMs;
	}

	public int getMaxWaitTimeMs() {
		return maxWaitTimeMs;
	}

	public void setMaxWaitTimeMs(int maxWaitTimeMs) {
		this.maxWaitTimeMs = maxWaitTimeMs;
	}

	public int getHeartbeatFrequencyMs() {
		return heartbeatFrequencyMs;
	}

	public void setHeartbeatFrequencyMs(int heartbeatFrequencyMs) {
		this.heartbeatFrequencyMs = heartbeatFrequencyMs;
	}

	public int getMinHeartbeatFrequencyMs() {
		return minHeartbeatFrequencyMs;
	}

	public void setMinHeartbeatFrequencyMs(int minHeartbeatFrequencyMs) {
		this.minHeartbeatFrequencyMs = minHeartbeatFrequencyMs;
	}

	public int getHeartbeatConnectionTimeoutMs() {
		return heartbeatConnectionTimeoutMs;
	}

	public void setHeartbeatConnectionTimeoutMs(int heartbeatConnectionTimeoutMs) {
		this.heartbeatConnectionTimeoutMs = heartbeatConnectionTimeoutMs;
	}

	public int getHeartbeatReadTimeoutMs() {
		return heartbeatReadTimeoutMs;
	}

	public void setHeartbeatReadTimeoutMs(int heartbeatReadTimeoutMs) {
		this.heartbeatReadTimeoutMs = heartbeatReadTimeoutMs;
	}

	public int getConnectionsPerHost() {
		return connectionsPerHost;
	}

	public void setConnectionsPerHost(int connectionsPerHost) {
		this.connectionsPerHost = connectionsPerHost;
	}

	public int getMinConnectionsPerHost() {
		return minConnectionsPerHost;
	}

	public void setMinConnectionsPerHost(int minConnectionsPerHost) {
		this.minConnectionsPerHost = minConnectionsPerHost;
	}

	public int getThreadsAllowedToBlockForConnectionMultiplier() {
		return threadsAllowedToBlockForConnectionMultiplier;
	}

	public void setThreadsAllowedToBlockForConnectionMultiplier(int threadsAllowedToBlockForConnectionMultiplier) {
		this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
	}

}
