package com.ejianc.business.oa.api;

import com.ejianc.business.oa.hystrix.CertManagementHystrix;
import com.ejianc.business.oa.vo.ManagementVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @description: ICertManagementApi
 *
 * @author songlx
 * @date: 2024/4/12
 */
@FeignClient(name = "ejc-oa-web", url = "${common.env.feign-client-url}", path = "ejc-oa-web", fallback = CertManagementHystrix.class)
public interface ICertManagementApi {


    /**
     * @description: 证照列表查询
     *
     * @param param
     * @return {@link CommonResponse< List< ManagementVO>>}
     * @author songlx
     * @date: 2024/4/12
     */
    @PostMapping(value = "/api/certManagement/getCertList")
    @ResponseBody
    CommonResponse<List<ManagementVO>> getCertList(@RequestBody QueryParam param);
}
