package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 月度收支填报-子实体
 * 
 * @author generator
 * 
 */
public class ImportMonthBudgetFormDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 月度收支填报主表id
    private Long personId; // 人员id
    private String personCode; // 人员编码
    private String personName; // 姓名
    private BigDecimal unitSocialSecurityMny; // 单位社保金额
    private BigDecimal personSocialSecurityMny; // 个人社保金额
    private BigDecimal payMny; // 支出金额
    private BigDecimal incomeMny; // 收入金额
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编号
    private String unitPayBelong; // 单位缴纳归属：个人、公司、项目
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date detailMonth; // 月份
    private Integer sourceType; // 数据来源：0：新增 1：导入
    private String memo; // 备注

    /**
     * 导入失败原因
     */
    private String errorMessage;

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public Long getPersonId() {
        return personId;
    }
    @ReferDeserialTransfer
    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public String getPersonCode() {
        return personCode;
    }

    public void setPersonCode(String personCode) {
        this.personCode = personCode;
    }

    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }
    public BigDecimal getUnitSocialSecurityMny() {
        return unitSocialSecurityMny;
    }

    public void setUnitSocialSecurityMny(BigDecimal unitSocialSecurityMny) {
        this.unitSocialSecurityMny = unitSocialSecurityMny;
    }
    public BigDecimal getPersonSocialSecurityMny() {
        return personSocialSecurityMny;
    }

    public void setPersonSocialSecurityMny(BigDecimal personSocialSecurityMny) {
        this.personSocialSecurityMny = personSocialSecurityMny;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public BigDecimal getIncomeMny() {
        return incomeMny;
    }

    public void setIncomeMny(BigDecimal incomeMny) {
        this.incomeMny = incomeMny;
    }
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getUnitPayBelong() {
        return unitPayBelong;
    }

    public void setUnitPayBelong(String unitPayBelong) {
        this.unitPayBelong = unitPayBelong;
    }
    public Date getDetailMonth() {
        return detailMonth;
    }

    public void setDetailMonth(Date detailMonth) {
        this.detailMonth = detailMonth;
    }
    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}
