package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 周报
 *
 * @author generator
 *
 */
public class WeeklyReportVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long projectManager; // 项目经理
    private String projectManagerName; // 项目经理名称
    private Long projectDirector; // 项目总监
    private String projectDirectorName; // 项目总监名称
    private Integer weeklyNum; // 第几周
    private BigDecimal lastWeeklyProgress; // 上周进度
    private BigDecimal weeklyProgress; // 本周进度
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date preFinishDate; // 预计实际完工时间
    private BigDecimal costTotalMny; // 项目金额
    private BigDecimal preCostMny; // 预计总成本
    private BigDecimal finishOutputMny; // 本周完成产值
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date reportDate; // 上报时间
    private BigDecimal projPersonEfficiency; // 项目人效
    private BigDecimal constructionPersonNum; // 施工人数
    private BigDecimal managePersonNum; // 管理人员
    private String projProgress; // 项目进展
    private String weeklyProblem; // 本周问题
    private String memo; // 备注
    private String billStateName;
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date finishDate; // 实际完工时间

    private Integer rowSpan;
    private Integer normalRowSpan;
    private BigDecimal areaOutputMny;
    private BigDecimal areaPersonEfficiency;

    @JsonFormat( pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date statisticsDate; // 统计日期
    @JsonFormat( pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 实际开工时间
    @JsonFormat( pattern = "yyyy-MM", timezone = "GMT+8")
    private Date reportMonth; // 统计月份
    private BigDecimal yearPlanMny; // 年度计划产值
    private BigDecimal contractTempMny; // 合同暂列金
    private BigDecimal sumFinishMny; // 累计完成产值

    private List<WeeklyReportManagerVO> managerList = new ArrayList<>(); // 周报-管理人员
    private List<WeeklyReportDetailVO> weeklyReportDetailList = new ArrayList<>(); // 周报-本周问题


    private String  materialProblem;
    private String  materialMeasure;
    private String  teamProblem;
    private String  teamMeasure;
    private String  roomProblem;
    private String  roomMeasure;
    private String  sceneProblem;
    private String  sceneMeasure;
    private String  contractProblem;
    private String  contractMeasure;
    private String  otherProblem;
    private String  otherMeasure;

    public String getMaterialProblem() {
        return materialProblem;
    }

    public void setMaterialProblem(String materialProblem) {
        this.materialProblem = materialProblem;
    }

    public String getMaterialMeasure() {
        return materialMeasure;
    }

    public void setMaterialMeasure(String materialMeasure) {
        this.materialMeasure = materialMeasure;
    }

    public String getTeamProblem() {
        return teamProblem;
    }

    public void setTeamProblem(String teamProblem) {
        this.teamProblem = teamProblem;
    }

    public String getTeamMeasure() {
        return teamMeasure;
    }

    public void setTeamMeasure(String teamMeasure) {
        this.teamMeasure = teamMeasure;
    }

    public String getRoomProblem() {
        return roomProblem;
    }

    public void setRoomProblem(String roomProblem) {
        this.roomProblem = roomProblem;
    }

    public String getRoomMeasure() {
        return roomMeasure;
    }

    public void setRoomMeasure(String roomMeasure) {
        this.roomMeasure = roomMeasure;
    }

    public String getSceneProblem() {
        return sceneProblem;
    }

    public void setSceneProblem(String sceneProblem) {
        this.sceneProblem = sceneProblem;
    }

    public String getSceneMeasure() {
        return sceneMeasure;
    }

    public void setSceneMeasure(String sceneMeasure) {
        this.sceneMeasure = sceneMeasure;
    }

    public String getContractProblem() {
        return contractProblem;
    }

    public void setContractProblem(String contractProblem) {
        this.contractProblem = contractProblem;
    }

    public String getContractMeasure() {
        return contractMeasure;
    }

    public void setContractMeasure(String contractMeasure) {
        this.contractMeasure = contractMeasure;
    }

    public String getOtherProblem() {
        return otherProblem;
    }

    public void setOtherProblem(String otherProblem) {
        this.otherProblem = otherProblem;
    }

    public String getOtherMeasure() {
        return otherMeasure;
    }

    public void setOtherMeasure(String otherMeasure) {
        this.otherMeasure = otherMeasure;
    }

    public BigDecimal getContractTempMny() {
        return contractTempMny;
    }

    public void setContractTempMny(BigDecimal contractTempMny) {
        this.contractTempMny = contractTempMny;
    }

    public BigDecimal getSumFinishMny() {
        return sumFinishMny;
    }

    public void setSumFinishMny(BigDecimal sumFinishMny) {
        this.sumFinishMny = sumFinishMny;
    }

    public List<WeeklyReportDetailVO> getWeeklyReportDetailList() {
        return weeklyReportDetailList;
    }

    public void setWeeklyReportDetailList(List<WeeklyReportDetailVO> weeklyReportDetailList) {
        this.weeklyReportDetailList = weeklyReportDetailList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManager() {
        return projectManager;
    }

    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectDirector() {
        return projectDirector;
    }

    @ReferDeserialTransfer
    public void setProjectDirector(Long projectDirector) {
        this.projectDirector = projectDirector;
    }
    public String getProjectDirectorName() {
        return projectDirectorName;
    }

    public void setProjectDirectorName(String projectDirectorName) {
        this.projectDirectorName = projectDirectorName;
    }
    public Integer getWeeklyNum() {
        return weeklyNum;
    }

    public void setWeeklyNum(Integer weeklyNum) {
        this.weeklyNum = weeklyNum;
    }
    public BigDecimal getLastWeeklyProgress() {
        return lastWeeklyProgress;
    }

    public void setLastWeeklyProgress(BigDecimal lastWeeklyProgress) {
        this.lastWeeklyProgress = lastWeeklyProgress;
    }
    public BigDecimal getWeeklyProgress() {
        return weeklyProgress;
    }

    public void setWeeklyProgress(BigDecimal weeklyProgress) {
        this.weeklyProgress = weeklyProgress;
    }
    public Date getPreFinishDate() {
        return preFinishDate;
    }

    public void setPreFinishDate(Date preFinishDate) {
        this.preFinishDate = preFinishDate;
    }
    public BigDecimal getCostTotalMny() {
        return costTotalMny;
    }

    public void setCostTotalMny(BigDecimal costTotalMny) {
        this.costTotalMny = costTotalMny;
    }
    public BigDecimal getPreCostMny() {
        return preCostMny;
    }

    public void setPreCostMny(BigDecimal preCostMny) {
        this.preCostMny = preCostMny;
    }
    public BigDecimal getFinishOutputMny() {
        return finishOutputMny;
    }

    public void setFinishOutputMny(BigDecimal finishOutputMny) {
        this.finishOutputMny = finishOutputMny;
    }
    public Date getReportDate() {
        return reportDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }
    public BigDecimal getProjPersonEfficiency() {
        return projPersonEfficiency;
    }

    public void setProjPersonEfficiency(BigDecimal projPersonEfficiency) {
        this.projPersonEfficiency = projPersonEfficiency;
    }
    public BigDecimal getConstructionPersonNum() {
        return constructionPersonNum;
    }

    public void setConstructionPersonNum(BigDecimal constructionPersonNum) {
        this.constructionPersonNum = constructionPersonNum;
    }
    public BigDecimal getManagePersonNum() {
        return managePersonNum;
    }

    public void setManagePersonNum(BigDecimal managePersonNum) {
        this.managePersonNum = managePersonNum;
    }
    public String getProjProgress() {
        return projProgress;
    }

    public void setProjProgress(String projProgress) {
        this.projProgress = projProgress;
    }
    public String getWeeklyProblem() {
        return weeklyProblem;
    }

    public void setWeeklyProblem(String weeklyProblem) {
        this.weeklyProblem = weeklyProblem;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getRowSpan() {
        return rowSpan;
    }

    public void setRowSpan(Integer rowSpan) {
        this.rowSpan = rowSpan;
    }


    public Integer getNormalRowSpan() {
        return normalRowSpan;
    }

    public void setNormalRowSpan(Integer normalRowSpan) {
        this.normalRowSpan = normalRowSpan;
    }

    public BigDecimal getAreaOutputMny() {
        return areaOutputMny;
    }

    public void setAreaOutputMny(BigDecimal areaOutputMny) {
        this.areaOutputMny = areaOutputMny;
    }

    public BigDecimal getAreaPersonEfficiency() {
        return areaPersonEfficiency;
    }

    public void setAreaPersonEfficiency(BigDecimal areaPersonEfficiency) {
        this.areaPersonEfficiency = areaPersonEfficiency;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Date getStatisticsDate() {
        return statisticsDate;
    }

    public void setStatisticsDate(Date statisticsDate) {
        this.statisticsDate = statisticsDate;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getReportMonth() {
        return reportMonth;
    }

    public void setReportMonth(Date reportMonth) {
        this.reportMonth = reportMonth;
    }

    public BigDecimal getYearPlanMny() {
        return yearPlanMny;
    }

    public void setYearPlanMny(BigDecimal yearPlanMny) {
        this.yearPlanMny = yearPlanMny;
    }

    public List<WeeklyReportManagerVO> getManagerList() {
        return managerList;
    }

    public void setManagerList(List<WeeklyReportManagerVO> managerList) {
        this.managerList = managerList;
    }
}
