package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 周计划资源排布-计划明细
 * 
 * @author generator
 * 
 */
public class WeekResourceDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String buildingNo; // 楼栋
    private Long partProjectId; // 分部工程Id
    private String partProjectName; // 分部工程名称
    private Long subPartProjectId; // 子分部工程Id
    private String subPartProjectName; // 子分部工程名称
    private Long itemProjectId; // 分项工程Id
    private String itemProjectName; // 分项工程名称
    private String process; // 工序
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginTime; // 开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishTime; // 完成时间
    private Integer oneProcessTime; // 单工序持续时间
    private Long workTypeId; // 工种id
    private String workTypeName; // 工种名称
    private BigDecimal workTypeNum; // 工种人数
    private Long materialId; // 材料需求id
    private String materialName; // 材料需求名称
    private String materialSpec; // 规格型号
    private String materialUnit; // 材料单位
    private Integer materialNum; // 材料数量
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date materialInTime; // 材料进场时间
    private String machineNeed; // 机械需求
    private String memo; // 备注
    private String chargePerson; // 责任人
    private Long weekResourceId; // 周计划资源排布主键
    

    public String getBuildingNo() {
        return buildingNo;
    }

    public void setBuildingNo(String buildingNo) {
        this.buildingNo = buildingNo;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPartProjectId() {
        return partProjectId;
    }
    @ReferDeserialTransfer
    public void setPartProjectId(Long partProjectId) {
        this.partProjectId = partProjectId;
    }
    public String getPartProjectName() {
        return partProjectName;
    }

    public void setPartProjectName(String partProjectName) {
        this.partProjectName = partProjectName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSubPartProjectId() {
        return subPartProjectId;
    }
    @ReferDeserialTransfer
    public void setSubPartProjectId(Long subPartProjectId) {
        this.subPartProjectId = subPartProjectId;
    }
    public String getSubPartProjectName() {
        return subPartProjectName;
    }

    public void setSubPartProjectName(String subPartProjectName) {
        this.subPartProjectName = subPartProjectName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getItemProjectId() {
        return itemProjectId;
    }
    @ReferDeserialTransfer
    public void setItemProjectId(Long itemProjectId) {
        this.itemProjectId = itemProjectId;
    }
    public String getItemProjectName() {
        return itemProjectName;
    }

    public void setItemProjectName(String itemProjectName) {
        this.itemProjectName = itemProjectName;
    }
    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }
    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }
    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }
    public Integer getOneProcessTime() {
        return oneProcessTime;
    }

    public void setOneProcessTime(Integer oneProcessTime) {
        this.oneProcessTime = oneProcessTime;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getWorkTypeId() {
        return workTypeId;
    }
    @ReferDeserialTransfer
    public void setWorkTypeId(Long workTypeId) {
        this.workTypeId = workTypeId;
    }
    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }
    public BigDecimal getWorkTypeNum() {
        return workTypeNum;
    }

    public void setWorkTypeNum(BigDecimal workTypeNum) {
        this.workTypeNum = workTypeNum;
    }
    @ReferSerialTransfer(referCode = "Material001")
    public Long getMaterialId() {
        return materialId;
    }
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }
    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }
    public Integer getMaterialNum() {
        return materialNum;
    }

    public void setMaterialNum(Integer materialNum) {
        this.materialNum = materialNum;
    }
    public Date getMaterialInTime() {
        return materialInTime;
    }

    public void setMaterialInTime(Date materialInTime) {
        this.materialInTime = materialInTime;
    }
    public String getMachineNeed() {
        return machineNeed;
    }

    public void setMachineNeed(String machineNeed) {
        this.machineNeed = machineNeed;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getChargePerson() {
        return chargePerson;
    }

    public void setChargePerson(String chargePerson) {
        this.chargePerson = chargePerson;
    }
    public Long getWeekResourceId() {
        return weekResourceId;
    }

    public void setWeekResourceId(Long weekResourceId) {
        this.weekResourceId = weekResourceId;
    }
    
}
