package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.oa.vo.MonthBudgetFormDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;

/**
 * 月度收支填报主实体
 * 
 * @author generator
 * 
 */
public class MonthBudgetFormVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织id
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date month; // 月份
    private BigDecimal totalUnitSocialSecurityMny; // 单位社保金额
    private BigDecimal totalPersonSocialSecurityMny; // 个人社保金额
    private BigDecimal totalPayMny; // 支出金额
    private BigDecimal totalIncomeMny; // 收入金额
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long deptId; // 经办部门
    private String deptName; // 经办部门名称

    private String billStateName; // 单据状态名称
    
    private List<MonthBudgetFormDetailVO> detailList = new ArrayList<>(); // 月度收支填报-子实体

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public BigDecimal getTotalUnitSocialSecurityMny() {
        return totalUnitSocialSecurityMny;
    }

    public void setTotalUnitSocialSecurityMny(BigDecimal totalUnitSocialSecurityMny) {
        this.totalUnitSocialSecurityMny = totalUnitSocialSecurityMny;
    }
    public BigDecimal getTotalPersonSocialSecurityMny() {
        return totalPersonSocialSecurityMny;
    }

    public void setTotalPersonSocialSecurityMny(BigDecimal totalPersonSocialSecurityMny) {
        this.totalPersonSocialSecurityMny = totalPersonSocialSecurityMny;
    }
    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }
    public BigDecimal getTotalIncomeMny() {
        return totalIncomeMny;
    }

    public void setTotalIncomeMny(BigDecimal totalIncomeMny) {
        this.totalIncomeMny = totalIncomeMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }

    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<MonthBudgetFormDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<MonthBudgetFormDetailVO> detailList) {
        this.detailList = detailList;
    }
}
