package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.oa.vo.WeekResourceDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 周计划资源排布
 * 
 * @author generator
 * 
 */
public class WeekResourceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目名称
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date curMonth; // 所属月份
    private Integer weekNum; // 第几周
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date billDate; // 创建日期
    private Integer billState; // 单据状态（审批必须字段）
    private String remark; // 备注
    private String billCode; // 单据编号
    private String billStateName; //
    
    private List<WeekResourceDetailVO> weekResourceDetailList = new ArrayList<>(); // 周计划资源排布-计划明细

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getCurMonth() {
        return curMonth;
    }

    public void setCurMonth(Date curMonth) {
        this.curMonth = curMonth;
    }
    public Integer getWeekNum() {
        return weekNum;
    }

    public void setWeekNum(Integer weekNum) {
        this.weekNum = weekNum;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getRemark() {
        return remark;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
     public List<WeekResourceDetailVO> getWeekResourceDetailList() {
        return weekResourceDetailList;
     }

     public void setWeekResourceDetailList(List<WeekResourceDetailVO> weekResourceDetailList) {
        this.weekResourceDetailList = weekResourceDetailList;
     }
}
