/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.home.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.home.util.ParamUtil;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonListCallable
implements Callable<JSONArray> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String columns = "*";
    private QueryParam queryParam;
    private IBaseService service;
    private String databaseName;
    private String tableName;
    private String parameter;
    private static ICommenQueryFieldsService commonService;
    private static IBillTypeApi billTypeApi;

    @Autowired
    public void setCommonService(ICommenQueryFieldsService commonService) {
        CommonListCallable.commonService = commonService;
    }

    @Autowired
    public void setBillTypeApi(IBillTypeApi billTypeApi) {
        CommonListCallable.billTypeApi = billTypeApi;
    }

    public CommonListCallable() {
    }

    public static Future<JSONArray> excute(ExecutorService threadPool, QueryParam queryParam, IBaseService service) {
        CommonListCallable callable = new CommonListCallable(queryParam, service);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public CommonListCallable(QueryParam queryParam, IBaseService service) {
        this.queryParam = queryParam;
        this.service = service;
    }

    public static Future<JSONArray> excute(ExecutorService threadPool, QueryParam queryParam, String billTypeCode) {
        CommonResponse billTypeResponse = billTypeApi.queryMetadataByBillType(billTypeCode);
        if (!billTypeResponse.isSuccess()) {
            throw new BusinessException(billTypeResponse.getMsg());
        }
        MdReferVO referVo = (MdReferVO)billTypeResponse.getData();
        String parameter = ParamUtil.paramToString(queryParam.getParams());
        CommonListCallable callable = new CommonListCallable(referVo.getDatabaseName(), referVo.getTableName(), parameter);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public static Future<JSONArray> excute(ExecutorService threadPool, QueryParam queryParam, String databaseName, String tableName) {
        String parameter = ParamUtil.paramToString(queryParam.getParams());
        CommonListCallable callable = new CommonListCallable(databaseName, tableName, parameter);
        Future<JSONArray> future = threadPool.submit(callable);
        return future;
    }

    public CommonListCallable(String databaseName, String tableName, String parameter) {
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.parameter = parameter;
    }

    @Override
    public JSONArray call() throws Exception {
        if (this.service != null) {
            List list = this.service.queryList(this.queryParam, false);
            String json = JSON.toJSONString((Object)list);
            JSONArray records = JSONArray.parseArray((String)json);
            return records;
        }
        this.logger.info("sql====select {} from `{}`.{} where {}", new Object[]{columns, this.databaseName, this.tableName, this.parameter});
        JSONArray array = commonService.queryBillInfoByProperty(this.databaseName, this.tableName, columns, this.parameter);
        return array;
    }
}

