/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.CALockRegisterEntity;
import com.ejianc.business.oa.service.ICALockRegisterService;
import com.ejianc.business.oa.vo.CALockRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"caLockRegister"})
public class CALockRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "CA_LOCK_REGISTER";
    @Autowired
    private ICALockRegisterService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CALockRegisterVO> saveOrUpdate(@RequestBody CALockRegisterVO saveOrUpdateVO) {
        CALockRegisterEntity entity = (CALockRegisterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CALockRegisterEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CALockRegisterVO vo = (CALockRegisterVO)BeanMapper.map((Object)((Object)entity), CALockRegisterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CALockRegisterVO> queryDetail(Long id) {
        CALockRegisterEntity entity = (CALockRegisterEntity)((Object)this.service.selectById(id));
        CALockRegisterVO vo = (CALockRegisterVO)BeanMapper.map((Object)((Object)entity), CALockRegisterVO.class);
        vo.getDetailList().sort(Comparator.comparing(BaseVO::getCreateTime).reversed());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CALockRegisterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CALockRegisterVO cALockRegisterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CALockRegisterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("caLockName");
        fuzzyFields.add("caLockType");
        fuzzyFields.add("headName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CALockRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("caLockName");
        fuzzyFields.add("caLockType");
        fuzzyFields.add("headName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, CALockRegisterVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
            e.setStartFlagName(0 == e.getStartFlag() ? "\u505c\u7528" : "\u542f\u7528");
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("CALockRegister-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCALockRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CALockRegisterVO>> refCALockRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("caLockName");
        fuzzyFields.add("caLockType");
        fuzzyFields.add("headName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        param.getParams().put("startFlag", new Parameter("eq", (Object)1));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), CALockRegisterVO.class);
        voList.forEach(e -> e.setStartFlagName(0 == e.getStartFlag() ? "\u505c\u7528" : "\u542f\u7528"));
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateStartFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateStartFlag(Long id, int startFlag) {
        LambdaUpdateWrapper updateRecordWrapper = new LambdaUpdateWrapper();
        updateRecordWrapper.eq(BaseEntity::getId, (Object)id);
        updateRecordWrapper.set(CALockRegisterEntity::getStartFlag, (Object)startFlag);
        Boolean updateFlag = this.service.update((Wrapper)updateRecordWrapper);
        return CommonResponse.success((String)(updateFlag != false ? "\u4fee\u6539\u5355\u636e\u72b6\u6001\u6210\u529f\uff01" : "\u4fee\u6539\u5355\u636e\u72b6\u6001\u5931\u8d25\uff01"));
    }

    @RequestMapping(value={"/sendCAMsgToPerson"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> sendCAMsgToPerson(HttpServletRequest request) {
        String msgSendResult = this.service.sendCAMsgToPerson();
        return CommonResponse.success((String)"CA\u9501\u5230\u671f\u63d0\u9192\u53d1\u9001\u4fe1\u606f\u6210\u529f\uff01", (Object)msgSendResult);
    }
}

