/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.home.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.home.mapper.HomePortalMapper;
import com.ejianc.business.home.service.IHomePortalService;
import com.ejianc.business.home.util.CommonListCallable;
import com.ejianc.business.home.util.EJCDateUtil;
import com.ejianc.business.home.util.JSONUtils;
import com.ejianc.business.home.vo.MonthProductVO;
import com.ejianc.business.home.vo.ProjectTermNumVO;
import com.ejianc.business.home.vo.RiskProjectVO;
import com.ejianc.business.home.vo.YearProductVO;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.market.vo.StartWorkReportVO;
import com.ejianc.business.oa.bean.WeeklyReportEntity;
import com.ejianc.business.oa.service.IWeeklyReportService;
import com.ejianc.business.project.vo.ReturnPlanDetailVO;
import com.ejianc.business.project.vo.ReturnPlanVO;
import com.ejianc.business.scene.vo.InternalVO;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="ContractService")
public class HomePortalServiceImpl
extends BaseServiceImpl<HomePortalMapper, BaseEntity>
implements IHomePortalService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IWeeklyReportService weekService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<MonthProductVO>> monthProductMny(String status) {
        ProjectRegisterVO project;
        MonthProductVO vo;
        String startMonth = EJCDateUtil.getYear() + "-01-01";
        String endMonth = EJCDateUtil.getYear() + "-12-31";
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("reportMonth", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)param);
        param2.setPageIndex(0);
        param2.setPageSize(-1);
        param2.getParams().put("confirmTime", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        Future<JSONArray> future1 = CommonListCallable.excute(threadPool, param1, this.weekService);
        Future<JSONArray> future2 = CommonListCallable.excute(threadPool, param2, "BT200622000000005");
        List<Object> weekList = new ArrayList();
        List<Object> receiveList = new ArrayList();
        try {
            weekList = JSONUtils.json2List(future1.get().toJSONString(), WeeklyReportEntity.class);
            receiveList = JSONUtils.json2List(future2.get().toJSONString(), ReceiveVO.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Set projectIds = weekList.stream().map(x -> x.getProjectId()).collect(Collectors.toSet());
        projectIds.addAll(receiveList.stream().map(x -> x.getProjectId()).collect(Collectors.toSet()));
        CommonResponse resp = this.projectApi.queryProjectByIds(new ArrayList(projectIds));
        Map<Object, Object> projectMap = new HashMap();
        if (resp.isSuccess() && null != resp.getData()) {
            List projectList = (List)resp.getData();
            if (StringUtils.isNotEmpty((CharSequence)status)) {
                projectList = projectList.stream().filter(x -> status.equals(x.getStatus())).collect(Collectors.toList());
            }
            projectMap = projectList.stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        }
        ArrayList<MonthProductVO> list = new ArrayList<MonthProductVO>();
        for (WeeklyReportEntity weeklyReportEntity : weekList) {
            vo = new MonthProductVO();
            vo.setMonth(EJCDateUtil.format(weeklyReportEntity.getReportMonth(), "yyyy-MM"));
            vo.setProductMny(weeklyReportEntity.getFinishOutputMny());
            vo.setUserNum(weeklyReportEntity.getManagePersonNum());
            if (!projectMap.containsKey(weeklyReportEntity.getProjectId()) || null == (project = (ProjectRegisterVO)projectMap.get(weeklyReportEntity.getProjectId())).getProjectDirector()) continue;
            vo.setProjectDirector(project.getProjectDirector());
            vo.setProjectDirectorName(project.getProjectDirectorName());
            vo.setSourceType("week");
            list.add(vo);
        }
        for (ReceiveVO receiveVO : receiveList) {
            vo = new MonthProductVO();
            vo.setMonth(EJCDateUtil.format(receiveVO.getConfirmTime(), "yyyy-MM"));
            vo.setReceiveMny(receiveVO.getReceiveMny());
            if (!projectMap.containsKey(receiveVO.getProjectId()) || null == (project = (ProjectRegisterVO)projectMap.get(receiveVO.getProjectId())).getProjectDirector()) continue;
            vo.setProjectDirector(project.getProjectDirector());
            vo.setProjectDirectorName(project.getProjectDirectorName());
            vo.setSourceType("receive");
            list.add(vo);
        }
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<String, List<MonthProductVO>>();
        }
        Map<Long, Map<String, List<MonthProductVO>>> map = list.stream().collect(Collectors.groupingBy(x -> x.getProjectDirector(), Collectors.groupingBy(x -> x.getMonth())));
        List<String> list2 = EJCDateUtil.getMonthBetween(startMonth, endMonth);
        LinkedList<MonthProductVO> resultList = new LinkedList<MonthProductVO>();
        for (String month : list2) {
            for (Long userId : map.keySet()) {
                MonthProductVO vo2 = new MonthProductVO();
                vo2.setProjectDirector(userId);
                vo2.setMonth(EJCDateUtil.monthToString(month));
                Map<String, List<MonthProductVO>> monthMap = map.get(userId);
                MonthProductVO data = (MonthProductVO)monthMap.values().stream().flatMap(Collection::stream).findFirst().get();
                vo2.setProjectDirectorName(data.getProjectDirectorName());
                BigDecimal productMny = BigDecimal.ZERO;
                BigDecimal receiveMny = BigDecimal.ZERO;
                BigDecimal userNum = BigDecimal.ZERO;
                if (monthMap.containsKey(month)) {
                    List<MonthProductVO> voList = monthMap.get(month);
                    productMny = voList.stream().map(MonthProductVO::getProductMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                    receiveMny = voList.stream().map(MonthProductVO::getReceiveMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                    BigDecimal sumNum = voList.stream().map(MonthProductVO::getUserNum).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
                    int weekNum = (int)voList.stream().filter(x -> "week".equals(x.getSourceType())).count();
                    userNum = ComputeUtil.safeDiv((BigDecimal)sumNum, (BigDecimal)ComputeUtil.toBigDecimal((Integer)weekNum));
                }
                vo2.setProductMny(ComputeUtil.scale((BigDecimal)productMny, (int)1));
                vo2.setReceiveMny(ComputeUtil.scale((BigDecimal)ComputeUtil.safeDiv((BigDecimal)receiveMny, (BigDecimal)ComputeUtil.toBigDecimal((String)"100")), (int)1));
                vo2.setUserNum(ComputeUtil.scale((BigDecimal)userNum, (int)2));
                BigDecimal userMny = ComputeUtil.safeDiv((BigDecimal)vo2.getProductMny(), (BigDecimal)vo2.getUserNum());
                vo2.setUserMny(ComputeUtil.scale((BigDecimal)userMny, (int)1));
                resultList.add(vo2);
            }
        }
        Map<String, List<MonthProductVO>> result = resultList.stream().collect(Collectors.groupingBy(x -> x.getProjectDirectorName()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectTermNumVO projectTerm() {
        String startMonth = EJCDateUtil.getYear() + "-01-01";
        String endMonth = EJCDateUtil.getYear() + "-12-31";
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("reportMonth", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)param);
        param2.setPageIndex(1);
        param2.setPageSize(-1);
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)param2);
        Future<JSONArray> future1 = CommonListCallable.excute(threadPool, param1, this.weekService);
        Future<JSONArray> future2 = CommonListCallable.excute(threadPool, param2, "BT200528000000002");
        Future<JSONArray> future3 = CommonListCallable.excute(threadPool, param3, "BT220323000000008");
        List<Object> weekList = new ArrayList();
        List<Object> incomeList = new ArrayList();
        List<Object> startList = new ArrayList();
        try {
            weekList = JSONUtils.json2List(future1.get().toJSONString(), WeeklyReportEntity.class);
            incomeList = JSONUtils.json2List(future2.get().toJSONString(), ContractVo.class);
            startList = JSONUtils.json2List(future3.get().toJSONString(), StartWorkReportVO.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Map<Long, WeeklyReportEntity> weekMap = weekList.stream().collect(Collectors.toMap(x -> x.getProjectId(), x -> x, (v1, v2) -> v1.getCreateTime().getTime() < v2.getCreateTime().getTime() ? v2 : v1));
        Map<Long, ContractVo> incomeMap = incomeList.stream().collect(Collectors.toMap(x -> x.getProjectId(), x -> x, (v1, v2) -> v1.getCreateTime().getTime() < v2.getCreateTime().getTime() ? v2 : v1));
        Map<Long, StartWorkReportVO> startMap = startList.stream().collect(Collectors.toMap(x -> x.getProjectId(), x -> x, (v1, v2) -> v1.getCreateTime().getTime() < v2.getCreateTime().getTime() ? v2 : v1));
        HashSet<Long> projectIds = new HashSet<Long>(weekMap.keySet());
        projectIds.addAll(new HashSet<Long>(incomeMap.keySet()));
        projectIds.addAll(new HashSet<Long>(startMap.keySet()));
        ProjectTermNumVO result = new ProjectTermNumVO();
        result.setFinishLessThree(0);
        result.setFinishLessSix(0);
        result.setFinishGreaterSix(0);
        result.setBuildingLessThree(0);
        result.setBuildingLessSix(0);
        result.setBuildingGreaterSix(0);
        for (Long projectId : projectIds) {
            BigDecimal weeklyProgress = BigDecimal.ZERO;
            WeeklyReportEntity week = new WeeklyReportEntity();
            if (weekMap.containsKey(projectId)) {
                week = weekMap.get(projectId);
                weeklyProgress = week.getWeeklyProgress();
            }
            Integer term = 0;
            if (incomeMap.containsKey(projectId)) {
                term = incomeMap.get(projectId).getTerm();
                term = null != term ? term : 0;
            }
            Date estimateEndDate = null;
            if (startMap.containsKey(projectId)) {
                estimateEndDate = startMap.get(projectId).getEstimateEndDate();
            }
            Integer overTerm = EJCDateUtil.daysBetween(week.getStartDate(), week.getPreFinishDate());
            if (null != estimateEndDate) {
                overTerm = EJCDateUtil.daysBetween(week.getStartDate(), estimateEndDate) - term;
            }
            if (ComputeUtil.isLessThan((BigDecimal)weeklyProgress, (BigDecimal)ComputeUtil.toBigDecimal((String)"80"))) {
                if ((overTerm = Integer.valueOf(overTerm - term)) <= 30) {
                    result.setBuildingLessThree(result.getBuildingLessThree() + 1);
                    continue;
                }
                if (overTerm <= 60) {
                    result.setBuildingLessSix(result.getBuildingLessSix() + 1);
                    continue;
                }
                result.setBuildingGreaterSix(result.getBuildingGreaterSix() + 1);
                continue;
            }
            if (overTerm <= 30) {
                result.setFinishLessThree(result.getFinishLessThree() + 1);
                continue;
            }
            if (overTerm <= 60) {
                result.setFinishLessSix(result.getFinishLessSix() + 1);
                continue;
            }
            result.setFinishGreaterSix(result.getFinishGreaterSix() + 1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public YearProductVO yearProductMny() {
        String startMonth = EJCDateUtil.getYear() + "-01-01";
        String endMonth = EJCDateUtil.getYear() + "-12-31";
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        param1.getParams().put("reportMonth", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)param);
        param2.setPageIndex(0);
        param2.setPageSize(-1);
        param2.getParams().put("confirmTime", new Parameter("between", (Object)(startMonth + "," + endMonth)));
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)param);
        Future<JSONArray> future1 = CommonListCallable.excute(threadPool, param1, this.weekService);
        Future<JSONArray> future2 = CommonListCallable.excute(threadPool, param2, "BT200622000000005");
        Future<JSONArray> future3 = CommonListCallable.excute(threadPool, param3, "BT240626000000002");
        List<Object> weekList = new ArrayList();
        List<Object> receiveList = new ArrayList();
        List<Object> returnList = new ArrayList();
        try {
            weekList = JSONUtils.json2List(future1.get().toJSONString(), WeeklyReportEntity.class);
            receiveList = JSONUtils.json2List(future2.get().toJSONString(), ReceiveVO.class);
            returnList = JSONUtils.json2List(future3.get().toJSONString(), ReturnPlanVO.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        List<Object> returnDetailList = new ArrayList();
        List returnIds = returnList.stream().map(x -> x.getId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(returnIds)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("planId", new Parameter("in", returnIds));
            returnDetailList = this.getDetailList(queryParam, "ejc-huakang", "ejc_huakang_project_return_plan_detail", ReturnPlanDetailVO.class);
        }
        BigDecimal finishProductMny = weekList.stream().map(WeeklyReportEntity::getFinishOutputMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        Map<Long, WeeklyReportEntity> weekMap = weekList.stream().collect(Collectors.toMap(x -> x.getProjectId(), x -> x, (v1, v2) -> v1.getCreateTime().getTime() < v2.getCreateTime().getTime() ? v2 : v1));
        BigDecimal planProductMny = weekMap.values().stream().map(WeeklyReportEntity::getYearPlanMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        BigDecimal finishReceiveMny = receiveList.stream().map(ReceiveVO::getReceiveMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        BigDecimal monthFinishReceiveMny = receiveList.stream().filter(x -> EJCDateUtil.isSameMonth(new Date(), x.getConfirmTime())).map(ReceiveVO::getReceiveMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        BigDecimal monthPlanReceiveMny = returnDetailList.stream().filter(x -> EJCDateUtil.isSameMonth(new Date(), x.getYearsDate())).map(ReturnPlanDetailVO::getReturnMoney).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        YearProductVO result = new YearProductVO();
        result.setFinishProductMny(ComputeUtil.scaleTwo((BigDecimal)finishProductMny));
        result.setPlanProductMny(ComputeUtil.scaleTwo((BigDecimal)planProductMny));
        result.setFinishReceiveMny(ComputeUtil.scaleTwo((BigDecimal)finishReceiveMny));
        result.setMonthFinishReceiveMny(ComputeUtil.scaleTwo((BigDecimal)monthFinishReceiveMny));
        result.setMonthPlanReceiveMny(ComputeUtil.scaleTwo((BigDecimal)monthPlanReceiveMny));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RiskProjectVO riskProjectNum() {
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam param1 = (QueryParam)Utils.deepCopy((Object)param);
        QueryParam param2 = (QueryParam)Utils.deepCopy((Object)param);
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)param);
        QueryParam param4 = (QueryParam)Utils.deepCopy((Object)param);
        param4.getParams().put("feeKind", new Parameter("eq", (Object)"1660524376786735105"));
        param4.getParams().put("payStatus", new Parameter("eq", (Object)2));
        Future<JSONArray> future1 = CommonListCallable.excute(threadPool, param1, this.weekService);
        Future<JSONArray> future2 = CommonListCallable.excute(threadPool, param2, "BT240620000000001");
        Future<JSONArray> future3 = CommonListCallable.excute(threadPool, param3, "BT200529000000001");
        Future<JSONArray> future4 = CommonListCallable.excute(threadPool, param4, "BT200611000000017");
        List<Object> weekList = new ArrayList();
        List<Object> internalList = new ArrayList();
        List<Object> subList = new ArrayList();
        List<Object> payList = new ArrayList();
        try {
            weekList = JSONUtils.json2List(future1.get().toJSONString(), WeeklyReportEntity.class);
            internalList = JSONUtils.json2List(future2.get().toJSONString(), InternalVO.class);
            subList = JSONUtils.json2List(future3.get().toJSONString(), ContractVO.class);
            payList = JSONUtils.json2List(future4.get().toJSONString(), PayContractVO.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        Map<Long, WeeklyReportEntity> weekMap = weekList.stream().collect(Collectors.toMap(x -> x.getProjectId(), x -> x, (v1, v2) -> v1.getCreateTime().getTime() < v2.getCreateTime().getTime() ? v2 : v1));
        Map<Long, InternalVO> internalMap = internalList.stream().collect(Collectors.toMap(x -> x.getProjectId(), x -> x, (v1, v2) -> v1.getCreateTime().getTime() < v2.getCreateTime().getTime() ? v2 : v1));
        HashSet<Long> projectIds = new HashSet<Long>(weekMap.keySet());
        projectIds.addAll(new HashSet<Long>(internalMap.keySet()));
        RiskProjectVO result = new RiskProjectVO();
        result.setBlueNum(0);
        result.setYellowNum(0);
        result.setRedNum(0);
        result.setSubNum(0);
        result.setSubRedNum(0);
        for (Long projectId : projectIds) {
            BigDecimal rate;
            BigDecimal weeklyProgress = BigDecimal.ZERO;
            if (weekMap.containsKey(projectId)) {
                weeklyProgress = weekMap.get(projectId).getWeeklyProgress();
            }
            BigDecimal finishedScale = BigDecimal.ZERO;
            if (internalMap.containsKey(projectId)) {
                finishedScale = internalMap.get(projectId).getFinishedScale();
            }
            if (ComputeUtil.isLessThan((BigDecimal)(rate = ComputeUtil.safeSub((BigDecimal)finishedScale, (BigDecimal)weeklyProgress)), (BigDecimal)ComputeUtil.toBigDecimal((String)"10"))) continue;
            if (ComputeUtil.isLessThan((BigDecimal)rate, (BigDecimal)ComputeUtil.toBigDecimal((String)"20"))) {
                result.setBlueNum(result.getBlueNum() + 1);
                continue;
            }
            if (ComputeUtil.isLessThan((BigDecimal)rate, (BigDecimal)ComputeUtil.toBigDecimal((String)"30"))) {
                result.setYellowNum(result.getYellowNum() + 1);
                continue;
            }
            result.setRedNum(result.getRedNum() + 1);
        }
        Set subProjectIds = subList.stream().map(x -> x.getProjectId()).collect(Collectors.toSet());
        result.setSubNum(subProjectIds.size());
        result.setSubRedNum(0);
        for (Long projectId : subProjectIds) {
            List list = subList.stream().filter(x -> projectId.equals(x.getProjectId())).collect(Collectors.toList());
            BigDecimal contractTaxMny = list.stream().map(ContractVO::getContractTaxMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
            BigDecimal sumPayMny = list.stream().map(ContractVO::getSumPayMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
            BigDecimal payRate = ComputeUtil.bigDecimalPercent((BigDecimal)sumPayMny, (BigDecimal)contractTaxMny, (int)2);
            BigDecimal weeklyProgress = BigDecimal.ZERO;
            if (weekMap.containsKey(projectId)) {
                weeklyProgress = weekMap.get(projectId).getWeeklyProgress();
            }
            Boolean flag = false;
            if (ComputeUtil.isLessThan((BigDecimal)ComputeUtil.safeSub((BigDecimal)payRate, (BigDecimal)weeklyProgress), (BigDecimal)BigDecimal.ZERO)) {
                flag = true;
            }
            BigDecimal progressMny = payList.stream().filter(x -> projectId.equals(x.getProjectId())).map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
            BigDecimal progressRate = ComputeUtil.bigDecimalPercent((BigDecimal)progressMny, (BigDecimal)contractTaxMny, (int)2);
            if (ComputeUtil.isGreaterOrEqual((BigDecimal)weeklyProgress, (BigDecimal)ComputeUtil.toBigDecimal((String)"100")) && ComputeUtil.isGreaterThan((BigDecimal)progressRate, (BigDecimal)ComputeUtil.toBigDecimal((String)"90"))) {
                flag = true;
            }
            if (!flag.booleanValue()) continue;
            result.setSubRedNum(result.getSubRedNum() + 1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> getDetailList(QueryParam param, String databaseName, String tableName, Class<T> cls) {
        List<Object> result = new ArrayList();
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        Future<JSONArray> future = CommonListCallable.excute(threadPool, param, databaseName, tableName);
        try {
            result = JSONUtils.json2List(future.get().toJSONString(), cls);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        return result;
    }

    public static void main(String[] args) {
        String startMonth = EJCDateUtil.getYear() + "-01-01";
        String endMonth = EJCDateUtil.getYear() + "-12-31";
        System.out.println(startMonth + " " + endMonth);
        System.out.println(EJCDateUtil.getMonthBetween(startMonth, endMonth));
        ArrayList voList = new ArrayList();
        BigDecimal productMny = voList.stream().map(MonthProductVO::getProductMny).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        System.out.println(productMny.toPlainString());
        String month = EJCDateUtil.format(new Date(), "yyyy-MM");
        System.out.println(EJCDateUtil.isSameMonth(new Date(), EJCDateUtil.parseDate("2024-10-11")));
    }
}

