/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller.api;

import com.ejianc.business.oa.service.IAwardService;
import com.ejianc.business.oa.service.IBidService;
import com.ejianc.business.oa.vo.AwardVO;
import com.ejianc.business.oa.vo.BidDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/oa/"})
public class OaApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private IBidService bidService;
    @Autowired
    private IAwardService awardService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"queryBidDetailList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<BidDetailVO>> queryBidDetailList(@RequestParam(value="opportunityId") Long opportunityId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.bidService.queryBidDetailList(opportunityId));
    }

    @RequestMapping(value={"queryAwardByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AwardVO>> queryAwardByProjectId(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", this.awardService.queryAwardByProjectId(projectId));
    }
}

