/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.WorkLogEntity;
import com.ejianc.business.oa.service.IWorkLogService;
import com.ejianc.business.oa.vo.WorkLogVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workLog"})
public class WorkLogController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String qqWeatherUrl = "https://wis.qq.com/weather/common?source=pc&weather_type=forecast_24h&province=";
    private static final String WORK_LOG_BILL_CODE = "WORK_LOG";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWorkLogService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkLogVO> saveOrUpdate(@RequestBody WorkLogVO saveorUpdateVO) {
        WorkLogEntity entity = (WorkLogEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WorkLogEntity.class));
        if (entity.getId() == null) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getCode())) {
                Long tenantId = InvocationInfoProxy.getTenantid();
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WORK_LOG_BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    entity.setCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            if (entity.getOrgId() == null) {
                entity.setOrgId(InvocationInfoProxy.getOrgId());
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getLoggerName())) {
                entity.setLoggerName(this.sessionManager.getUserContext().getUserName());
            }
            if (entity.getLoggerId() == null) {
                entity.setLoggerId(this.sessionManager.getUserContext().getEmployeeId());
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CommonResponse response = this.attachmentApi.queryListBySourceId(entity.getId(), "BT210525000000001", "photoLog", null);
        if (response.isSuccess()) {
            List attaList = (List)response.getData();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(WorkLogEntity::getPhotoNum, (Object)(CollectionUtils.isEmpty((Collection)attaList) ? 0 : attaList.size()));
            this.service.update((Wrapper)updateWrapper);
        }
        WorkLogVO vo = (WorkLogVO)BeanMapper.map((Object)((Object)entity), WorkLogVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkLogVO> queryDetail(Long id) {
        WorkLogEntity entity = (WorkLogEntity)((Object)this.service.selectById(id));
        WorkLogVO vo = (WorkLogVO)BeanMapper.map((Object)((Object)entity), WorkLogVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkLogVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkLogVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("loggerName");
        fuzzyFields.add("materialEnter");
        fuzzyFields.add("logInfo");
        fuzzyFields.add("existProblem");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkLogVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryWeatherAndLastContent"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryWeatherAndLastContent(@RequestParam(value="p") String p, @RequestParam(value="c") String c, @RequestParam(value="d") String d, HttpServletRequest request) throws UnsupportedEncodingException {
        JSONObject res = new JSONObject();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        String projectId = request.getParameter("projectId");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)projectId)) {
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        param.getOrderMap().put("createTime", "desc");
        List page = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)page)) {
            res.put("logInfo", (Object)((WorkLogEntity)((Object)page.get(0))).getLogInfo());
        } else {
            res.put("logInfo", null);
        }
        String url = "https://wis.qq.com/weather/common?source=pc&weather_type=forecast_24h&province=" + URLEncoder.encode(p, "UTF-8");
        url = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)c) ? url + "&city=" + URLEncoder.encode(p, "UTF-8") : url + "&city=" + URLEncoder.encode(c, "UTF-8");
        String weather = null;
        try {
            weather = ReferHttpClientUtils.get((String)url, (HttpServletRequest)request);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.info("{}{}{}{}", new Object[]{p, c, d, weather});
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)weather)) {
            res.put("weather", (Object)JSONObject.parseObject((String)weather));
        } else {
            res.put("weather", null);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryLastContent"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryLastContent(@RequestParam(value="projectId") String projectId) {
        JSONObject res = new JSONObject();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        if (projectId != null) {
            param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        }
        param.getOrderMap().put("createTime", "desc");
        List page = this.service.queryList(param, false);
        if (ListUtil.isNotEmpty((List)page)) {
            res.put("logInfo", (Object)((WorkLogEntity)((Object)page.get(0))).getLogInfo());
        } else {
            res.put("logInfo", null);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("loggerName");
        fuzzyFields.add("materialEnter");
        fuzzyFields.add("logInfo");
        fuzzyFields.add("existProblem");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage voPage = this.service.queryPage(queryParam, false);
        List list = voPage.getRecords();
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        String fileName = "workLogExport.xlsx";
        ExcelExport.getInstance().exportWithTrans(fileName, beans, response);
    }

    @RequestMapping(value={"/queryWorkTeamReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryWorkTeamReport(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter monthDatePa = (Parameter)param.getParams().get("monthDate");
        if (null == monthDatePa || monthDatePa.getValue() == null) {
            throw new BusinessException("\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String monthDate = String.valueOf(monthDatePa.getValue());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"projectId", "teamName"});
        List<JSONObject> list = this.service.queryWorkTeamReport((Page<JSONObject>)page, wrapper, monthDate);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/excelExportWorkTeamReport"}, method={RequestMethod.POST})
    @ResponseBody
    public void queryWorkTeamReport(@RequestBody QueryParam param, HttpServletResponse response) throws IOException {
        param.setPageIndex(0);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter monthDatePa = (Parameter)param.getParams().get("monthDate");
        if (null == monthDatePa || monthDatePa.getValue() == null) {
            throw new BusinessException("\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String monthDate = String.valueOf(monthDatePa.getValue());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"projectId", "teamName", "logDay"});
        List<JSONObject> list = this.service.queryWorkTeamReport((Page<JSONObject>)page, wrapper, monthDate);
        LinkedList<JSONObject> head = new LinkedList<JSONObject>();
        JSONObject projectHead = new JSONObject();
        projectHead.put("key", (Object)"projectName");
        projectHead.put("name", (Object)"\u9879\u76ee\u540d\u79f0");
        head.add(projectHead);
        JSONObject teamHead = new JSONObject();
        teamHead.put("key", (Object)"teamName");
        teamHead.put("name", (Object)"\u73ed\u7ec4\u540d\u79f0");
        head.add(teamHead);
        int daysInMonth = LocalDate.parse(monthDate + "-01").lengthOfMonth();
        for (int i = 1; i <= daysInMonth; ++i) {
            JSONObject hh = new JSONObject();
            hh.put("key", (Object)(i + "_num"));
            hh.put("name", (Object)(i + "\u53f7"));
            head.add(hh);
        }
        JSONObject totalHead = new JSONObject();
        totalHead.put("key", (Object)"total_num");
        totalHead.put("name", (Object)"\u5408\u8ba1");
        head.add(totalHead);
        int lastColIndex = head.size();
        ServletOutputStream outputStream = response.getOutputStream();
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        sheet.createFreezePane(0, 2, 0, 2);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, lastColIndex - 1));
        XSSFRow row = sheet.createRow(0);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        style.setFillPattern((short)1);
        style.setAlignment((short)2);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue("\u9879\u76ee\u8003\u52e4\u8868" + monthDate);
        cell.setCellStyle((CellStyle)style);
        row = sheet.createRow(1);
        for (int a = 0; a < head.size(); ++a) {
            cell = row.createCell(a);
            cell.setCellValue(((JSONObject)head.get(a)).get((Object)"name").toString());
            cell.setCellStyle((CellStyle)style);
        }
        for (int i = 0; i < lastColIndex; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, sheet.getColumnWidth(i) * 25 / 10);
        }
        XSSFCellStyle dataStyle = workbook.createCellStyle();
        dataStyle.setAlignment((short)3);
        for (int i = 0; i < list.size(); ++i) {
            JSONObject vo = list.get(i);
            row = sheet.createRow(i + 2);
            for (int j = 0; j < lastColIndex; ++j) {
                String key = ((JSONObject)head.get(j)).get((Object)"key").toString();
                cell = row.createCell(j);
                if (key.contains("num")) {
                    if (vo.get((Object)key) != null) {
                        cell.setCellValue((double)Integer.parseInt(vo.get((Object)key).toString()));
                    }
                    cell.setCellStyle((CellStyle)dataStyle);
                    continue;
                }
                String val = vo.get((Object)key) == null ? "" : vo.get((Object)key).toString();
                cell.setCellValue(val);
            }
        }
        workbook.write((OutputStream)outputStream);
    }
}

