/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.MonthBudgetFormDetailEntity;
import com.ejianc.business.oa.bean.MonthBudgetFormEntity;
import com.ejianc.business.oa.service.IMonthBudgetFormDetailService;
import com.ejianc.business.oa.service.IMonthBudgetFormService;
import com.ejianc.business.oa.vo.MonthBudgetFormDetailVO;
import com.ejianc.business.oa.vo.MonthBudgetFormVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"monthBudgetForm"})
public class MonthBudgetFormController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "MONTH_BUDGET_FORM";
    @Autowired
    private IMonthBudgetFormService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMonthBudgetFormDetailService monthBudgetFormDetailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<MonthBudgetFormVO> saveOrUpdate(@RequestBody MonthBudgetFormVO saveOrUpdateVO) {
        List existPersonList;
        if (saveOrUpdateVO.getDetailList().size() > 1) {
            Map<String, List<MonthBudgetFormDetailVO>> detailMap = saveOrUpdateVO.getDetailList().stream().filter(e -> !"del".equals(e.getRowState())).collect(Collectors.groupingBy(MonthBudgetFormDetailVO::getPersonCode));
            for (String personCode : detailMap.keySet()) {
                if (detailMap.get(personCode).size() <= 1) continue;
                return CommonResponse.error((String)("\u4eba\u5458\uff1a" + detailMap.get(personCode).get(0).getPersonName() + " \u91cd\u590d\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
            }
        }
        MonthBudgetFormEntity entity = (MonthBudgetFormEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, MonthBudgetFormEntity.class));
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("person_id", new Parameter("in", entity.getDetailList().stream().map(MonthBudgetFormDetailEntity::getPersonId).collect(Collectors.toList())));
        detailParam.getParams().put("detail_month", new Parameter("eq", (Object)entity.getMonth()));
        if (null != entity.getId()) {
            detailParam.getParams().put("pid", new Parameter("ne", (Object)entity.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(existPersonList = this.monthBudgetFormDetailService.queryList(detailParam))) && existPersonList.size() > 0) {
            List names = existPersonList.stream().map(MonthBudgetFormDetailEntity::getPersonName).collect(Collectors.toList());
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
            return CommonResponse.error((String)("\u4eba\u5458\uff1a" + names + "\uff0c\u5728\u8be5\u6708\u4efd[" + formatter.format(entity.getMonth()) + "]\uff0c\u6709\u91cd\u590d\u5355\u636e\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        MonthBudgetFormVO vo = (MonthBudgetFormVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), MonthBudgetFormVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MonthBudgetFormVO> queryDetail(Long id) {
        MonthBudgetFormEntity entity = (MonthBudgetFormEntity)((Object)this.service.selectById(id));
        MonthBudgetFormVO vo = (MonthBudgetFormVO)BeanMapper.map((Object)((Object)entity), MonthBudgetFormVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthBudgetFormVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MonthBudgetFormVO monthBudgetFormVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MonthBudgetFormVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthBudgetFormVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List voList = BeanMapper.mapList((Iterable)list, MonthBudgetFormVO.class);
        voList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        beans.put("records", voList);
        ExcelExport.getInstance().export("MonthBudgetForm-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMonthBudgetFormData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MonthBudgetFormVO>> refMonthBudgetFormData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MonthBudgetFormVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"MonthBudgetFormDetail-import.xlsx", (String)"\u6708\u5ea6\u6536\u652f\u586b\u62a5-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @RequestMapping(value={"/formDetailExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void formDetailExcelExport(@RequestBody Map paramMap, HttpServletResponse response) {
        String pid = String.valueOf(paramMap.get("pid"));
        MonthBudgetFormEntity monthBudgetFormEntity = (MonthBudgetFormEntity)((Object)this.service.selectById((Serializable)((Object)pid)));
        if (null == monthBudgetFormEntity) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u6b63\u786e\u7684pid\uff01");
        }
        if (CollectionUtils.isEmpty(monthBudgetFormEntity.getDetailList())) {
            throw new BusinessException("\u672a\u627e\u5230\u5bf9\u5e94\u5b50\u8868\uff0c\u8bf7\u68c0\u67e5pid\uff01");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList(monthBudgetFormEntity.getDetailList(), MonthBudgetFormDetailVO.class));
        ExcelExport.getInstance().export("MonthBudgetFormDetail-export.xlsx", beans, response);
    }
}

