package com.ejianc.business.oa.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.CertRecordEntity;
import com.ejianc.business.oa.bean.ManagementEntity;
import com.ejianc.business.oa.service.ICertRecordService;
import com.ejianc.business.oa.service.IManagementService;
import com.ejianc.business.oa.vo.CertRecordListVO;
import com.ejianc.business.oa.vo.CertRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 证照使用记录
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("certRecord")
public class CertRecordController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private ICertRecordService service;
    @Autowired
    private IManagementService managementService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    /**
     * @Description saveOrUpdate 证照申请的借出和归还
     */
    @RequestMapping(value = "/applySaveRecord", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CertRecordVO> applySaveRecord(@RequestBody CertRecordVO saveorUpdateVO) {
        return service.applySaveRecord(saveorUpdateVO);

    }
    /**
     * @Description saveOrUpdate 证照管理的借出和归还
     */
    @RequestMapping(value = "/manageSaveRecord", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CertRecordVO> manageSaveRecord(@RequestBody CertRecordVO saveorUpdateVO) {
        return service.manageSaveRecord(saveorUpdateVO);

    }
    /**
     * @Description saveOrUpdate 证照管理借出和归还的编辑
     */
    @RequestMapping(value = "/manageUpdateRecord", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CertRecordVO> manageUpdateRecord(@RequestBody CertRecordVO saveorUpdateVO) {
        return service.manageUpdateRecord(saveorUpdateVO);

    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CertRecordVO> queryDetail(Long id) {
    	CertRecordEntity entity = service.selectById(id);
    	CertRecordVO vo = BeanMapper.map(entity, CertRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 查询出证照最新操作时间
     * @param id
     */
    @RequestMapping(value = "/getLastOptTime", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CertRecordVO> getLastOptTime(Long id) {
        LambdaQueryWrapper<CertRecordEntity> wrapperCertRecord = Wrappers.<CertRecordEntity>lambdaQuery();
        wrapperCertRecord.eq(CertRecordEntity::getTenantId, InvocationInfoProxy.getTenantid());
        wrapperCertRecord.in(CertRecordEntity::getCertId, id);
        wrapperCertRecord.eq(CertRecordEntity::getOptType, 1);
        wrapperCertRecord.orderByDesc(CertRecordEntity::getCreateTime);
        List<CertRecordEntity> certRecordList = service.list(wrapperCertRecord);

        CertRecordEntity certRecordEntity = null;
        if (ListUtil.isNotEmpty(certRecordList)){
            certRecordEntity =  certRecordList.get(0);
            CertRecordVO vo = BeanMapper.map(certRecordEntity, CertRecordVO.class);
            //查询证照库存地址
            ManagementEntity managementEntity = managementService.selectById(id);
            vo.setAddr(managementEntity.getStorageLocation());
            return CommonResponse.success("查询详情数据成功！",vo);
        }else {
            certRecordEntity =  new CertRecordEntity();
            CertRecordVO vo = BeanMapper.map(certRecordEntity, CertRecordVO.class);
            return CommonResponse.success("查询详情数据成功！",vo);
        }

    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CertRecordVO> vos) {
        service.removeByIds(vos.stream().map(CertRecordVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Description
     * @Param [ids]
     */
    @RequestMapping(value = "/deleteById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteById(@RequestBody CertRecordVO vo) {
        service.deleteById(vo);
        return CommonResponse.success("删除成功！");
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/getOutList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> getOutList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("certName");
        fuzzyFields.add("certCode");
        fuzzyFields.add("userName");
        fuzzyFields.add("memo");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        Page<CertRecordListVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<CertRecordListVO> list = service.getOutList(page,wrapper);

        for (CertRecordListVO certApplyListVO : list){
            Date date = new Date();
            long l = (certApplyListVO.getReturnTime().getTime() - date.getTime())/(24*60*60*1000);
            String returnDay = null;
            if (l >= 0){
                returnDay = l + "天";
            }else {
                returnDay = "延期"+l;
            }
            certApplyListVO.setReturnDay(returnDay);
        }
        JSONObject res = new JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CertRecordVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<CertRecordEntity> page = service.queryPage(param,false);
        IPage<CertRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<Long> recordIds =null;
        if (ListUtil.isNotEmpty(page.getRecords())){
            recordIds = page.getRecords().stream().map(CertRecordEntity::getId).collect(Collectors.toList());
        }
        List<CertRecordVO> certRecordVOS = BeanMapper.mapList(page.getRecords(), CertRecordVO.class);
        //获取图片
        if (ListUtil.isNotEmpty(recordIds)){
            JSONObject paramStr = new JSONObject();
            paramStr.put("sourceIds", recordIds);
            paramStr.put("orderType","asc");
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(paramStr);
            if (listCommonResponse.isSuccess()){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (ListUtil.isNotEmpty(data)){
                    for (CertRecordVO certRecordVO : certRecordVOS){
                        ArrayList<AttachmentVO> attachmentVOS = new ArrayList<>();
                        ArrayList<Long> attachIds = new ArrayList<>();
                        for (AttachmentVO attachmentVO : data){
                            if (certRecordVO.getId().equals(attachmentVO.getSourceId())){
                                attachmentVOS.add(attachmentVO);
                                attachIds.add(attachmentVO.getId());
                            }
                            certRecordVO.setAttachmentVOList(attachmentVOS);
                            certRecordVO.setAttachIds(attachIds);
                        }
                    }
                }
            }else {
                throw new BusinessException("网络异常，获取图片失败，请稍后再试");
            }
        }
        //
        Integer a = 0;
        for (CertRecordVO certRecordVO : certRecordVOS){
            certRecordVO.setType(a);
            a = a + 1;
        }

        pageData.setRecords(certRecordVOS);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
