package com.ejianc.business.oa.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.framework.core.response.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.oa.bean.SealApplyEntity;
import com.ejianc.business.oa.service.ISealApplyService;
import com.ejianc.business.oa.vo.SealApplyExportVO;
import com.ejianc.business.oa.vo.SealApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;

/**
 * 用印申请实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("sealApply")
public class SealApplyController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "seal-use-code001";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISealApplyService service; 
    @Autowired
    private IOrgApi iOrgApi;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SealApplyVO> saveOrUpdate(@RequestBody SealApplyVO saveorUpdateVO) {
        SealApplyEntity entity = BeanMapper.map(saveorUpdateVO, SealApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SealApplyVO vo = BeanMapper.map(entity, SealApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SealApplyVO> queryDetail(Long id) {
    	SealApplyEntity entity = service.selectById(id);
    	SealApplyVO vo = BeanMapper.map(entity, SealApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SealApplyVO> vos) {
        service.removeByIds(vos.stream().map(SealApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SealApplyVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("fileName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("deptName");
        fuzzyFields.add("applier");
        /** 用户隔离 */
        param.getParams().put("createUserCode",new Parameter(QueryParam.EQ,InvocationInfoProxy.getUsercode()));

        IPage<SealApplyEntity> page = service.queryPage(param,false);
        IPage<SealApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SealApplyVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * @Author liyongjia
     * @Date 2020/6/10 导出
     * @Description excelExport
     * @Param [queryParam, response]
     * @Return void
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(100000);
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("fileName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("deptName");
        fuzzyFields.add("applier");

        /** 数据隔离 本下 */
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SealApplyEntity>  voPage = service.queryPage(queryParam,false);
        List<SealApplyEntity> list = voPage.getRecords();
        List<SealApplyExportVO> exportVOS = new ArrayList<>();
        Map<Long,String> defdoc = new HashMap<>();
        list.forEach(vo -> {
        	SealApplyExportVO exportVO = BeanMapper.map(vo, SealApplyExportVO.class);
            if(vo.getApplyDate()!=null){
            	exportVO.setApplyDate(DateFormatUtil.formatDate("yyyy-MM-dd",vo.getApplyDate()));
			}
    		try {
    			if(StringUtils.isNotBlank(vo.getFileTypeName())){
    				exportVO.setFileType(defdoc.get(vo.getFileTypeName()));
    			}else{
    				//获取文件类别
        			if(defdoc.get(vo.getFileType())!=null){
        				exportVO.setFileType(defdoc.get(vo.getFileType()));
        			}else{
        				JSONArray jArray = ReferObjectUtil.getReferEntityValue(vo.getFileType().toString(), "support-defdoc");
        				if(jArray!=null&&jArray.size()>0){
        					JSONObject json = (JSONObject) jArray.get(0);
        					json.get("name").toString();
        					defdoc.put(vo.getFileType(), json.get("name").toString());
        					exportVO.setFileType(json.get("name").toString());
        				}
        			}
    			}
    		} catch(Exception e){
    			exportVO.setFileType(vo.getFileType().toString());
    		}
            //加盖何种公章
    		try {
    			if(StringUtils.isNotBlank(vo.getSealTypeName())){
    				exportVO.setSealType(defdoc.get(vo.getSealTypeName()));
    			}else{
	    			if(defdoc.get(vo.getSealType())!=null){
	    				exportVO.setSealType(defdoc.get(vo.getSealType()));
	    			}else{
	    				JSONArray jArray = ReferObjectUtil.getReferEntityValue(vo.getSealType().toString(), "support-defdoc");
	    				if(jArray!=null&&jArray.size()>0){
	    					JSONObject json = (JSONObject) jArray.get(0);
	    					json.get("name").toString();
	    					defdoc.put(vo.getSealType(), json.get("name").toString());
	    					exportVO.setSealType(json.get("name").toString());
	    				}
	    			}
    			}
    		} catch(Exception e){
    			exportVO.setSealType(vo.getSealType().toString());
    		}
			exportVO.setBillState(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            exportVOS.add(exportVO);
        });
        
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", exportVOS);
        String fileName = "sealApplyExport.xlsx";
        
        ExcelExport.getInstance().export(fileName, beans, response);
    }
	
}
