package com.ejianc.business.oa.controller;

import java.io.IOException;
import java.io.Serializable;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.oa.bean.WorkLogEntity;
import com.ejianc.business.oa.service.IWorkLogService;
import com.ejianc.business.oa.vo.WorkLogVO;

import javax.servlet.http.HttpServletRequest;

/**
 * 施工日志
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("workLog")
public class WorkLogController implements Serializable {
	private static final long serialVersionUID = 1L;

	private final String qqWeatherUrl = "https://wis.qq.com/weather/common?source=pc&weather_type=forecast_24h&province=";

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWorkLogService service;
    @Autowired
    private SessionManager sessionManager;
    
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkLogVO> saveOrUpdate(@RequestBody WorkLogVO saveorUpdateVO) {
    	WorkLogEntity entity = BeanMapper.map(saveorUpdateVO, WorkLogEntity.class);
    	if(entity.getId() == null){
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            entity.setLoggerName(sessionManager.getUserContext().getUserName());
        }
    	service.saveOrUpdate(entity, false);
    	WorkLogVO vo = BeanMapper.map(entity, WorkLogVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkLogVO> queryDetail(Long id) {
    	WorkLogEntity entity = service.selectById(id);
    	WorkLogVO vo = BeanMapper.map(entity, WorkLogVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkLogVO> vos) {
        service.removeByIds(vos.stream().map(WorkLogVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkLogVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<WorkLogEntity> page = service.queryPage(param,false);
        IPage<WorkLogVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkLogVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Author mrsir_wxp
     * @Date 2021/5/27 查询天气 以及 上一次记录内容
     * @Description queryWeatherAndLastContent
     * @Param [p, c, d]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.oa.vo.WorkLogVO>
     */
    @RequestMapping(value = "/queryWeatherAndLastContent", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryWeatherAndLastContent(@RequestParam("p") String p, @RequestParam("c") String c, @RequestParam("d") String d, HttpServletRequest request) throws UnsupportedEncodingException {
        JSONObject res = new JSONObject();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("createUserCode", new Parameter(QueryParam.EQ, InvocationInfoProxy.getUsercode()));
        param.getOrderMap().put("createTime",QueryParam.DESC);
        List<WorkLogEntity> page = service.queryList(param,false);
        if(ListUtil.isNotEmpty(page)){
            res.put("logInfo",page.get(0).getLogInfo());
        }else {
            res.put("logInfo",null);
        }
        String url = qqWeatherUrl+ URLEncoder.encode(p,"UTF-8");
        if(StringUtils.isEmpty(c)){
            url = url +"&city="+URLEncoder.encode(p,"UTF-8");
        }else {
            url = url +"&city="+URLEncoder.encode(c,"UTF-8");
        }
        /*if(StringUtils.isNotEmpty(d)){
            url = url +"&county="+URLEncoder.encode(d,"UTF-8");
        }*/
        String weather = null;
        try {
            weather = ReferHttpClientUtils.get(url,request);
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("{}{}{}{}",p,c,d,weather);
        if(StringUtils.isNotEmpty(weather)){
            res.put("weather",JSONObject.parseObject(weather));
        }else {
            res.put("weather",null);
        }
        return CommonResponse.success("查询详情数据成功！",res);
    }
}
