package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 用印申请实体
 * 
 * @author generator
 * 
 */
public class SealApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private String fileName; // 文件名称
    private Long orgId; // 申请组织id
    private String orgName; // 申请组织
    private String deptName; // 申请部门
    private Long fileType; // 文件类型
    private String fileTypeName; // 文件类型(显示、打印使用)
    private Integer fileNum; // 文件份数
    private Long sealType; // 印章类型
    private String sealTypeName; // 印章类型(显示、打印使用)
    private String applier; // 申请人
    private Long applierId; // 申请人id
    private String projectFlag; // 是否属于项目1属于，0不属于
    private Long projectId; // 项目名称
    private String projectName; // 项目名称
    private String memo; // 用印事由

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 申请日期
     */
    public Date getApplyDate() {
        return applyDate;
    }

    /**
     * 申请日期
     */
    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    /**
     * 文件名称
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * 文件名称
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
    
    /**
     * 申请组织id
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 申请组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 申请组织
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 申请组织
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 申请部门
     */
    public String getDeptName() {
        return deptName;
    }

    /**
     * 申请部门
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    /**
     * 文件类型
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getFileType() {
        return fileType;
    }

    /**
     * 文件类型
     */
    @ReferDeserialTransfer
    public void setFileType(Long fileType) {
        this.fileType = fileType;
    }
    /**
     * 文件份数
     */
    public Integer getFileNum() {
        return fileNum;
    }

    /**
     * 文件份数
     */
    public void setFileNum(Integer fileNum) {
        this.fileNum = fileNum;
    }
    /**
     * 印章类型
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getSealType() {
        return sealType;
    }

    /**
     * 印章类型
     */
    @ReferDeserialTransfer
    public void setSealType(Long sealType) {
        this.sealType = sealType;
    }
    /**
     * 申请人
     */
    public String getApplier() {
        return applier;
    }

    /**
     * 申请人
     */
    public void setApplier(String applier) {
        this.applier = applier;
    }
    /**
     * 申请人id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getApplierId() {
        return applierId;
    }

    /**
     * 申请人id
     */
    @ReferDeserialTransfer
    public void setApplierId(Long applierId) {
        this.applierId = applierId;
    }
    /**
     * 是否属于项目1属于，0不属于
     */
    public String getProjectFlag() {
        return projectFlag;
    }

    /**
     * 是否属于项目1属于，0不属于
     */
    public void setProjectFlag(String projectFlag) {
        this.projectFlag = projectFlag;
    }
    /**
     * 项目名称
     */
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目名称
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 用印事由
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 用印事由
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

	public String getFileTypeName() {
		return fileTypeName;
	}

	public void setFileTypeName(String fileTypeName) {
		this.fileTypeName = fileTypeName;
	}

	public String getSealTypeName() {
		return sealTypeName;
	}

	public void setSealTypeName(String sealTypeName) {
		this.sealTypeName = sealTypeName;
	}
    
}
