/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.op.enums.OpStatusEnum;
import com.ejianc.business.op.enums.OutTypeEnum;
import com.ejianc.business.op.service.IApplyService;
import com.ejianc.business.op.vo.ApplyReportVO;
import com.ejianc.business.op.vo.ApplyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"apply"})
public class ApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IApplyService applyService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO applyVO) {
        ApplyVO vo = this.applyService.insertOrUpdate(applyVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/getBaseInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> getBaseInfo(@RequestParam(value="orgId") Long orgId, @RequestParam(value="openId") String openId) {
        ApplyVO applyVO = this.applyService.getBaseInfo(orgId, openId);
        return CommonResponse.success((String)"\u83b7\u53d6\u9ed8\u8ba4\u4fe1\u606f\u6210\u529f\uff01", (Object)((Object)applyVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(Long id) {
        ApplyVO vo = this.applyService.selectDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/getPower"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> getPower(@RequestParam(value="id") Long id, @RequestParam(value="openId") String openId) {
        return CommonResponse.success((String)"\u626b\u7801\u540e\u83b7\u53d6\u5f53\u524d\u5355\u636e\u64cd\u4f5c\u6743\u9650\u6210\u529f", (Object)this.applyService.getPower(id, openId));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ApplyVO applyVO : vos) {
            }
        }
        this.applyService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("applyDept");
        fuzzyFields.add("applyUser");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter openIdParm = (Parameter)param.getParams().get("openId");
        if (null != openIdParm && null != openIdParm.getValue()) {
            param.getParams().put("openId", new Parameter("sql", (Object)("open_id = '" + openIdParm.getValue() + "'")));
            this.logger.info("queryList params is " + JSONObject.toJSONString((Object)param));
        }
        IPage page = this.applyService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApplyReportVO>> queryReportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("applyDept");
        fuzzyFields.add("applyUser");
        fuzzyFields.add("billCode");
        fuzzyFields.add("name");
        fuzzyFields.add("branchCorpName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ApplyReportVO> list = this.applyService.queryReportPage((Page<ApplyReportVO>)page, wrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExportReport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(10000);
        CommonResponse<IPage<ApplyReportVO>> res = this.queryReportList(param);
        List list = new ArrayList();
        if (res.getData() != null) {
            list = ((IPage)res.getData()).getRecords();
        }
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(vo -> {
                vo.setOpStatusName(OutTypeEnum.getEnumByCode(vo.getOutType()).getDescription());
                vo.setOutTypeName(OpStatusEnum.getEnumByCode(vo.getOpStatus()).getDescription());
            });
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("applyReportExport.xlsx", beans, response);
    }
}

