/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.op.bean.GuardUserEntity;
import com.ejianc.business.op.bean.WechatUserEntity;
import com.ejianc.business.op.enums.WechatErrorEnum;
import com.ejianc.business.op.service.IGuardUserService;
import com.ejianc.business.op.service.IWechatUserService;
import com.ejianc.business.op.util.MD5Utils;
import com.ejianc.business.op.util.PasswordUtils;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.UserOpVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.Base64Util;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Controller
@RequestMapping(value={"wechat"})
public class WechatController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private IThirdSystemApi thirdSystemApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IWechatUserService wechatUserService;
    @Autowired
    private IGuardUserService guardUserService;
    @Autowired
    private IUserApi userApi;

    @RequestMapping(value={"/openId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> openId(@RequestParam(value="code") String code) {
        return CommonResponse.success(this.weChatUtil.oauth2GetOpenid(code));
    }

    private String anaLogin(HttpServletRequest request) {
        String authority;
        block5: {
            authority = "";
            CommonResponse thirdSystemVO = this.thirdSystemApi.getOneByCode("ZZYJ");
            this.logger.info("thirdSystemVO " + JSONObject.toJSONString((Object)thirdSystemVO.getData()));
            try {
                if (thirdSystemVO.isSuccess() && thirdSystemVO.getData() != null) {
                    HashMap<String, Long> params = new HashMap<String, Long>();
                    params.put("tenantId", ((ThirdSystemVO)thirdSystemVO.getData()).getTenantId());
                    this.logger.info("baseHost " + this.baseHost);
                    String back = HttpTookit.get((String)(this.baseHost + "ejc-idm-web/user/context/getBytenantid"), params, (HttpServletRequest)request);
                    JSONObject jsonBack = JSONObject.parseObject((String)back);
                    if (jsonBack.get((Object)"data") != null) {
                        JSONObject data = (JSONObject)jsonBack.get((Object)"data");
                        this.logger.info("data  " + data.toJSONString());
                        if (data.get((Object)"userContext") != null) {
                            JSONObject userContext = (JSONObject)data.get((Object)"userContext");
                            authority = "userType=" + userContext.getString("userType") + ";userCode=" + userContext.getString("userCode") + ";orgId=" + userContext.getString("orgId") + ";tenantid=" + userContext.getString("tenantid") + ";token=" + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints") + ";u_usercode=" + userContext.getString("u_usercode") + ";userId=" + userContext.getString("userId");
                        }
                    }
                    break block5;
                }
                throw new BusinessException("\u6839\u636e\u7cfb\u7edfcode\uff1aZJWJ\u83b7\u53d6\u7b2c\u4e09\u65b9\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25");
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
        }
        this.logger.info("anaLogin" + authority);
        return authority;
    }

    private String realLogin(UserVO userVO) {
        String authority = "";
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("loginName", (Object)Base64Util.encode((byte[])userVO.getUserCode().getBytes()));
        jsonObject.put("password", (Object)userVO.getPassword());
        jsonObject.put("needResolvePwd", (Object)false);
        try {
            String back = HttpTookit.postByJson((String)(this.baseHost + "ejc-idm-web/user/context/get"), (String)jsonObject.toJSONString());
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            if (jsonBack.get((Object)"data") != null) {
                JSONObject data = (JSONObject)jsonBack.get((Object)"data");
                this.logger.info("data  " + data.toJSONString());
                if (data.get((Object)"userContext") != null) {
                    JSONObject userContext = (JSONObject)data.get((Object)"userContext");
                    authority = "userType=" + userContext.getString("userType") + ";userCode=" + userContext.getString("userCode") + ";orgId=" + userContext.getString("orgId") + ";tenantid=" + userContext.getString("tenantid") + ";token=" + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints") + ";u_usercode=" + userContext.getString("u_usercode") + ";userId=" + userContext.getString("userId");
                }
            } else {
                this.logger.info(back);
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
        }
        this.logger.info("realLogin" + authority);
        return authority;
    }

    @RequestMapping(value={"/wechatlogin"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UserOpVO> wechatlogin(@RequestBody UserOpVO userOpVO, HttpServletRequest request) {
        this.logger.info("wechatlogin : openid" + userOpVO.getOpenId());
        if (StringUtils.isBlank((CharSequence)userOpVO.getOpenId())) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38,\u672a\u83b7\u53d6openid\uff01");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WechatUserEntity::getOpenId, (Object)userOpVO.getOpenId());
        wrapper.eq(WechatUserEntity::getBindStatus, (Object)1);
        WechatUserEntity wechatUserEntity = (WechatUserEntity)((Object)this.wechatUserService.getOne((Wrapper)wrapper, false));
        if (null == wechatUserEntity) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(GuardUserEntity::getOpenId, (Object)userOpVO.getOpenId());
            queryWrapper.eq(GuardUserEntity::getBindStatus, (Object)1);
            GuardUserEntity guardUserEntity = (GuardUserEntity)((Object)this.guardUserService.getOne((Wrapper)queryWrapper, false));
            if (null == guardUserEntity) {
                userOpVO.setInsideFlag(3);
                userOpVO.setAuthority(this.anaLogin(request));
                return CommonResponse.success((String)"\u6e38\u5ba2\u7528\u6237\u767b\u5f55\u6210\u529f", (Object)((Object)userOpVO));
            }
            if (1 == guardUserEntity.getCloseStatus()) {
                return CommonResponse.error((int)WechatErrorEnum.\u8be5\u7528\u6237\u5df2\u505c\u7528.getCode(), (String)"\u8be5\u7528\u6237\u5df2\u505c\u7528");
            }
            userOpVO.setInsideFlag(0);
            userOpVO.setGuardUserId(guardUserEntity.getId());
            userOpVO.setUserName(guardUserEntity.getUserName());
            userOpVO.setName(guardUserEntity.getName());
            userOpVO.setAuthority(this.anaLogin(request));
            return CommonResponse.success((String)"\u95e8\u5c97\u7528\u6237\u767b\u5f55\u6210\u529f", (Object)((Object)userOpVO));
        }
        String authority = this.anaLogin(request);
        RequestContextHolder.getRequestAttributes().setAttribute("authority", (Object)authority, 0);
        RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes());
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        CommonResponse response = this.userApi.findUserByUserId(wechatUserEntity.getUserId());
        if (!response.isSuccess() || null == response.getData()) {
            this.logger.error("wechatlogin" + JSONObject.toJSONString((Object)response));
            return CommonResponse.error((int)WechatErrorEnum.\u8d26\u53f7\u4e0d\u5b58\u5728.getCode(), (String)"\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        UserVO userVO = (UserVO)response.getData();
        if (0 == userVO.getUserState()) {
            return CommonResponse.error((int)WechatErrorEnum.\u8be5\u7528\u6237\u5df2\u505c\u7528.getCode(), (String)"\u8be5\u7528\u6237\u5df2\u505c\u7528");
        }
        userOpVO.setInsideFlag(1);
        userOpVO.setUserId(userVO.getId());
        userOpVO.setUserName(userVO.getUserCode());
        userOpVO.setName(userVO.getUserName());
        userOpVO.setAuthority(this.realLogin(userVO));
        return CommonResponse.success((String)"\u5185\u90e8\u7528\u6237\u767b\u5f55\u6210\u529f", (Object)((Object)userOpVO));
    }

    @RequestMapping(value={"/bindWechat"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UserOpVO> bindWechat(@RequestBody UserOpVO userOpVO, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)userOpVO.getOpenId())) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38,\u672a\u83b7\u53d6openid\uff01");
        }
        if (0 == userOpVO.getInsideFlag()) {
            return this.bindGuardUser(userOpVO, true, request);
        }
        return this.bindInUser(userOpVO, true, request);
    }

    private CommonResponse<UserOpVO> bindGuardUser(UserOpVO userOpVO, Boolean isBind, HttpServletRequest request) {
        if (isBind.booleanValue()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(GuardUserEntity::getUserName, (Object)userOpVO.getUserName());
            GuardUserEntity guardUserEntity = (GuardUserEntity)((Object)this.guardUserService.getOne((Wrapper)wrapper, false));
            if (null == guardUserEntity) {
                return CommonResponse.error((int)WechatErrorEnum.\u8d26\u53f7\u4e0d\u5b58\u5728.getCode(), (String)"\u8d26\u53f7\u4e0d\u5b58\u5728");
            }
            if (!guardUserEntity.getPwd().equals(MD5Utils.getStringMD5(MD5Utils.getStringMD5(userOpVO.getPassword())))) {
                return CommonResponse.error((int)WechatErrorEnum.\u5bc6\u7801\u9519\u8bef.getCode(), (String)"\u5bc6\u7801\u9519\u8bef");
            }
            if (1 == guardUserEntity.getCloseStatus()) {
                return CommonResponse.error((int)WechatErrorEnum.\u8be5\u7528\u6237\u5df2\u505c\u7528.getCode(), (String)"\u8be5\u7528\u6237\u5df2\u505c\u7528");
            }
            guardUserEntity.setBindStatus(1);
            guardUserEntity.setOpenId(userOpVO.getOpenId());
            this.guardUserService.updateById((Object)guardUserEntity);
            userOpVO.setInsideFlag(0);
            userOpVO.setGuardUserId(guardUserEntity.getId());
            userOpVO.setUserName(guardUserEntity.getUserName());
            userOpVO.setName(guardUserEntity.getName());
            userOpVO.setAuthority(this.anaLogin(request));
            return CommonResponse.success((String)"\u95e8\u5c97\u7528\u6237\u7ed1\u5b9a\u6210\u529f", (Object)((Object)userOpVO));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(GuardUserEntity::getOpenId, (Object)userOpVO.getOpenId());
        GuardUserEntity guardUserEntity = (GuardUserEntity)((Object)this.guardUserService.getOne((Wrapper)wrapper, false));
        if (null == guardUserEntity) {
            return CommonResponse.error((int)WechatErrorEnum.OPENID\u672a\u7ed1\u5b9a.getCode(), (String)"\u8be5OPENID\u672a\u7ed1\u5b9a");
        }
        guardUserEntity.setBindStatus(0);
        guardUserEntity.setOpenId(null);
        this.guardUserService.updateById((Object)guardUserEntity);
        return CommonResponse.success((String)"\u95e8\u5c97\u7528\u6237\u89e3\u7ed1\u6210\u529f", (Object)((Object)userOpVO));
    }

    private CommonResponse<UserOpVO> bindInUser(UserOpVO userOpVO, Boolean isBind, HttpServletRequest request) {
        if (isBind.booleanValue()) {
            String authority = this.anaLogin(request);
            RequestContextHolder.getRequestAttributes().setAttribute("authority", (Object)authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes());
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
            UserVO userVO = null;
            CommonResponse response = this.userApi.queryUserByUserCode(userOpVO.getUserName());
            if (!response.isSuccess() || null == response.getData()) {
                CommonResponse res = this.userApi.findByUserMobile(userOpVO.getUserName());
                if (!res.isSuccess() || null == res.getData()) {
                    this.logger.error("bindInUser" + JSONObject.toJSONString((Object)response));
                    return CommonResponse.error((int)WechatErrorEnum.\u8d26\u53f7\u4e0d\u5b58\u5728.getCode(), (String)"\u8d26\u53f7\u4e0d\u5b58\u5728");
                }
                userVO = (UserVO)res.getData();
            } else {
                userVO = (UserVO)response.getData();
            }
            String encryPassword = PasswordUtils.encodePasswordByUserCode(PasswordUtils.encodePasswordUsingSHA(userOpVO.getPassword()), userVO.getSalt(), userVO.getUserCode());
            if (!userVO.getPassword().equals(encryPassword)) {
                return CommonResponse.error((int)WechatErrorEnum.\u5bc6\u7801\u9519\u8bef.getCode(), (String)"\u5bc6\u7801\u9519\u8bef");
            }
            if (0 == userVO.getUserState()) {
                return CommonResponse.error((int)WechatErrorEnum.\u8be5\u7528\u6237\u5df2\u505c\u7528.getCode(), (String)"\u8be5\u7528\u6237\u5df2\u505c\u7528");
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(WechatUserEntity::getUserId, (Object)userVO.getId());
            WechatUserEntity wechatUserEntity = (WechatUserEntity)((Object)this.wechatUserService.getOne((Wrapper)wrapper, false));
            if (null == wechatUserEntity) {
                wechatUserEntity = new WechatUserEntity();
            }
            wechatUserEntity.setBindStatus(1);
            wechatUserEntity.setOpenId(userOpVO.getOpenId());
            wechatUserEntity.setUserId(userVO.getId());
            this.wechatUserService.saveOrUpdate((Object)wechatUserEntity, false);
            userOpVO.setInsideFlag(1);
            userOpVO.setUserId(userVO.getId());
            userOpVO.setUserName(userVO.getUserCode());
            userOpVO.setName(userVO.getUserName());
            userOpVO.setAuthority(this.realLogin(userVO));
            return CommonResponse.success((String)"\u5185\u90e8\u7528\u6237\u7ed1\u5b9a\u6210\u529f", (Object)((Object)userOpVO));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(WechatUserEntity::getOpenId, (Object)userOpVO.getOpenId());
        WechatUserEntity wechatUserEntity = (WechatUserEntity)((Object)this.wechatUserService.getOne((Wrapper)wrapper, false));
        if (null == wechatUserEntity) {
            return CommonResponse.error((int)WechatErrorEnum.OPENID\u672a\u7ed1\u5b9a.getCode(), (String)"\u8be5OPENID\u672a\u7ed1\u5b9a");
        }
        wechatUserEntity.setBindStatus(0);
        wechatUserEntity.setOpenId(null);
        this.wechatUserService.updateById((Object)wechatUserEntity);
        return CommonResponse.success((String)"\u5185\u90e8\u7528\u6237\u89e3\u7ed1\u6210\u529f", (Object)((Object)userOpVO));
    }

    @RequestMapping(value={"/unBindWechat"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<UserOpVO> unBindWechat(@RequestBody UserOpVO userOpVO, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)userOpVO.getOpenId())) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38,\u672a\u83b7\u53d6openid\uff01");
        }
        if (0 == userOpVO.getInsideFlag()) {
            return this.bindGuardUser(userOpVO, false, request);
        }
        return this.bindInUser(userOpVO, false, request);
    }
}

