/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.op.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.op.bean.ConfigEntity;
import com.ejianc.business.op.enums.BooleanStatusEnum;
import com.ejianc.business.op.mapper.ConfigMapper;
import com.ejianc.business.op.service.IConfigService;
import com.ejianc.business.op.util.WeChatUtil;
import com.ejianc.business.op.vo.ConfigVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="configService")
public class ConfigServiceImpl
extends BaseServiceImpl<ConfigMapper, ConfigEntity>
implements IConfigService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectPoolApi projectApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public ConfigVO createQRCode(Long orgId) {
        CommonResponse commonResponse = this.projectApi.queryProjectByProjectDepartmentId(orgId);
        String accessroken = null;
        if (null == this.redisTemplate.opsForValue().get((Object)"op_access_token")) {
            accessroken = this.weChatUtil.getAccesstoken();
            if (!StringUtils.isEmpty((CharSequence)accessroken)) {
                this.redisTemplate.opsForValue().set((Object)"op_access_token", (Object)accessroken, 90L, TimeUnit.MINUTES);
            }
            this.logger.info("\u83b7\u53d6accessroken:" + accessroken);
        } else {
            accessroken = this.redisTemplate.opsForValue().get((Object)"op_access_token").toString();
            this.logger.info("\u83b7\u53d6accessroken:=====" + accessroken);
        }
        String baseAddr = null;
        baseAddr = this.baseHost.contains("17elian") ? "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/" : this.baseHost;
        ConfigEntity config = new ConfigEntity();
        config.setId(IdWorker.getId());
        config.setProjectId(((ProjectVO)commonResponse.getData()).getId());
        config.setOrgId(orgId);
        config.setCloseStatus(BooleanStatusEnum.\u5426.getCode());
        config.setGuardStatus(BooleanStatusEnum.\u662f.getCode());
        config.setPhotoStatus(BooleanStatusEnum.\u662f.getCode());
        String path = "pages/newcard/newcard?orgId=" + orgId;
        String multipartFile = this.weChatUtil.createLongQRCodeStr(path, String.valueOf(orgId), accessroken);
        config.setQrcode(baseAddr + this.dealImg(multipartFile, config));
        this.saveOrUpdate((Object)config, false);
        return (ConfigVO)((Object)BeanMapper.map((Object)((Object)config), ConfigVO.class));
    }

    @Override
    public ConfigVO queryDetailByOrgId(Long orgId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(ConfigEntity::getOrgId, (Object)orgId);
        return (ConfigVO)((Object)BeanMapper.map((Object)this.getOne((Wrapper)queryWrapper, false), ConfigVO.class));
    }

    private String dealImg(String file, ConfigEntity configEntity) {
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202209000017");
        attachmentVO.setSourceId(String.valueOf(configEntity.getId()));
        attachmentVO.setSourceType("EJCBT202209000017");
        attachmentVO.setFileList(Arrays.asList(file));
        this.logger.info(JSON.toJSONString((Object)attachmentVO));
        CommonResponse listCommonResponse = this.attachmentApi.uploadForBase64(attachmentVO);
        this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u524d:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return ((AttachmentVO)((List)listCommonResponse.getData()).get(0)).getFilePath();
        }
        return null;
    }
}

