package com.ejianc.business.other.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.hystrix.OtherContractHystrix;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * 获取合同参照工厂类方法
 *
 * @author yqls
 */
@FeignClient(name = "ejc-other-web", url = "${common.env.feign-client-url}", path = "ejc-other-web", fallback = OtherContractHystrix.class)
public interface IOtherContractApi {


    /**
     * 根据条件查询不同合同类型的合同
     * @return
     */
    @GetMapping(value = "/api/other/getOtherContractById")
    public CommonResponse<ContractResVO> getContractById(@RequestParam(value = "contractId", required = true) Long contractId);


    /**
     * 查其他合同结算
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/api/other/getMonthOtherMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OtherProjectReportVo>> getMonthOtherMny(@RequestParam(value = "projectId") Long projectId,
                                                                       @RequestParam(value = "lastDay") Integer lastDay);

    /**
     * 查其他支出合同数量，金额，结算金额
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "/api/other/getOtherContract")
    @ResponseBody
    public CommonResponse<OtherProjectReportVo> getOtherContract(@RequestParam(value = "projectId") Long projectId);


    /**
     * 回写其它支出合同累计付款金额、累计预付款金额
     * @param contractId
     * @param payMny 本期支付金额，正为回写，负为逆回写
     * @param prepayMny 本期预付款金额，正为回写，负为逆回写
     * @return
     */
    @GetMapping(value = "/api/other/updateOtherContractSumPayMny")
    CommonResponse<String> updateOtherContractSumPayMny(@RequestParam(value="contractId", required=true) Long contractId,
                                                       @RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny);



    /**
     * 回写设备租赁结算单累计付款金额
     * @param settleId 结算单id
     * @param payMny 本期支付金额，正为回写，负为逆回写
     * @return
     */
    @GetMapping(value = "/api/other/updateOtherSettleSumPayMny")
    CommonResponse<String> updateOtherSettleSumPayMny(@RequestParam(value="settleId", required=true) Long settleId,
                                                     @RequestParam("payMny") BigDecimal payMny);


    /**
     * 回写其它支出结算单累计申请金额、剩余可申请金额
     *
     * @param settleId 结算单id
     * @param applyMny 本期申请金额，正为回写，负为逆回写
     * @return
     */
    @GetMapping(value = "/api/other/updateOtherSettleSumApplyMny")
    CommonResponse<String> updateOtherSettleSumApplyMny(@RequestParam(value = "settleId", required = true) Long settleId,
                                                       @RequestParam("applyMny") BigDecimal applyMny);


    /**
     * 根据条件查询结算单累计冲抵金额
     * @return
     */
    @GetMapping(value = "/api/other/getOtherSettlementById")
    public CommonResponse<OtherSettleVO> getOtherSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId);


    /**
     * @Description 收票审批通过后更新其它支出合同合同开票金额等字段
     * @Param contractId  合同id
     * @Param invoiceMny、invoiceTaxMny  收票金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value = "/api/other/otherAfterApproveInvoiceReceive")
    CommonResponse<String> otherAfterApproveInvoiceReceive(@RequestParam(value = "contractId", required = true) Long contractId,
                                                          @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);


    /**
     * @Description 收票弃审通过后更新其它支出合同合同开票金额等字段
     * @Param contractId  合同id
     * @Param invoiceMny、invoiceTaxMny  收票金额
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value = "/api/other/otherAfterRevocationInvoiceReceive")
    CommonResponse<JSONObject> otherAfterRevocationInvoiceReceive(@RequestParam(value = "contractId", required = true) Long contractId,
                                                                 @RequestParam("invoiceMny") BigDecimal invoiceMny, @RequestParam("invoiceTaxMny") BigDecimal invoiceTaxMny);


    /**
     * 根据项目id统计费用报销、备用金报销、零星付款申请
     */
    @GetMapping(value = "/api/other/budgetControlTotal")
    public CommonResponse<BigDecimal> budgetControlTotal(@RequestParam(value = "projectId", required = true)Long projectId);

    /**
     * 查其他支出合同金额
     *
     * @param projectIds
     *
     * @return
     */
    @PostMapping(value = "/api/other/getContractMnyByProjectIds")
    @ResponseBody
    public CommonResponse<OtherProjectReportVo> getContractMnyByProjectIds(@RequestBody List<Long> projectIds);

    @PostMapping(value = "/api/other/getContractByCondition")
    @ResponseBody
    CommonResponse<List<OtherContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds);

    @GetMapping(value = "/api/other/fetchSjzcje")
    CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value = "projectId") Long projectId);
}
