package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractChangeEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.history.SupplementHistoryVo;
import com.ejianc.business.other.service.IOtherContractChangeService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.vo.SupplementDetailVO;
import com.ejianc.business.other.vo.SupplementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.SupplementMapper;
import com.ejianc.business.other.bean.SupplementEntity;
import com.ejianc.business.other.service.ISupplementService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 补充协议实体
 * 
 * @author generator
 * 
 */
@Service("supplementService")
public class SupplementServiceImpl extends BaseServiceImpl<SupplementMapper, SupplementEntity> implements ISupplementService{
    private static final String SUPPLEMENT_BILL_CODE = "OTHER_SUPPLEMENT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherContractChangeService changeService;

    @Override
    public SupplementVO addConvertByConId(Long id) {
        OtherContractEntity contractVO = contractService.selectById(id);
        SupplementVO supplementVO = new SupplementVO();
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setTaxRate(contractVO.getTaxRate());
        supplementVO.setSupplementFlag(1);
        //supplementVO.setContractStatus(2);
        supplementVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        supplementVO.setMainContractId(contractVO.getId());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractName(contractVO.getContractName());
        return supplementVO;
    }

    @Override
    public CommonResponse<SupplementVO> saveOrUpdate(SupplementVO contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SupplementEntity entity = null;
        String operateType = null;

        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<SupplementEntity> lambdaQuery = Wrappers.<SupplementEntity>lambdaQuery();
        lambdaQuery.eq(SupplementEntity::getTenantId, tenantId);
        lambdaQuery.eq(SupplementEntity::getMainContractId, contractVo.getMainContractId());
        if(contractVo.getId() != null && contractVo.getId() > 0) {
            lambdaQuery.ne(SupplementEntity::getId, contractVo.getId());
        }
        lambdaQuery.ne(SupplementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdaQuery);
        if(num > 0){
            throw new BusinessException("该合同已存在未生效的补充协议!");
        }

        //补充协议只能存在一条未生效的
        LambdaQueryWrapper<OtherContractChangeEntity> lambdachange = Wrappers.<OtherContractChangeEntity>lambdaQuery();
        lambdachange.eq(OtherContractChangeEntity::getTenantId, tenantId);
        lambdachange.eq(OtherContractChangeEntity::getContractId, contractVo.getMainContractId());
        lambdachange.ne(OtherContractChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(OtherContractChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = changeService.count(lambdachange);
        if(changeNum > 0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        if(StringUtils.isEmpty(contractVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(SUPPLEMENT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                contractVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if (contractVo.getId() != null && contractVo.getId() > 0) { //修改
            entity = BeanMapper.map(contractVo, SupplementEntity.class);
            operateType = "edit";
        } else {
            //新增
            entity = BeanMapper.map(contractVo, SupplementEntity.class);
            operateType = "add";
        }

        List<SupplementEntity> entities = null;
        if(contractVo.getId() != null && contractVo.getId() > 0) {
            //修改 校验合同编号唯一
            LambdaQueryWrapper<SupplementEntity> lambda = Wrappers.<SupplementEntity>lambdaQuery();
            lambda.eq(SupplementEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(SupplementEntity::getTenantId, tenantId);
            lambda.ne(SupplementEntity::getId, contractVo.getId());
            entities = super.list(lambda);
        }else{
            LambdaQueryWrapper<SupplementEntity> lambda = Wrappers.<SupplementEntity>lambdaQuery();
            lambda.eq(SupplementEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(SupplementEntity::getTenantId, tenantId);
            entities = super.list(lambda);
        }

        if(entities != null && entities.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        super.saveOrUpdate(entity, false);

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public SupplementVO queryDetail(Long id) {
        SupplementEntity entity = super.selectById(id);
        SupplementVO vo = BeanMapper.map(entity, SupplementVO.class);
        List<SupplementDetailVO> detailVos = vo.getDetailVos();
        List<SupplementDetailVO> detail = new ArrayList<>();
        if (detailVos != null && detailVos.size() > 0) {
            for (SupplementDetailVO dvo : detailVos) {
                if (dvo.getChangeType() == null || dvo.getChangeType() != 5) {
                    detail.add(dvo);
                }
            }
        }
        vo.setDetailVos(detail);
        return vo;
    }

    @Override
    public SupplementHistoryVo queryDetailRecord(Long id) {
        OtherContractEntity contractEntity = contractService.selectById(id);
        LambdaQueryWrapper<SupplementEntity> lambdaQuery = Wrappers.<SupplementEntity>lambdaQuery();
        lambdaQuery.eq(SupplementEntity::getMainContractId, id);
        lambdaQuery.ne(SupplementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        int supnum = super.count(lambdaQuery);
        SupplementHistoryVo recordVO = new SupplementHistoryVo();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        recordVO.setContractId(id);
        if (supnum > 0) {
            recordVO.setSupplementFlag(1);
        } else {
            recordVO.setSupplementFlag(0);
        }
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setBaseTaxMoney(baseTaxMny);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        recordVO.setIsFinish(contractEntity.getIsFinish());
        LambdaQueryWrapper<SupplementEntity> lambda = Wrappers.<SupplementEntity>lambdaQuery();
        lambda.eq(SupplementEntity::getMainContractId, id);
        lambda.orderByDesc(SupplementEntity::getSignDate);
        List<SupplementEntity> entities = super.list(lambda);
        recordVO.setDetailList(BeanMapper.mapList(entities, SupplementVO.class));
        return recordVO;
    }
}
