package com.ejianc.business.other.api;


import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/other/")
public class OtherContractApi {

    @Autowired
    private IOtherContractService otherContractService;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private ICustomerApi customerApi;

    /**
     * 租赁合同跳转收票, 根据主键查询合同相关信息
     * @param contractId
     * @return
     */
    @GetMapping(value = "/getOtherContractById")
    public CommonResponse<ContractResVO> getOtherContractById(@RequestParam("contractId") Long contractId) {
        OtherContractEntity otherContractEntity = otherContractService.selectById(contractId);
        ContractResVO otherContractVO = BeanMapper.map(otherContractEntity, ContractResVO.class);
        if (null != otherContractEntity) {
            CommonResponse<SupplierVO> supplierVOCommonResponse = supplierApi.queryById(otherContractEntity.getSupplierId());
            if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
                otherContractVO.setSupplierCreditCode(supplierVOCommonResponse.getData().getSocialCreditCode());
            }
            CommonResponse<CustomerVO> customerVOCommonResponse = customerApi.detailById(otherContractEntity.getCustomerId());
            if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
                otherContractVO.setCustomerCreditCode(customerVOCommonResponse.getData().getSocialCreditCode());
            }
        } else {
            return CommonResponse.error("获取合同信息失败!");
        }
        return CommonResponse.success("获取合同信息成功", otherContractVO);
    }


}
