package com.ejianc.business.other.api;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

@RestController
@RequestMapping("/api/other/")
public class OtherContractApi {

    @Autowired
    private IOtherContractService otherContractService;

    @Autowired
    private IOtherSettleService otherSettleService;

    @Autowired
    private ISupplierApi supplierApi;

    @Autowired
    private ICustomerApi customerApi;

    /**
     * 租赁合同跳转收票, 根据主键查询合同相关信息
     * @param contractId
     * @return
     */
    @GetMapping(value = "/getOtherContractById")
    public CommonResponse<ContractResVO> getOtherContractById(@RequestParam("contractId") Long contractId) {
        OtherContractEntity otherContractEntity = otherContractService.selectById(contractId);
        ContractResVO otherContractVO = BeanMapper.map(otherContractEntity, ContractResVO.class);
        if (null != otherContractEntity) {
            CommonResponse<SupplierVO> supplierVOCommonResponse = supplierApi.queryById(otherContractEntity.getSupplierId());
            if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
                otherContractVO.setSupplierCreditCode(supplierVOCommonResponse.getData().getSocialCreditCode());
            }
            CommonResponse<CustomerVO> customerVOCommonResponse = customerApi.detailById(otherContractEntity.getCustomerId());
            if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
                otherContractVO.setCustomerCreditCode(customerVOCommonResponse.getData().getSocialCreditCode());
            }
        } else {
            return CommonResponse.error("获取合同信息失败!");
        }
        return CommonResponse.success("获取合同信息成功", otherContractVO);
    }

    /**
     * 查其他合同结算
     *
     * @param projectId
     * @param lastDay
     * @return
     */
    @RequestMapping(value = "/getMonthOtherMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OtherProjectReportVo>> getMonthOtherMny(@RequestParam(value = "projectId") Long projectId
            , @RequestParam(value = "lastDay") Integer lastDay) {

        return CommonResponse.success("查询列表数据成功", otherContractService.getMonthOtherMny(projectId, lastDay));
    }

    /**
     * 查其他支出合同数量，金额，结算金额
     *
     * @param projectId
     * @return
     */
    @GetMapping(value = "getOtherContract")
    @ResponseBody
    public CommonResponse<OtherProjectReportVo> getOtherContract(@RequestParam(value = "projectId") Long projectId) {

        return CommonResponse.success("查询列表数据成功", otherContractService.getOtherContract(projectId));
    }

    /**
     * @Description 回写其它支出合同累计付款金额、累计预付款金额
     * @Param contractId  合同id
     * @Param payMny  本期已付款金额，正为回写，负为逆回写
     * @param prepayMny 本期预付款金额，正为回写，负为逆回写
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "updateOtherContractSumPayMny")
    public CommonResponse<String> updateOtherContractSumPayMny(@RequestParam(value = "contractId", required = true) Long contractId,
                                                              @RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny) {
        OtherContractEntity entity = otherContractService.selectById(contractId);
        if (entity == null) {
            return CommonResponse.error("没有找到相应其它支出合同！");
        }
        //累计付款金额
        BigDecimal sumPayMny = entity.getSumPayMny();
        sumPayMny = MathUtil.safeAdd(sumPayMny, payMny);
        entity.setSumPayMny(sumPayMny);
        //累计预付款金额
        BigDecimal sumPrepayMny = entity.getSumPrepayMny();
        sumPrepayMny = MathUtil.safeAdd(sumPrepayMny, prepayMny);
        entity.setSumPrepayMny(sumPrepayMny);
        otherContractService.saveOrUpdate(entity, false);
        return CommonResponse.success("回写其它支出合同累计付款金额、累计预付款金额成功！");
    }

    /**
     * @Description 回写其它支出结算单累计付款金额
     * @Param settleId  结算单id
     * @Param payMny  本期已付款金额，正为回写，负为逆回写
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "updateOtherSettleSumPayMny")
    public CommonResponse<String> updateOtherSettleSumPayMny(@RequestParam(value = "settleId", required = true) Long settleId,
                                                            @RequestParam("payMny") BigDecimal payMny) {
        OtherSettleEntity entity = otherSettleService.selectById(settleId);
        if (entity == null) {
            return CommonResponse.error("没有找到相应其它支出结算单！");
        }
        //累计付款金额
        BigDecimal sumPayMny = entity.getSumPayMny();
        sumPayMny = MathUtil.safeAdd(sumPayMny, payMny);
        entity.setSumPayMny(sumPayMny);
        otherSettleService.saveOrUpdate(entity, false);
        return CommonResponse.success("回写其它支出结算单累计付款金额成功！");
    }

    /**
     * @Description 回写其它支出结算单累计申请金额、剩余可申请金额
     * @Param settleId  结算单id
     * @Param payMny  本期已付款金额，正为回写，负为逆回写
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @GetMapping(value = "updateOtherSettleSumApplyMny")
    public CommonResponse<String> updateOtherSettleSumApplyMny(@RequestParam(value = "settleId", required = true) Long settleId,
                                                              @RequestParam("applyMny") BigDecimal applyMny) {
        OtherSettleEntity entity = otherSettleService.selectById(settleId);
        if (entity == null) {
            return CommonResponse.error("没有找到相应其它支出结算单！");
        }
        //累计申请金额
        BigDecimal sumApplyMny = entity.getSumApplyMny();
        sumApplyMny = MathUtil.safeAdd(sumApplyMny, applyMny);
        entity.setSumApplyMny(sumApplyMny);
        //剩余可申请金额
        BigDecimal surplusApplyMny = MathUtil.safeSub(MathUtil.safeSub(entity.getSettleTaxMny(), entity.getThisOffsetMny()), applyMny);
        entity.setSurplusApplyMny(surplusApplyMny);
        otherSettleService.saveOrUpdate(entity, false);
        return CommonResponse.success("回写其它支出结算单累计申请金额、剩余可申请金额成功！");
    }


    /**
     * @Description 根据条件查询结算单累计冲抵金额
     * @Param contractId  合同id
     */
    @GetMapping(value = "getOtherSettlementById")
    public CommonResponse<OtherSettleVO> getOtherSettlementById(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam(value = "orgId", required = true) Long orgId) {
        OtherSettleVO vo = new OtherSettleVO();
        vo.setSumOffsetMny(new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP));
        LambdaQueryWrapper<OtherSettleEntity> lambdachange = Wrappers.<OtherSettleEntity>lambdaQuery();
        lambdachange.eq(OtherSettleEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(OtherSettleEntity::getContractId, contractId);
        lambdachange.eq(OtherSettleEntity::getOrgId, orgId);
        lambdachange.in(OtherSettleEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<OtherSettleEntity> list = otherSettleService.list(lambdachange);
        if (CollectionUtils.isNotEmpty(list)) {
            final BigDecimal[] sumOffsetMny = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e -> {
                sumOffsetMny[0] = sumOffsetMny[0].add(e.getThisOffsetMny() == null ? BigDecimal.ZERO : e.getThisOffsetMny());
            });
            //累计冲抵金额
            vo.setSumOffsetMny(sumOffsetMny[0]);
        }
        return CommonResponse.success("获取信息成功", vo);
    }


}
