/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.OtherContractChangeEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.SupplementEntity;
import com.ejianc.business.other.history.SupplementHistoryVo;
import com.ejianc.business.other.mapper.SupplementMapper;
import com.ejianc.business.other.service.IOtherContractChangeService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.ISupplementService;
import com.ejianc.business.other.vo.SupplementDetailVO;
import com.ejianc.business.other.vo.SupplementVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="supplementService")
public class SupplementServiceImpl
extends BaseServiceImpl<SupplementMapper, SupplementEntity>
implements ISupplementService {
    private static final String SUPPLEMENT_BILL_CODE = "OTHER_SUPPLEMENT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherContractChangeService changeService;

    @Override
    public SupplementVO addConvertByConId(Long id) {
        OtherContractEntity contractVO = (OtherContractEntity)((Object)this.contractService.selectById(id));
        SupplementVO supplementVO = new SupplementVO();
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setTaxRate(contractVO.getTaxRate());
        supplementVO.setSupplementFlag(Integer.valueOf(1));
        supplementVO.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
        supplementVO.setMainContractId(contractVO.getId());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractName(contractVO.getContractName());
        return supplementVO;
    }

    @Override
    public CommonResponse<SupplementVO> saveOrUpdate(SupplementVO contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        SupplementEntity entity = null;
        String operateType = null;
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(SupplementEntity::getMainContractId, (Object)contractVo.getMainContractId());
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            lambdaQuery.ne(BaseEntity::getId, (Object)contractVo.getId());
        }
        lambdaQuery.ne(SupplementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count((Wrapper)lambdaQuery);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdachange.eq(OtherContractChangeEntity::getContractId, (Object)contractVo.getMainContractId());
        lambdachange.ne(OtherContractChangeEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(OtherContractChangeEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int changeNum = this.changeService.count((Wrapper)lambdachange);
        if (changeNum > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (StringUtils.isEmpty((CharSequence)contractVo.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SUPPLEMENT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVo.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            entity = (SupplementEntity)((Object)BeanMapper.map((Object)contractVo, SupplementEntity.class));
            operateType = "edit";
        } else {
            entity = (SupplementEntity)((Object)BeanMapper.map((Object)contractVo, SupplementEntity.class));
            operateType = "add";
        }
        List entities = null;
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(SupplementEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(SupplementEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)this.queryDetail(entity.getId()));
    }

    @Override
    public SupplementVO queryDetail(Long id) {
        SupplementEntity entity = (SupplementEntity)((Object)super.selectById((Serializable)id));
        SupplementVO vo = (SupplementVO)BeanMapper.map((Object)((Object)entity), SupplementVO.class);
        List detailVos = vo.getDetailVos();
        ArrayList<SupplementDetailVO> detail = new ArrayList<SupplementDetailVO>();
        if (detailVos != null && detailVos.size() > 0) {
            for (SupplementDetailVO dvo : detailVos) {
                if (dvo.getChangeType() != null && dvo.getChangeType() == 5) continue;
                detail.add(dvo);
            }
        }
        vo.setDetailVos(detail);
        return vo;
    }

    @Override
    public SupplementHistoryVo queryDetailRecord(Long id) {
        OtherContractEntity contractEntity = (OtherContractEntity)((Object)this.contractService.selectById(id));
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(SupplementEntity::getMainContractId, (Object)id);
        lambdaQuery.ne(SupplementEntity::getBillState, (Object)BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdaQuery.ne(SupplementEntity::getBillState, (Object)BillStateEnum.COMMITED_STATE.getBillStateCode());
        int supnum = super.count((Wrapper)lambdaQuery);
        SupplementHistoryVo recordVO = new SupplementHistoryVo();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal baseTaxMny = contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney();
        recordVO.setContractId(id);
        if (supnum > 0) {
            recordVO.setSupplementFlag(Integer.valueOf(1));
        } else {
            recordVO.setSupplementFlag(Integer.valueOf(0));
        }
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setBaseTaxMoney(baseTaxMny);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        recordVO.setIsFinish(contractEntity.getIsFinish());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(SupplementEntity::getMainContractId, (Object)id);
        lambda.orderByDesc(SupplementEntity::getSignDate);
        List entities = super.list((Wrapper)lambda);
        recordVO.setDetailList(BeanMapper.mapList((Iterable)entities, SupplementVO.class));
        return recordVO;
    }
}

