package com.ejianc.business.other.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.other.bean.*;
import com.ejianc.business.other.history.ChangeHistoryVo;
import com.ejianc.business.other.service.*;
import com.ejianc.business.other.utils.ComputeUtil;
import com.ejianc.business.other.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.other.mapper.OtherContractChangeMapper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 其他支出合同变更
 *
 * @author generator
 */
@Service("otherContractChangeService")
public class OtherContractChangeServiceImpl extends BaseServiceImpl<OtherContractChangeMapper, OtherContractChangeEntity> implements IOtherContractChangeService {
    private static final String BILL_CODE = "OTHER_CONTRACT_CHANGE";

    @Autowired
    private IOtherContractService contractService;
    @Autowired
    private IOtherContractDetailChangeService detailChangeService;
    @Autowired
    private IOtherContractPayPlanChangeService payPlanChangeService;
    @Autowired
    private IOtherContractClauseChangeService clauseChangeService;

    @Autowired
    private IOtherContractChangeService changeService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public CommonResponse<OtherContractChangeVO> saveOrUpdate(OtherContractChangeVO changeVo) {

        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractChangeEntity entity = null;
        String operateType = null;
        if (changeVo.getId() != null && changeVo.getId() > 0) { //修改
            if (StringUtils.isEmpty(changeVo.getBillCode())) {
                changeVo.setBillCode(null);
            }
            entity = BeanMapper.map(changeVo, OtherContractChangeEntity.class);
            operateType = "edit";
        } else {
            if (null == changeVo.getChangeVersion() || changeVo.getChangeVersion() == 0) {
                changeVo.setChangeVersion(1);//第一次变更
            } else {
                changeVo.setChangeVersion(changeVo.getChangeVersion() + 1);//版本号+1
            }
            if (2 == changeVo.getChangeStatus()) {
                throw new BusinessException("合同存在变更中单据，不允许保存!");
            }
            //新增
            if (StringUtils.isEmpty(changeVo.getBillCode())) {
                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
                if(billCode.isSuccess()) {
                    changeVo.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }

            entity = BeanMapper.map(changeVo, OtherContractChangeEntity.class);

            operateType = "add";
        }
        if (changeVo.getId() != null && changeVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherContractChangeEntity> lambda = Wrappers.<OtherContractChangeEntity>lambdaQuery();
            lambda.eq(OtherContractChangeEntity::getBillCode, changeVo.getBillCode());
            lambda.eq(OtherContractChangeEntity::getTenantId, tenantId);
            lambda.ne(OtherContractChangeEntity::getId, changeVo.getId());
            lambda.ne(OtherContractChangeEntity::getContractId, changeVo.getContractId());
            List<OtherContractChangeEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherContractChangeEntity> lambda = Wrappers.<OtherContractChangeEntity>lambdaQuery();
            lambda.eq(OtherContractChangeEntity::getTenantId, tenantId);
            lambda.eq(OtherContractChangeEntity::getBillCode, changeVo.getBillCode());
            lambda.ne(OtherContractChangeEntity::getContractId, changeVo.getContractId());
            List<OtherContractChangeEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
        queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ, changeVo.getBillCode()));
        queryParam.getParams().put("id", new Parameter(QueryParam.NE, changeVo.getContractId()));
        List<OtherContractEntity> entitiesc = contractService.queryList(queryParam, false);
        if (entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        super.saveOrUpdate(entity);
        saveChildren(changeVo, entity.getId(), operateType);

        //回写主表
        LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(OtherContractEntity::getChangingTaxMny, changeVo.getContractTaxMny());
        updateWrapper.set(OtherContractEntity::getChangingMny, changeVo.getContractMny());
        updateWrapper.set(OtherContractEntity::getChangeId, entity.getId());
        updateWrapper.set(OtherContractEntity::getChangeStatus, 2);
        updateWrapper.set(OtherContractEntity::getChangeCode, entity.getBillCode());
        updateWrapper.eq(OtherContractEntity::getId, entity.getContractId());
        contractService.update(updateWrapper);

        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public void deleteChange(List<OtherContractChangeVO> vos) {
        for (OtherContractChangeVO vo : vos) {
            OtherContractChangeEntity changeEntity = super.selectById(vo.getId());
            LambdaUpdateWrapper<OtherContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.set(OtherContractEntity::getChangingTaxMny, BigDecimal.ZERO);
            updateWrapper.set(OtherContractEntity::getChangingMny, BigDecimal.ZERO);
            if (changeEntity.getChangeVersion() == 1) {
                updateWrapper.set(OtherContractEntity::getChangeStatus, 1);
            } else {
                updateWrapper.set(OtherContractEntity::getChangeStatus, 3);
            }
            updateWrapper.eq(OtherContractEntity::getId, changeEntity.getContractId());
            contractService.update(updateWrapper);
            super.removeById(vo, false);
        }
    }

    @Override
    public ChangeHistoryVo queryChangeHistory(Long id) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        List<OtherContractChangeEntity> changeEntities = changeService.list(new QueryWrapper<OtherContractChangeEntity>()
                .eq("contract_id", id)
                .in("bill_state", billStatus).orderByDesc("used_time"));
        OtherContractEntity contractEntity = contractService.selectById(id);

        ChangeHistoryVo vo = new ChangeHistoryVo();
        vo.setIsFinish(contractEntity.getIsFinish());
        vo.setChangeStatus(contractEntity.getChangeStatus());
        vo.setSupplementFlag(0);

        vo.setContractId(id);
        vo.setContractTaxMny(contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny());
        vo.setBaseTaxMoney(contractEntity.getBaseTaxMoney() == null ? BigDecimal.ZERO : contractEntity.getBaseTaxMoney());
        BigDecimal changeMny = vo.getContractTaxMny().subtract(vo.getBaseTaxMoney());
        vo.setSumChangeMny(changeMny);
        BigDecimal sumChangeRate = BigDecimal.ZERO;
        if (vo.getBaseTaxMoney().compareTo(BigDecimal.ZERO) != 0) {
            sumChangeRate = changeMny.divide(vo.getBaseTaxMoney(), 8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
        }
        vo.setSumScale(sumChangeRate);
        if (null != changeEntities && changeEntities.size() > 0) {
            List<OtherContractChangeVO> changeVos = BeanMapper.mapList(changeEntities, OtherContractChangeVO.class);
            for (OtherContractChangeVO cvo : changeVos) {
                String changeTime = new SimpleDateFormat("yyyyMMdd").format(cvo.getChangeTime());
                String historyBillCode = cvo.getBeforeContractName() + "-" + changeTime + "-" + cvo.getChangeVersion();
                cvo.setHistoryBillCode(historyBillCode);
                BigDecimal subtract = ComputeUtil.safeSub(cvo.getContractTaxMny(), cvo.getBeforeChangeTaxMny());
                BigDecimal changeRate = BigDecimal.ZERO;
                if (cvo.getBeforeChangeTaxMny() != null && cvo.getBeforeChangeTaxMny().compareTo(BigDecimal.ZERO) != 0) {
                    changeRate = ComputeUtil.safeDiv(subtract, cvo.getBeforeChangeTaxMny()).setScale(8, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                }
                cvo.setScale(changeRate);
            }
            vo.setChangeRecord(changeVos);
        }
        return vo;
    }


    private void saveChildren(OtherContractChangeVO changeVo, Long changeId, String operateType) {
        List<OtherContractDetailChangeVO> detailVos = changeVo.getDetailVos();
        List<OtherContractPayPlanChangeVO> payPlanVos = changeVo.getPayPlanVos();
        List<OtherContractClauseChangeVO> clauseVos = changeVo.getClauseVos();
        List<OtherContractDetailChangeEntity> detailSave = new ArrayList<>();
        List<OtherContractPayPlanChangeEntity> payPlanSave = new ArrayList<>();
        List<OtherContractClauseChangeEntity> clauseSave = new ArrayList<>();
        List<Long> detailDel = new ArrayList<>();
        List<Long> payPlanDel = new ArrayList<>();
        List<Long> clauseDel = new ArrayList<>();
        if (operateType.equals("add")) {
            if (detailVos != null && detailVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : detailVos) {
                    vo.setId(null);
                    vo.setChangeId(changeId);
                }
                detailSave = BeanMapper.mapList(detailVos, OtherContractDetailChangeEntity.class);
            }
            if (payPlanVos != null && payPlanVos.size() > 0) {
                for (OtherContractPayPlanChangeVO vo : payPlanVos) {
                    if (!"del".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        payPlanSave.add(BeanMapper.map(vo, OtherContractPayPlanChangeEntity.class));
                    }
                }
            }
            if (clauseVos != null && clauseVos.size() > 0) {
                for (OtherContractClauseChangeVO vo : clauseVos) {
                    if (!"del".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        clauseSave.add(BeanMapper.map(vo, OtherContractClauseChangeEntity.class));
                    }
                }
            }
        } else {
            if (detailVos != null && detailVos.size() > 0) {
                for (OtherContractDetailChangeVO vo : detailVos) {
                    if ("del".equals(vo.getRowState())) {
                        detailDel.add(vo.getId());
                    } else if ("add".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        OtherContractDetailChangeEntity map = BeanMapper.map(vo, OtherContractDetailChangeEntity.class);
                        detailSave.add(map);
                    } else if ("edit".equals(vo.getRowState())) {
                        OtherContractDetailChangeEntity map = BeanMapper.map(vo, OtherContractDetailChangeEntity.class);
                        detailSave.add(map);
                    }
                }
            }
            if (payPlanVos != null && payPlanVos.size() > 0) {
                for (OtherContractPayPlanChangeVO vo : payPlanVos) {
                    if ("del".equals(vo.getRowState())) {
                        payPlanDel.add(vo.getId());
                    } else if ("add".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        OtherContractPayPlanChangeEntity map = BeanMapper.map(vo, OtherContractPayPlanChangeEntity.class);
                        payPlanSave.add(map);
                    } else if ("edit".equals(vo.getRowState())) {
                        OtherContractPayPlanChangeEntity map = BeanMapper.map(vo, OtherContractPayPlanChangeEntity.class);
                        payPlanSave.add(map);
                    }
                }
            }
            if (clauseVos != null && clauseVos.size() > 0) {
                for (OtherContractClauseChangeVO vo : clauseVos) {
                    if ("del".equals(vo.getRowState())) {
                        clauseDel.add(vo.getId());
                    } else if ("add".equals(vo.getRowState())) {
                        vo.setId(null);
                        vo.setChangeId(changeId);
                        OtherContractClauseChangeEntity map = BeanMapper.map(vo, OtherContractClauseChangeEntity.class);
                        clauseSave.add(map);
                    } else if ("edit".equals(vo.getRowState())) {
                        OtherContractClauseChangeEntity map = BeanMapper.map(vo, OtherContractClauseChangeEntity.class);
                        clauseSave.add(map);
                    }
                }
            }
        }
        if (detailSave.size() > 0) {
            detailChangeService.saveOrUpdateBatch(detailSave);
        }
        if (payPlanSave.size() > 0) {
            payPlanChangeService.saveOrUpdateBatch(payPlanSave);
        }
        if (clauseSave.size() > 0) {
            clauseChangeService.saveOrUpdateBatch(clauseSave);
        }

        if (detailDel.size() > 0) {
            detailChangeService.removeByIds(detailDel);
        }
        if (payPlanDel.size() > 0) {
            payPlanChangeService.removeByIds(payPlanDel);
        }
        if (clauseDel.size() > 0) {
            clauseChangeService.removeByIds(clauseDel);
        }
    }

    @Override
    public OtherContractChangeVO queryDetail(Long id) {
        OtherContractChangeEntity entity = super.selectById(id);
        OtherContractChangeVO changeVo = BeanMapper.map(entity, OtherContractChangeVO.class);
        return changeVo;
    }

    @Override
    public OtherContractVO queryDetailChange(Long id) {
        OtherContractEntity entity = contractService.selectById(id);
        if (entity != null) {
            OtherContractVO contractVo = BeanMapper.map(entity, OtherContractVO.class);
            contractVo.setBeforeChangeTaxMny(entity.getContractTaxMny());
            contractVo.setBillState(null);
            contractVo.setCreateUserCode(null);
            contractVo.setCreateTime(null);
            contractVo.setUpdateUserCode(null);
            contractVo.setUpdateTime(null);
            contractVo.setChangeReason(null);
            List<OtherContractDetailVO> detailVos = contractVo.getDetailVos();
            if (detailVos != null && detailVos.size() > 0) {
                Iterator<OtherContractDetailVO> iterator = detailVos.iterator();
                while (iterator.hasNext()) {
                    OtherContractDetailVO next = iterator.next();
                    if (next.getChangeType() != null && next.getChangeType() == 5) {
                        iterator.remove();
                    }
                }
            }
            contractVo.setDetailVos(detailVos);
            return contractVo;
        }
        return null;
    }


}
