package com.ejianc.business.other.service;

import com.ejianc.business.other.vo.ParamsCheckVO;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.other.vo.SqlParam;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.other.bean.OtherContractEntity;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 其他支出合同实体
 * 
 * @author generator
 * 
 */
public interface IOtherContractService extends IBaseService<OtherContractEntity> {

    CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO saveorUpdateVO);

    OtherContractVO queryDetail(Long id);

    Map<String,Object> countContractAmount(QueryParam param);

    List<OtherProjectReportVo> getMonthOtherMny(Long projectId, Integer lastDay);

    OtherProjectReportVo getOtherContract(Long projectId);

    List<Map<String,Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryTaxWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> queryPayWarnContract(List<SqlParam> sqlParamList);

    List<Map<String,Object>> querySettleWarnContract(List<SqlParam> sqlParamList);

    /**
     * 参数控制
     *
     * @param entity 【预算间接费总金额】控 【实际间接费总金额】
     *
     * @return {@link ParamsCheckVO}
     */
    ParamsCheckVO checkParams(OtherContractVO entity);
    BigDecimal totalContractMny(OtherContractVO vo);
}
