package com.ejianc.business.other.service;

import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.other.history.SettleHistoryVo;
import com.ejianc.business.other.vo.OtherSettleDetailVO;
import com.ejianc.business.other.vo.OtherSettleVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.other.bean.OtherSettleEntity;

import java.math.BigDecimal;
import java.util.List;

/**
 * 结算
 *
 * @author generator
 */
public interface IOtherSettleService extends IBaseService<OtherSettleEntity> {

    CommonResponse<OtherSettleVO> saveOrUpdate(OtherSettleVO saveorUpdateVO);

    OtherSettleVO queryDetail(Long id);

    SettleHistoryVo querySettleHistory(Long id);

    ParamsCheckVO checkParams(Integer purchaseType, BigDecimal settleTaxMny, BigDecimal sumSettleMentTaxMny, BigDecimal contractTaxMny);

    CommonResponse<OtherSettleVO> pushToCost(OtherSettleVO otherSettleVO);

    void processCost(OtherSettleEntity entity);

    void delCost(Long id);
    
    List<OtherSettleDetailVO> settlementExcelDownload(OtherSettleVO vo);
}
