package com.ejianc.business.other.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.api.IBudgetControlApi;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.bean.OtherContractChangeEntity;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.mapper.OtherContractMapper;
import com.ejianc.business.other.service.IOtherContractChangeService;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.*;
import com.ejianc.business.othprice.api.IPicketageApi;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * 其他支出合同实体
 *
 * @author generator
 */
@Service("otherContractService")
public class OtherContractServiceImpl extends BaseServiceImpl<OtherContractMapper, OtherContractEntity> implements IOtherContractService {
    private static final String BILL_CODE = "OTHER_CONTRACT";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOtherSettleService settleService;
    private static final String PARAM_TOTAL_MNY = "P-6zD11147"; // 【预算间接费总金额】控 【实际间接费总金额】

    private static final String PARAM_BUDGE_MNY = "P-z3eQ6q89"; // 【项目预算总金额】控【项目总支出金额】
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Autowired
    private IBudgetControlApi budgetControlApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IOtherContractChangeService changeService;
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;
    @Autowired
    private IPicketageApi picketageApi;


    @Override
    public CommonResponse<OtherContractVO> saveOrUpdate(OtherContractVO contractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        OtherContractEntity entity = null;
        if (StringUtils.isBlank(contractVo.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVo.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) { //修改
            entity = BeanMapper.map(contractVo, OtherContractEntity.class);
        } else {
            //新增设置 竣工结算标志
            contractVo.setIsFinish(0);
            entity = BeanMapper.map(contractVo, OtherContractEntity.class);
            entity.setIsSupplement("0");
        }
        if (contractVo.getId() != null && contractVo.getId() > 0) {
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getBillCode, contractVo.getBillCode());
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.ne(OtherContractEntity::getId, contractVo.getId());
            List<OtherContractEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<OtherContractEntity> lambda = Wrappers.<OtherContractEntity>lambdaQuery();
            lambda.eq(OtherContractEntity::getTenantId, tenantId);
            lambda.eq(OtherContractEntity::getBillCode, contractVo.getBillCode());
            List<OtherContractEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                throw new BusinessException("存在相同编码，不允许保存!");
            }
        }
        entity.setSupplementFlag(0);
        entity.setBaseTaxMoney(entity.getContractTaxMny());//初始版本金额(含税)
        entity.setBaseMoney(entity.getContractMny());//初始版本金额(不含税)
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());//变更前金额(含税)
        entity.setBeforeChangeMny(entity.getContractMny());//变更前金额(不含税)
        boolean b = super.saveOrUpdate(entity, false);
        if (b) {
            this.countContractNumAndMnyByEnquiry(entity.getEnquiryPriceBillId());
        }
        return CommonResponse.success(queryDetail(entity.getId()));
    }

    @Override
    public OtherContractVO queryDetail(Long id) {
        OtherContractEntity entity = super.selectById(id);
        OtherContractVO vo = BeanMapper.map(entity, OtherContractVO.class);
        List<OtherContractDetailVO> detailVos = vo.getDetailVos();
        List<OtherContractDetailVO> detail = new ArrayList<>();
        if (detailVos != null && detailVos.size() > 0) {
            for (OtherContractDetailVO dvo : detailVos) {
                if (dvo.getChangeType() == null || dvo.getChangeType() != 5) {
                    detail.add(dvo);
                }
            }
        }
        vo.setDetailVos(detail);
        return vo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount");
        resp = super.getMap(wrapper);
        return resp;
    }

    @Override
    public List<OtherProjectReportVo> getMonthOtherMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthOtherMny(projectId, lastDay);
    }

    @Override
    public OtherProjectReportVo getOtherContract(Long projectId) {
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);

        // 合同数量 金额
        LambdaQueryWrapper<OtherContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OtherContractEntity::getProjectId, projectId);
        wrapper.eq(OtherContractEntity::getDr, 0);
        wrapper.eq(OtherContractEntity::getSupplementFlag, 0);
        wrapper.in(OtherContractEntity::getBillState, billStatus);
        List<OtherContractEntity> otherContractEntityList = super.list(wrapper);
        BigDecimal mny = otherContractEntityList.stream().filter(entity -> entity.getContractTaxMny() != null).map(OtherContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 结算金额
        LambdaQueryWrapper<OtherSettleEntity> wrapper2 = new LambdaQueryWrapper<>();
        wrapper2.eq(OtherSettleEntity::getProjectId, projectId);
        wrapper2.eq(OtherSettleEntity::getDr, 0);
        wrapper2.in(OtherSettleEntity::getBillState, billStatus);
        List<OtherSettleEntity> settlementEntityList = settleService.list(wrapper2);
        BigDecimal settleMny = settlementEntityList.stream().filter(entity -> entity.getSettleTaxMny() != null).map(OtherSettleEntity::getSettleTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        OtherProjectReportVo vo = new OtherProjectReportVo();
        vo.setMny(mny);
        vo.setNum(otherContractEntityList.size());
        vo.setSettleMny(settleMny);

        return vo;
    }

    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPrePayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryTaxWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryTaxWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPayWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.querySettleWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryContractEndWarn(List<SqlParam> sqlParamList) {
        return baseMapper.queryContractEndWarn(sqlParamList);
    }

    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    /**
     * 参数控制
     *
     * @param vo 【预算间接费总金额】控 【实际间接费总金额】
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckVO checkParams(OtherContractVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算间接费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算间接费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //      预算间接费总金额
            BigDecimal budgetTaxMny =  data.getIndirectionTaxMny()==null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);

            if (!response.isSuccess()) {
                throw new BusinessException(" 【预算间接费总金额】控 【实际间接费总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();


            //其他合同总金额
            BigDecimal  totalContractMny= totalContractMny(vo);
            CommonResponse<BigDecimal> respPay = budgetControlApi.budgetControlTotal(vo.getProjectId());
            logger.info("统计费用报销、备用金报销、零星付款申请 金额:{}", JSONObject.toJSONString(respPay));
            if (!response.isSuccess()){
                throw new BusinessException("网络错误"+respPay.getMsg());
            }else {
                if (respPay.getData()!=null){
                    totalContractMny = totalContractMny.add(respPay.getData());
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billParamVOS)) {
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        logger.info("其他费用:{} 间接费用:{}",JSONObject.toJSONString(totalContractMny),JSONObject.toJSONString(budgetTaxMnyResult));
                        // 【预算间接费总金额】控 【实际间接费总金额】
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 实际间接费总金额 - 预算间接费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            //设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("实际间接费总金额超预算间接费总金额");
                            paramsCheckDsVO.setWarnName("实际间接费总金额大于预算间接费总金额 * " + ComputeUtil.scaleStripTrailingZeros(roleValue, 8) + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目实际间接费总金额：")
                                    .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元， 预算间接费总金额 * ")
                                    .append(ComputeUtil.scaleStripTrailingZeros(roleValue, 8)).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }

                }
            }
            // 【项目预算总金额】控【项目总支出金额】
            //项目总预算金额
            BigDecimal allBudgetTaxMny = res.getData().getBudgetTaxMny() == null ? BigDecimal.ZERO : res.getData().getBudgetTaxMny();
            CommonResponse<List<BillParamVO>> responseBudge = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_BUDGE_MNY, InvocationInfoProxy.getOrgId());

            if (!responseBudge.isSuccess()) {
                throw new BusinessException(" 项目总支出金额超项目总预算金额，获取控制参数失败，失败原因：" + responseBudge.getMsg());
            }
            List<BillParamVO> billParamVOSBudge = responseBudge.getData();
            if (CollectionUtils.isNotEmpty(billParamVOSBudge)) {
                //获取项目总支出金额
                BigDecimal totalOutMny = vo.getContractTaxMny();
                CommonResponse<Map<String, BigDecimal>> proOutMnyCommonResponse = budgetProjectProApi.getProOutMny(vo.getProjectId(), vo.getId(), BillTypeCodeEnum.其他支出合同.getBillTypeCode());
                logger.info(" 项目总支出金额不含本次 返回内容:{}", JSONObject.toJSONString(proOutMnyCommonResponse));
                if (!proOutMnyCommonResponse.isSuccess()) {
                    throw new BusinessException(proOutMnyCommonResponse.getMsg());
                }
                totalOutMny = totalOutMny.add(proOutMnyCommonResponse.getData().get("TaxMny"));
                for (BillParamVO billParamVO : billParamVOSBudge) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = allBudgetTaxMny.multiply(scale);
                        // 项目总支出金额超项目总预算金额
                        logger.info("项目总支出金额:{},项目总预算金额:{}", JSONObject.toJSONString(totalOutMny), JSONObject.toJSONString(budgetTaxMnyResult));

                        if (totalOutMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 项目总支出金额 - 项目预算总金额 * X%
                            BigDecimal over = totalOutMny.subtract(budgetTaxMnyResult);

                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());

                            paramsCheckDsVO.setWarnItem("项目总支出金额超项目总预算金额");
                            paramsCheckDsVO.setWarnName("项目总支出金额超项目总预算金额");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("项目总支出金额：")
                                    .append(totalOutMny.setScale(2, RoundingMode.HALF_UP))
                                    .append("元， 项目预算总金额 * ")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.scaleStripTrailingZeros(roleValue, 8)).append("%：")
                                    .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                    .append("元，超出金额：")
                                    .append(over.setScale(2, RoundingMode.HALF_UP))
                                    .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }

        if (1==vo.getDependOnProject()) {
            // 施工合同金额控制支出
            CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId);
            if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
                List<BillParamVO> billParamVOS = sghtkzc.getData();
                if (CollectionUtils.isNotEmpty(billParamVOS)) {
                    BigDecimal sjzcje = this.getSjzcje(null, vo.getId(), vo.getProjectId(), vo.getContractTaxMny());
                    CommonResponse<BigDecimal> res996 = incomeContractApi.fetchSghtzje(vo.getProjectId());
                    if (!res996.isSuccess()) {
                        throw new BusinessException("获取施工合同工总金额失败");
                    }
                    BigDecimal sght = res996.getData();
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                            BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                            if (sjzcje.compareTo(sghtzje) > 0) {
//                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("该项目支出汇总金额：")
                                        .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                        .append("，施工合同工总金额*")
                                        .append(ComputeUtil.scaleStripTrailingZeros(roleValue, 8))
                                        .append("%：")
                                        .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                        .append("，超出金额：")
                                        .append(ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem("支出汇总金额超施工合同总金额");
                                paramsCheckDsVO.setWarnName("支出汇总金额大于施工合同总金额");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
//                            checkDsVOS.add(paramsCheckDsVO);
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        }
                    }
                }
            }
        }


        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long changeId, Long contractId, Long projectId, BigDecimal mny) {
        CommonResponse<BigDecimal> fbCommonResponse = subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "分包" + "实际支出金额失败");
        }
        BigDecimal fb = fbCommonResponse.getData();
        CommonResponse<BigDecimal> wzCommonResponse = materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "物资" + "实际支出金额失败");
        }
        BigDecimal wz = wzCommonResponse.getData();
        CommonResponse<BigDecimal> zzcCommonResponse = rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "周转材" + "实际支出金额失败");
        }
        BigDecimal zzc = zzcCommonResponse.getData();
        CommonResponse<BigDecimal> sbcgCommonResponse = equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备采购" + "实际支出金额失败");
        }
        BigDecimal sbcg = sbcgCommonResponse.getData();
        CommonResponse<BigDecimal> sbzlCommonResponse = equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备租赁" + "实际支出金额失败");
        }
        BigDecimal sbzl = sbzlCommonResponse.getData();
        BigDecimal qt = baseMapper.fetchSjzcje(projectId, changeId, contractId);
        CommonResponse<BigDecimal> fybxCommonResponse = financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "费用报销" + "实际支出金额失败");
        }
        BigDecimal fybx = fybxCommonResponse.getData();
        CommonResponse<BigDecimal> lxCommonResponse = financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "零星" + "实际支出金额失败");
        }
        BigDecimal lx = lxCommonResponse.getData();
        CommonResponse<BigDecimal> yjCommonResponse = financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "备用金" + "实际支出金额失败");
        }
        BigDecimal yj = yjCommonResponse.getData();
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }
    @Override
    public BigDecimal totalContractMny(OtherContractVO vo){
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        QueryWrapper<OtherContractEntity> contractQuery = new QueryWrapper<>();
        contractQuery.eq("project_Id", vo.getProjectId());
        contractQuery.ne("change_status",2);
        if (vo.getId()!=null){
            contractQuery.ne("id",vo.getId());
        }
        if (vo.getContractTaxMny()!=null){
            contractTaxMny =contractTaxMny.add(vo.getContractTaxMny());
        }
        contractQuery.select("sum(contract_tax_mny) as contractTaxMny");
        OtherContractEntity contractEntity = super.getOne(contractQuery);
        if(contractEntity!=null &&null != contractEntity.getContractTaxMny()&&!"0".equals(contractEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(contractEntity.getContractTaxMny());
        }
        //统计变更中的金额
        QueryWrapper<OtherContractChangeEntity> changeQuery = new QueryWrapper<>();
        changeQuery.eq("project_Id", vo.getProjectId());
        changeQuery.in("bill_state", Arrays.asList(
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()));
        changeQuery.select("sum(contract_tax_mny) as contractTaxMny");
        OtherContractChangeEntity changeEntity = changeService.getOne(changeQuery);
        if (changeEntity != null && null != changeEntity.getContractTaxMny() && !"0".equals(changeEntity.getContractTaxMny())) {
            contractTaxMny = contractTaxMny.add(changeEntity.getContractTaxMny());
        }
        return contractTaxMny;
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null, null);
    }


    /**
     * @return {@link PicketageVO}
     *
     * @description: 根据定标单回写已签合同数量和金额
     * @author songlx
     * @date: 2023/11/8
     * @param enquiryPriceBillIds
     */
    @Override
    public PicketageVO countContractNumAndMnyByEnquiry(Long... enquiryPriceBillIds) {
        if(enquiryPriceBillIds != null && enquiryPriceBillIds.length > 0){
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper<OtherContractEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.select("count(1) as num, IFNULL(sum(contract_tax_mny),0) as money")
                        .eq("enquiry_price_bill_id", enquiryPriceBillId);
                Map<String, Object> map = this.getMap(queryWrapper);
                PicketageVO picketageVO = new PicketageVO();
                if(MapUtils.isNotEmpty(map)){
                    Integer num = map.get("num") != null ?  Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                    picketageVO.setId(enquiryPriceBillId);
                    picketageVO.setContractSign(num);
                    picketageVO.setContractSignMny(money);
                } else {
                    picketageVO.setId(enquiryPriceBillId);
                    picketageVO.setContractSign(0);
                    picketageVO.setContractSignMny(BigDecimal.ZERO);
                }
                picketageApi.updateContractSignMny(picketageVO);
            }
        }
        return null;
    }
}
