/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.equipment.vo.RentContractPayVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.other.bean.OtherContractEntity;
import com.ejianc.business.other.bean.OtherSettleEntity;
import com.ejianc.business.other.service.IOtherContractService;
import com.ejianc.business.other.service.IOtherSettleService;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.other.vo.ParamsCheckVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"otherContract"})
public class OtherContractController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IPayContractApi payContractApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IOtherContractService service;
    @Autowired
    private IOtherSettleService settleService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OtherContractVO> saveOrUpdate(@RequestBody OtherContractVO saveorUpdateVO) {
        CommonResponse<OtherContractVO> response = this.service.saveOrUpdate(saveorUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OtherContractVO> queryDetail(Long id) {
        OtherContractVO vo = this.service.queryDetail(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OtherContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> enquiryPriceBillIds;
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BaseEntity::getId, ids);
            queryWrapper.isNotNull(OtherContractEntity::getEnquiryPriceBillId);
            List contractEntities = this.service.list((Wrapper)queryWrapper);
            boolean b = this.service.removeByIds(ids, false);
            if (b && CollectionUtils.isNotEmpty((Collection)contractEntities) && CollectionUtils.isNotEmpty(enquiryPriceBillIds = contractEntities.stream().filter(t -> t.getEnquiryPriceBillId() != null).map(OtherContractEntity::getEnquiryPriceBillId).collect(Collectors.toList()))) {
                this.service.countContractNumAndMnyByEnquiry(enquiryPriceBillIds.toArray(new Long[enquiryPriceBillIds.size()]));
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("contractTaxMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        param.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), OtherContractVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("depend_on_project", new Parameter("eq", (Object)"0"));
            c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
            c1.getComplexParams().add(c3);
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        }
        return c1;
    }

    @RequestMapping(value={"/queryRef"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OtherContractVO>> queryRef(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="condition", required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.setSearchObject(searchObject);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getParams().put("contractStatus", new Parameter("ne", (Object)"3"));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Long projectId;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("orgId")) {
                orgId = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("mobileLeave")) {
                if (null != conditionMap.get("orgId")) {
                    orgId = Long.valueOf(conditionMap.get("orgId").toString());
                    queryParam.getComplexParams().add(this.getPageQueryParam(orgId));
                }
                if (null != conditionMap.get("dependOnProject")) {
                    Integer dependOnProject = Integer.valueOf(conditionMap.get("dependOnProject").toString());
                    queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)dependOnProject));
                }
                if (null != conditionMap.get("projectId")) {
                    projectId = Long.valueOf(conditionMap.get("projectId").toString());
                    queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
                    ComplexParam in = new ComplexParam();
                    in.setLogic("and");
                    ComplexParam p = new ComplexParam();
                    p.setLogic("or");
                    p.getParams().put("projectId", new Parameter("eq", (Object)projectId));
                    ComplexParam t = new ComplexParam();
                    t.setLogic("or");
                    t.getParams().put("purchaseMode", new Parameter("eq", (Object)1));
                    in.getComplexParams().add(p);
                    in.getComplexParams().add(t);
                    queryParam.getComplexParams().add(in);
                } else {
                    queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                }
            } else if (null != conditionMap.get("type") && "pay".equals(conditionMap.get("type").toString())) {
                queryParam.getComplexParams().add(this.getComplexParamForPay(orgId));
                queryParam.getParams().remove("contractStatus");
            } else if (conditionMap.get("type") != null && "focus".equals(conditionMap.get("type").toString())) {
                queryParam.getParams().put("purchase_mode", new Parameter("eq", (Object)1));
                queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
                queryParam.getParams().remove("contractStatus");
            } else {
                queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        queryParam.getParams().put("bill_state", new Parameter("in", billStatus));
        queryParam.getOrderMap().put("createTime", "desc");
        IPage pageData = this.service.queryPage(queryParam, false);
        Page result = new Page(pageData.getCurrent(), pageData.getSize(), pageData.getTotal());
        List otherContractVOS = BeanMapper.mapList((Iterable)pageData.getRecords(), OtherContractVO.class);
        for (OtherContractVO contractVO : otherContractVOS) {
            contractVO.setContractNameExtend(contractVO.getBillCode() + "-" + contractVO.getContractName() + "-" + contractVO.getSupplierName() + "-" + ComputeUtil.scale((BigDecimal)contractVO.getContractTaxMny(), (int)2));
        }
        result.setRecords(otherContractVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    public ComplexParam getComplexParamForPay(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        orgId = orgId != null ? orgId : InvocationInfoProxy.getOrgId();
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("purchase_mode", new Parameter("eq", (Object)2));
        c2.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        c1.getComplexParams().add(c2);
        List<Long> allOrgIds = this.getOrgUpToDownList();
        if (!allOrgIds.isEmpty()) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("purchase_mode", new Parameter("eq", (Object)1));
            c3.getParams().put("org_id", new Parameter("in", this.getOrgUpToDownList()));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }

    public List<Long> getOrgUpToDownList() {
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse childOrgResp = this.orgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.orgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u672c\u4e0a\u52a0\u672c\u4e0b\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentIds = new ArrayList();
        ArrayList<Long> childIds = new ArrayList<Long>();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentIds.remove(orgId);
        childIds.addAll(parentIds);
        return childIds;
    }

    @PostMapping(value={"/changeState"})
    @ResponseBody
    public CommonResponse<String> changeState(@RequestBody OtherContractVO contractVo) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)contractVo.getId());
        updateWrapper.set(OtherContractEntity::getContractStatus, (Object)contractVo.getContractStatus());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u4fee\u6539\u5408\u540c\u72b6\u6001\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("contractTaxMny");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List entityList = this.service.queryList(param);
        List list = BeanMapper.mapList((Iterable)entityList, OtherContractVO.class);
        list.forEach(vo -> {
            if (null != vo.getContractStatus()) {
                if ("1".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("\u672a\u7b7e\u8ba2");
                } else if ("2".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("\u5c65\u7ea6\u4e2d");
                } else if ("3".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("\u5df2\u5c01\u8d26");
                }
            } else {
                vo.setContractStatusName("");
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OtherContract-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOtherContractData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OtherContractVO>> refOtherContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OtherContractVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryInvoiceDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InvoiceReceiveRecordVO> queryInvoiceDetail(@RequestParam Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.service.selectById(id));
        CommonResponse res = this.invoiceApi.getInvoiceReceiveRecord(id);
        if (!res.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6536\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        InvoiceReceiveRecordVO vo = (InvoiceReceiveRecordVO)res.getData();
        if (null != vo) {
            vo.setContractTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
            BigDecimal sumSettlementTaxMny = entity.getSumSettleTaxMny() == null ? BigDecimal.ZERO : entity.getSumSettleTaxMny();
            BigDecimal settleNoRecMny = MathUtil.safeSub((BigDecimal)sumSettlementTaxMny, (BigDecimal)vo.getInvoiceTaxMny());
            vo.setSettleNoRecMny(settleNoRecMny);
            vo.setSumSettleTaxMny(sumSettlementTaxMny);
        }
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/queryPayDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentContractPayVO> queryPayDetail(@RequestParam Long id) {
        OtherContractEntity entity = (OtherContractEntity)((Object)this.service.selectById(id));
        RentContractPayVO rentContractPayVO = (RentContractPayVO)BeanMapper.map((Object)((Object)entity), RentContractPayVO.class);
        CommonResponse sumPayMnyVOList = this.payContractApi.getSumPayMnyVOList(id, null);
        if (!sumPayMnyVOList.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4ed8\u6b3e\u4fe1\u606f\u5931\u8d25\uff01");
        }
        BigDecimal sumPayMny = ((SumPayMnyVO)sumPayMnyVOList.getData()).getSumPayMny() == null ? BigDecimal.ZERO : ((SumPayMnyVO)sumPayMnyVOList.getData()).getSumPayMny();
        BigDecimal sumDeductionMny = ((SumPayMnyVO)sumPayMnyVOList.getData()).getSumDeductionMny();
        rentContractPayVO.setSumDeductionMny(sumDeductionMny);
        rentContractPayVO.setContractId(((SumPayMnyVO)sumPayMnyVOList.getData()).getContractId());
        rentContractPayVO.setSumPayMny(sumPayMny);
        rentContractPayVO.setContractVOList(((SumPayMnyVO)sumPayMnyVOList.getData()).getContractVOList());
        rentContractPayVO.setSumApplyMny(((SumPayMnyVO)sumPayMnyVOList.getData()).getSumApplyMny() == null ? BigDecimal.ZERO : ((SumPayMnyVO)sumPayMnyVOList.getData()).getSumApplyMny());
        BigDecimal sumSettlementTaxMny = this.getTotalSettleAmount(id);
        rentContractPayVO.setSumSettlementTaxMny(sumSettlementTaxMny);
        CommonResponse res = this.invoiceApi.getInvoiceReceiveRecord(id);
        if (!res.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6536\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        rentContractPayVO.setSumInvoiceTaxMny(((InvoiceReceiveRecordVO)res.getData()).getInvoiceTaxMny());
        rentContractPayVO.setSumUnPayMny(ComputeUtil.safeSub((BigDecimal)sumSettlementTaxMny, (BigDecimal[])new BigDecimal[]{sumPayMny, sumDeductionMny}));
        boolean freeFlag = false;
        for (PayContractVO vo : ((SumPayMnyVO)sumPayMnyVOList.getData()).getContractVOList()) {
            if (vo.getFeeType() != 1L) continue;
            freeFlag = true;
            break;
        }
        if (!freeFlag) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.select(new String[]{"IFNULL(SUM(this_offset_mny),0) as thisOffsetMny"});
            queryWrapper.eq((Object)"contract_id", (Object)id);
            queryWrapper.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            queryWrapper.in((Object)"org_id", (Collection)((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
            OtherSettleEntity one = (OtherSettleEntity)((Object)this.settleService.getOne((Wrapper)queryWrapper));
            rentContractPayVO.setSumUnPayMny(MathUtil.safeSub((BigDecimal)rentContractPayVO.getSumUnPayMny(), (BigDecimal)one.getThisOffsetMny()));
        }
        return CommonResponse.success((Object)rentContractPayVO);
    }

    private BigDecimal getTotalSettleAmount(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        OtherContractEntity contract = (OtherContractEntity)((Object)this.service.selectById(contractId));
        if (!"1".equals(contract.getDependOnProject())) {
            Long orgId = InvocationInfoProxy.getOrgId();
            CommonResponse orgResp = this.orgApi.findChildrenByParentId(orgId);
            if (!orgResp.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u5408\u540c\u6536\u7968\u8bb0\u5f55\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u4fe1\u606f\u5931\u8d25\uff01");
            }
            List orgIds = ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        return this.settleService.calculateTotalSettlement(queryParam);
    }

    @PostMapping(value={"getOtherContractTotalAmount"})
    public CommonResponse<JSONObject> getOtherContractTotalAmount(@RequestBody Long orgId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List settlementEntities = this.settleService.queryList(queryParam);
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        List list = this.service.queryList(queryParam);
        BigDecimal contract = new BigDecimal("0.00");
        BigDecimal settle = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)settlementEntities)) {
            for (BaseEntity c : settlementEntities) {
                if (c.getSettleTaxMny() == null) continue;
                settle = MathUtil.safeAdd((BigDecimal)settle, (BigDecimal)c.getSettleTaxMny());
            }
        }
        if (ListUtil.isNotEmpty((List)list)) {
            for (BaseEntity c : list) {
                if (c.getContractTaxMny() == null) continue;
                contract = MathUtil.safeAdd((BigDecimal)contract, (BigDecimal)c.getContractTaxMny());
            }
        }
        JSONObject back = new JSONObject();
        back.put("contract", (Object)contract);
        back.put("settle", (Object)settle);
        return CommonResponse.success((Object)back);
    }

    @PostMapping(value={"analysisContract"})
    public CommonResponse<BigDecimal> analysisContract(@RequestBody Map<String, Object> param) {
        Map<String, Object> result;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        queryParam.getParams().put("dr", new Parameter("eq", (Object)BaseVO.DR_UNDELETE));
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        if (null != param && null != param.get("projectIds") && CollectionUtils.isNotEmpty((Collection)((List)param.get("projectIds")))) {
            queryParam.getParams().put("projectId", new Parameter("in", param.get("projectIds")));
        }
        String dataStr = null != (result = this.service.countContractAmount(queryParam)) && null != result.get("curAmount") ? result.get("curAmount").toString() : "0";
        BigDecimal total = new BigDecimal(dataStr);
        return CommonResponse.success((Object)total.divide(new BigDecimal(10000), 2, 4));
    }

    @PostMapping(value={"checkParams"})
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody OtherContractVO entity) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.checkParams(entity));
    }
}

