package com.ejianc.business.othprice.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.bidprice.consts.InquiryStateEnum;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.othprice.bean.OtherInquiryEntity;
import com.ejianc.business.othprice.mapper.OtherInquiryMapper;
import com.ejianc.business.othprice.service.IOtherInquiryService;
import com.ejianc.business.othprice.vo.OtherInquiryDetailVO;
import com.ejianc.business.othprice.vo.OtherInquiryVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 材料询价
 * 
 * @author generator
 * 
 */
@Service("otherInquiryService")
public class OtherInquiryServiceImpl extends BaseServiceImpl<OtherInquiryMapper, OtherInquiryEntity> implements IOtherInquiryService {


    @Autowired
    private IMaterialSettlementApi materialSettlementApi;

    @Override
    public OtherInquiryVO updateInquiry(OtherInquiryVO updateVo) {
        Long id = updateVo.getId();
        Date quoteEndDate = updateVo.getQuoteEndDate();
        //是否截止标志
        Boolean quoteEndFlag = updateVo.getQuoteEndFlag();
        OtherInquiryEntity entity = super.selectById(id);
        if(entity != null){
            LambdaUpdateWrapper<OtherInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(OtherInquiryEntity::getId,id);
            updateWrapper.set(OtherInquiryEntity::getQuoteEndDate,quoteEndDate);
            //如果截止，修改询价状态为已截止
            if(quoteEndFlag){
                updateWrapper.set(OtherInquiryEntity::getInquiryState, InquiryStateEnum.EXPIRATION_STATE.getCode());
            }
            //如果已截止，但截止时间大于当前时间，修改询价状态为报价中
            if(InquiryStateEnum.EXPIRATION_STATE.getCode().equals(entity.getInquiryState()) && quoteEndDate.compareTo(new Date()) > 0){
                updateWrapper.set(OtherInquiryEntity::getInquiryState, InquiryStateEnum.QUOTATION_STATE.getCode());
            }
            super.update(updateWrapper);
        }
        return updateVo;
    }


    @Override
    public void updateInquiry(Long inquiryId,Integer inquiryState){
        LambdaUpdateWrapper<OtherInquiryEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(OtherInquiryEntity::getId,inquiryId);
        updateWrapper.set(OtherInquiryEntity::getInquiryState, inquiryState);
        super.update(updateWrapper);
    }

}
