/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.othprice.controller.api;

import com.ejianc.business.othprice.service.IPicketageService;
import com.ejianc.business.othprice.vo.PicketageQuoteVO;
import com.ejianc.business.othprice.vo.SubContractorBidVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/otherInquiry"})
public class IOtherInquiryApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPicketageService picketageService;

    @GetMapping(value={"getSubContractorBidInfo"})
    public CommonResponse<SubContractorBidVO> getSubContractorBidInfo(@RequestParam(value="supplierId") Long supplierId) {
        List<PicketageQuoteVO> list = this.picketageService.getSubContractorBidList(supplierId);
        SubContractorBidVO subContractorBidVO = new SubContractorBidVO();
        if (CollectionUtils.isNotEmpty(list)) {
            Integer bidNum = list.size();
            Integer winBidNum = 0;
            BigDecimal bidFactorSum = BigDecimal.ZERO;
            BigDecimal winBidFactorSum = BigDecimal.ZERO;
            for (PicketageQuoteVO picketageQuoteVO : list) {
                Integer bidFlag = picketageQuoteVO.getBidFlag();
                BigDecimal competitionNum = picketageQuoteVO.getCompetitionNum();
                if (bidFlag != null && bidFlag == 1) {
                    Integer n = winBidNum;
                    Integer n2 = winBidNum = Integer.valueOf(winBidNum + 1);
                    winBidFactorSum = ComputeUtil.safeAdd((BigDecimal)winBidFactorSum, (BigDecimal)competitionNum);
                }
                bidFactorSum = ComputeUtil.safeAdd((BigDecimal)bidFactorSum, (BigDecimal)competitionNum);
            }
            subContractorBidVO.setBidNum(bidNum);
            subContractorBidVO.setWinBidNum(winBidNum);
            subContractorBidVO.setLoseBidNum(Integer.valueOf(bidNum - winBidNum));
            subContractorBidVO.setAvgBidFactor(ComputeUtil.safeDiv((BigDecimal)bidFactorSum, (BigDecimal)ComputeUtil.toBigDecimal((Integer)bidNum)));
            subContractorBidVO.setAvgWinBidFactor(ComputeUtil.safeDiv((BigDecimal)winBidFactorSum, (BigDecimal)ComputeUtil.toBigDecimal((Integer)winBidNum)));
        }
        return CommonResponse.success((Object)subContractorBidVO);
    }
}

