/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.othprice.utils;

import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FeignUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDefdocApi defdocApi;

    public Map<Long, String> getDefdocMap(Long id) {
        CommonResponse resp = this.defdocApi.getDefDocByDefId(id);
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            List list = (List)resp.getData();
            return list.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName));
        }
        return new HashMap<Long, String>();
    }

    public String getDefDocName(String defDocId, Map<Long, String> defDocMap) {
        if (StringUtils.isEmpty((CharSequence)defDocId)) {
            return null;
        }
        if (!defDocId.contains(",")) {
            return defDocMap.get(Long.valueOf(defDocId));
        }
        String[] ids = StringUtils.split((String)defDocId, (String)",");
        List idList = Arrays.stream(ids).map(Long::valueOf).collect(Collectors.toList());
        List projectTypeName = idList.stream().filter(x -> defDocMap.keySet().contains(x)).map(defDocMap::get).collect(Collectors.toList());
        return StringUtils.join(projectTypeName, (String)",");
    }
}

