package com.ejianc.business.othprice.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.MaterialPriceVO;
import com.ejianc.business.othprice.bean.*;
import com.ejianc.business.othprice.common.vo.InquiryCommonVO;
import com.ejianc.business.othprice.mapper.PicketageMapper;
import com.ejianc.business.othprice.service.*;
import com.ejianc.business.othprice.vo.PicketageDetailVO;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.othprice.vo.OtherInquiryDetailVO;
import com.ejianc.business.othprice.vo.OtherInquiryVO;
import com.ejianc.business.utils.DateUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;

/**
 * 材料定标
 *
 * @author generator
 *
 */
@Service("materialPicketageService")
public class PicketageServiceImpl extends BaseServiceImpl<PicketageMapper, PicketageEntity> implements IPicketageService {

    private static final Logger logger = LoggerFactory.getLogger(OtherQuoteServiceImpl.class);
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_273725524";
    private static final String TEMPLATE_CODE = "templateCode";
    @Autowired
    private IPicketageSupplierService supplierService;
    @Autowired
    private IPicketageService service;
    @Autowired
    private IResultService materialResultService;
    @Autowired
    private IOtherInquiryService inquiryService;
    @Autowired
    private IPicketageSupplierService materialPicketageSupplierService;
    @Autowired
    private InquiryCommonService inquiryCommonService;


    @Autowired
    private IPicketageQuoteDetailService purchaseDetailService;

    @Autowired
    private IMaterialSettlementApi materialSettlementApi;


    @Autowired
    private IResultDetailService resultPurchaseDetailService;
    @Autowired
    private EnvironmentTools environmentTools;

    @Autowired
    private IPicketageQuoteService quoteService;
    @Override
    public boolean insertOrUpdate(PicketageEntity entity) {
        List<PicketageSupplierEntity> supplierEntities  = new ArrayList<>();
        List<PicketageSupplierEntity> supplierList = new ArrayList<>();
        Boolean success = super.saveOrUpdate(entity,false);
        if(success){
            if(!ListUtil.isEmpty(entity.getDetailList())){
                entity.getDetailList().forEach(sub->{
                    supplierList.addAll(sub.getPicketageSupplierList());
                });
                List<PicketageDetailEntity> purchaseList = entity.getDetailList();
                List<Long> ids = purchaseList.stream().map(PicketageDetailEntity::getId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(ids)){
                    QueryParam param = new QueryParam();
                    param.getParams().put("picketageDetailId",new Parameter(QueryParam.IN,ids));
                    List<PicketageSupplierEntity> suppliers = supplierService.queryList(param,false);
                    if(!ListUtil.isEmpty(suppliers)){
                        supplierService.removeByIds(suppliers.stream().map(PicketageSupplierEntity::getId).collect(Collectors.toList()),false);
                    }
                    purchaseList.forEach(sub-> {
                        sub.getPicketageSupplierList().forEach(supplier-> {
                            supplier.setPicketageId(entity.getId());
                            supplier.setPicketageDetailId(sub.getId());
                            supplierEntities.add(supplier);
                        });
                    });
                }
//                if (entity.getPricingType()==1){
//
//                }
                if (CollectionUtils.isNotEmpty(supplierEntities)){
                    supplierService.saveOrUpdateBatch(supplierEntities,supplierEntities.size());
                }
            }
        }
        return true;
    }

    @Override
    public void  checkRefSave(PicketageEntity entity){
        QueryWrapper<PicketageEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("inquiry_id",entity.getInquiryId());
        if (entity.getId()!=null){
            queryWrapper.ne("id",entity.getId());
        }
        int count = super.count(queryWrapper);
        if (count>0){
            throw new BusinessException("一个询价申请单只能有一个自由态的定标单！");
        }
    }
    @Override
    public boolean insertOrUpdateRef(PicketageEntity entity) {
        if (!ListUtil.isEmpty(entity.getQuoteList())){
            List<Long> collect = entity.getQuoteList().stream().filter(e->(e.getBidFlag()==1)).map(PicketageQuoteEntity::getSupplierId).collect(toList());
            String bidWinnerIdStr = collect.stream().map(String::valueOf).collect(joining(","));
            List<String> nameList = entity.getQuoteList().stream().filter(e->(e.getBidFlag()==1)).map(PicketageQuoteEntity::getSupplierNameView).collect(toList());
            String bidWinnerNameStr = nameList.stream().map(String::valueOf).collect(joining(","));
            entity.setBidWinnerId(bidWinnerIdStr);
            entity.setBidWinnerName(bidWinnerNameStr);
        }
        Boolean success = super.saveOrUpdate(entity,false);
        if (success){



            //清楚孙表
            QueryWrapper<PicketageQuoteDetailEntity> purchaseWrapper  = new QueryWrapper<>();
            purchaseWrapper.eq("picketage_id",entity.getId());
            List<PicketageQuoteDetailEntity> delPurchaseList = purchaseDetailService.list(purchaseWrapper);
            if (CollectionUtils.isNotEmpty(delPurchaseList)) {
                purchaseDetailService.removeByIds(delPurchaseList.stream().map(PicketageQuoteDetailEntity::getId).collect(Collectors.toList()), false);
            }


            if (CollectionUtils.isNotEmpty(entity.getQuoteList())) {
                    List<PicketageQuoteDetailEntity> savePurchaseDetail = new ArrayList<>();
                    //报价记录
                    List<PicketageQuoteEntity> quoteList = entity.getQuoteList();
                    //保存报价记录子表
                    for (PicketageQuoteEntity quote : quoteList) {
                        if (CollectionUtils.isNotEmpty(quote.getQuoteDetailList())) {
                            for (PicketageQuoteDetailEntity detail : quote.getQuoteDetailList()) {
                                detail.setPicketageQuoteId(quote.getId());
                                detail.setPicketageId(entity.getId());
                                detail.setId(IdWorker.getId());
                            }
                            savePurchaseDetail.addAll(quote.getQuoteDetailList());
                        }

                    }
                    if (CollectionUtils.isNotEmpty(savePurchaseDetail)) {
                        purchaseDetailService.saveOrUpdateBatch(savePurchaseDetail);
                    }}

        }
        return true;
    }
    @Override
    public void pushPicketage(Long billId) {
        PicketageEntity entity = service.selectById(billId);
        //自制
        if (entity.getSelfFlag()==1){
            ResultEntity resultEntity = builderResultEntity(entity);
            materialResultService.saveOrUpdate(resultEntity,false);
        }else {
            //审批通过回写询价状态
            builderResultRef(entity);
        }

    }

    @Override
    public void rollBackPicketage(Long billId) {
        QueryWrapper<ResultEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("picketage_id",billId);
        List<ResultEntity> list = materialResultService.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            materialResultService.removeByIds(list.stream().map(ResultEntity::getId).collect(Collectors.toList()),true);
        }
    }

    public ResultEntity builderResultEntity(PicketageEntity entity){
        ResultEntity result = new ResultEntity();
        List<ResultDetailEntity> purchaseList = new ArrayList<>();

        result.setPicketageId(entity.getId());
        result.setPicketageSelfFlag(entity.getSelfFlag());
        if (StringUtils.isNotEmpty(entity.getBidWinnerId())){
            result.setSupplierId(Long.parseLong(entity.getBidWinnerId()));
            result.setSupplierName(entity.getBidWinnerName());
        }
        result.setProjectId(entity.getProjectId());
        result.setProjectName(entity.getProjectName());
        result.setOrgId(entity.getOrgId());
        result.setOrgName(entity.getOrgName());
        result.setPurchaseSubject(entity.getName());
        result.setPricingType(entity.getPricingType());
        switch (result.getPricingType().intValue())
        {
            case 1:
                result.setPricingTypeName("劳务分包");
                break;
            case 2:
                result.setPricingTypeName("专业分包");
                break;
            case 3:
                result.setPricingTypeName("设备采购");
                break;
            case 4:
                result.setPricingTypeName("设备租赁");
                break;
            default:
                result.setPricingTypeName("其他");
        }
        result.setPurchaseType(entity.getPurchaseType());
        result.setPurchaseTypeName(entity.getPurchaseType()==1 ? "项目自采" : "公司集采");
        result.setBillCode(entity.getBillCode());

        result.setInquiryMny(entity.getInquiryMny());
        result.setBidFlag(1);
        result.setHandleDate(entity.getHandleDate());
        result.setBidMny(entity.getBidWinMny());
        if (CollectionUtils.isNotEmpty(entity.getDetailList())){
            Map<Long, PicketageSupplierEntity> winSupplierMap=new HashMap<>();
            if (StringUtils.isNotEmpty(entity.getBidWinnerId())){
                QueryParam param = new QueryParam();
                param.getParams().put("supplierId",new Parameter(QueryParam.EQ,Long.parseLong(entity.getBidWinnerId())));
                List<PicketageSupplierEntity> supplierEntities = supplierService.queryList(param, false);
                 winSupplierMap = supplierEntities.stream().collect(Collectors.toMap(k->k.getPicketageDetailId(),(k)->k));
            }
            for (PicketageDetailEntity purchase : entity.getDetailList()) {
                ResultDetailEntity resultPurchase = new ResultDetailEntity();
                resultPurchase.setDetailCode(purchase.getDetailCode());
                resultPurchase.setDetailName(purchase.getDetailName());
                resultPurchase.setSpec(purchase.getSpec());
                resultPurchase.setUnit(purchase.getUnit());
                resultPurchase.setResidueNum(purchase.getNum());
                resultPurchase.setReferPrice(purchase.getReferPrice());
                resultPurchase.setSourceId(purchase.getId());
                if (!winSupplierMap.isEmpty()){
                    PicketageSupplierEntity picketageSupplierEntity = winSupplierMap.get(purchase.getId());
                    resultPurchase.setBidNum(purchase.getNum());
                    resultPurchase.setBidPrice(picketageSupplierEntity.getPrice());
                    BigDecimal mny= ComputeUtil.safeMultiply(picketageSupplierEntity.getPrice(),purchase.getNum());
                    resultPurchase.setBidMny(mny);
                }
                purchaseList.add(resultPurchase);
            }
        }
        if (CollectionUtils.isNotEmpty(purchaseList)){
            result.setDetailList(purchaseList);
        }
        return result;
    }

    @Override
    public CommonResponse<JSONObject> queryByInquiryToDetailAndQuote(String inquiryId) {
        JSONObject jsonObject = new JSONObject();
        Map<Long, BigDecimal> collect = new HashMap<>();
        //查询询价
        OtherInquiryEntity materialInquiryEntity = inquiryService.selectById(inquiryId);
        OtherInquiryVO inquiryVO = BeanMapper.map(materialInquiryEntity, OtherInquiryVO.class);
        InquiryCommonVO inquiryCommonVO = inquiryCommonService.queryDetailByInquiry(materialInquiryEntity.getId(), materialInquiryEntity.getInquiryState(), materialInquiryEntity.getPricingType().toString(), false);

        jsonObject.put("quoteList",inquiryCommonVO.getOtherQuoteVOList());
        jsonObject.put("inquiry",BeanMapper.map(materialInquiryEntity,OtherInquiryVO.class));
        if (inquiryCommonVO.getPricingType().equals(new Integer(1))){
            collect = inquiryCommonVO.getOtherInquiryDetailList().stream().collect(
                    Collectors.toMap(OtherInquiryDetailVO::getId, OtherInquiryDetailVO::getNum));
            jsonObject.put("detailList",inquiryCommonVO.getOtherInquiryDetailList());
        }
        jsonObject.put("totalMap",collect);
        return CommonResponse.success("查询数据成功！",jsonObject);

    }

    @Override
    public JSONObject queryDetailToRef(Long id){

        PicketageEntity picketageEntity = service.selectById(id);
        //获取报价子表
        Map<Long, BigDecimal> collect = new HashMap<>();
        OtherInquiryEntity byId = inquiryService.selectById(picketageEntity.getInquiryId());
        OtherInquiryVO materialInquiry = BeanMapper.map(byId, OtherInquiryVO.class);
        if (materialInquiry.getPricingType().equals(new Integer(1))){
            collect = materialInquiry.getOtherInquiryDetailList().stream().collect(
                    Collectors.toMap(OtherInquiryDetailVO::getId, OtherInquiryDetailVO::getNum));
        }
        for (Object key : collect.keySet()) {
            //统计当前清单 占用数量
            QueryWrapper<PicketageQuoteDetailEntity> ew = new QueryWrapper<>();
            ew.eq("inquiry_id", picketageEntity.getInquiryId());
            ew.eq("source_id",key);
            ew.select("IFNULL(sum(bid_num),0) AS num");
            Map<String, Object> map = purchaseDetailService.getMap(ew);
            BigDecimal num = collect.get(key).subtract((BigDecimal) map.get("num"));
            collect.put((Long) key,num);
        }

        Map<Long, List<PicketageQuoteDetailEntity>> purchaseListMap = new HashMap<>();
        QueryWrapper<PicketageQuoteDetailEntity> quotePurchaseWrapper = new QueryWrapper<>();
        quotePurchaseWrapper.eq("picketage_id",id);
        List<PicketageQuoteDetailEntity> purchaseDetailEntities = purchaseDetailService.list(quotePurchaseWrapper);
        if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
             purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteDetailEntity::getPicketageQuoteId));
        }


        for (PicketageQuoteEntity quote:picketageEntity.getQuoteList()){
            if (quote.getBidFlag()==1){
                if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
                    quote.setQuoteDetailList(purchaseListMap.get(quote.getId()));
                }

            }
        }
        PicketageVO picketageVO = BeanMapper.map(picketageEntity, PicketageVO.class);
        JSONObject jsonObject = (JSONObject) JSONObject.toJSON(picketageVO);
        if (picketageVO.getHandleDate()!=null){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            jsonObject.put("handleDate",sdf.format( picketageVO.getHandleDate()));
        }
        //获取清单
        InquiryCommonVO inquiryCommonVO = inquiryCommonService.queryDetailByInquiry(picketageEntity.getInquiryId(), materialInquiry.getInquiryState(), materialInquiry.getPricingType().toString(), false);
        if (CollectionUtils.isNotEmpty(inquiryCommonVO.getOtherInquiryDetailList())){
            jsonObject.put("detailList",inquiryCommonVO.getOtherInquiryDetailList());
        }
        jsonObject.put("totalMap",collect);

        return jsonObject;
    }

    @Override
    public PicketageVO queryMaterialPicketageDetail(Long id) {
        PicketageEntity entity = service.selectById(id);
        PicketageVO vo=new PicketageVO();
        //查询孙级供应商
        entity=querySupplier(entity);
        vo = BeanMapper.map(entity, PicketageVO.class);
        //查询价格区间
//        vo= service.queryMaterialPriceArea(vo);
        return vo;
    }

    /**
     * 查询供应商
     * @param entity
     * @return
     */
    private PicketageEntity querySupplier(PicketageEntity entity) {
        if(!ListUtil.isEmpty(entity.getDetailList())){
            List<Long> detailIds = new ArrayList<>();
            List<Long> purchaseIds = entity.getDetailList().stream().map(PicketageDetailEntity::getId).collect(Collectors.toList());
            detailIds.addAll(purchaseIds);
            Map<Long, List<PicketageSupplierEntity>> supplierMap=new HashMap<>();
            if (CollectionUtils.isNotEmpty(detailIds)){
                QueryParam param = new QueryParam();
                param.getParams().put("picketageDetailId",new Parameter(QueryParam.IN,detailIds));
                List<PicketageSupplierEntity> supplierEntities = materialPicketageSupplierService.queryList(param, false);
                if (CollectionUtils.isNotEmpty(supplierEntities)){
                    supplierMap = supplierEntities.stream().collect(Collectors.groupingBy(PicketageSupplierEntity::getPicketageDetailId));
                }
                if (!supplierMap.isEmpty()){
                    for (PicketageDetailEntity purchase : entity.getDetailList()) {
                        purchase.setPicketageSupplierList(supplierMap.get(purchase.getId()));
                    }
                }
            }
        }
        return entity;
    }

    /**
     * 查询历史价格区间
     * @param vo
     * @return
     */
    @Override
    public PicketageVO queryMaterialPriceArea(PicketageVO vo) {
        /**
         * 填充参数
         */
        MaterialPriceVO priceVO = new MaterialPriceVO(vo.getProjectId());
        List<MaterialPriceVO> detail = new ArrayList<>();
        List<PicketageDetailVO> purchaseDetailList = vo.getDetailList();
        if (CollectionUtils.isNotEmpty(purchaseDetailList)){
            for (PicketageDetailVO picketageDetailVO : purchaseDetailList) {
                MaterialPriceVO materialPriceVO = new MaterialPriceVO();
                materialPriceVO.setMaterialId(Long.valueOf(picketageDetailVO.getMaterialId()));
                detail.add(materialPriceVO);
            }
        }
        //填充价格区间
        if (CollectionUtils.isNotEmpty(detail)){
            priceVO.setDetail(detail);
            CommonResponse<MaterialPriceVO> commonResponse = materialSettlementApi.queryPrice(priceVO);
            if(commonResponse.isSuccess()){
                MaterialPriceVO materialPriceVO = commonResponse.getData();
                List<MaterialPriceVO> materialPriceVOS = materialPriceVO.getDetail();
                if (CollectionUtils.isNotEmpty(materialPriceVOS)){
                    Map<Long, MaterialPriceVO> priceVOMap = materialPriceVOS.stream().collect(Collectors.toMap(MaterialPriceVO::getMaterialId, account -> account,(v1, v2) -> v2));
                    List<PicketageDetailVO> vos = vo.getDetailList();
                    if (CollectionUtils.isNotEmpty(vos)){
                        for (PicketageDetailVO picketageDetailVO : vos) {
                            Long materialId = picketageDetailVO.getMaterialId();
                            MaterialPriceVO p = priceVOMap.get(materialId);
                            if (!Objects.isNull(p)) {
                                picketageDetailVO.setMinPrice(p.getMinPrice());
                                picketageDetailVO.setMaxPrice(p.getMaxPrice());
                                picketageDetailVO.setPriceArea(p.getMinPrice().setScale(2,BigDecimal.ROUND_HALF_UP) + "~" + p.getMaxPrice().setScale(2,BigDecimal.ROUND_HALF_UP));
                            }
                        }
                        vo.setDetailList(vos);
                    }
                }
            }
        }
        return vo;
    }


    public List<ResultEntity> builderResultRef(PicketageEntity entity){

        List<ResultEntity> resultList= new ArrayList<>();
        if (CollectionUtils.isNotEmpty(entity.getQuoteList())){
            List<PicketageQuoteEntity> quoteList = entity.getQuoteList();
            Map<Long, List<PicketageQuoteDetailEntity>> purchaseListMap = new HashMap<>();
            List<ResultDetailEntity> savePurchaseList = new ArrayList<>();

            QueryWrapper<PicketageQuoteDetailEntity> quotePurchaseWrapper = new QueryWrapper<>();
            quotePurchaseWrapper.eq("picketage_id",entity.getId());
            List<PicketageQuoteDetailEntity> purchaseDetailEntities = purchaseDetailService.list(quotePurchaseWrapper);
            if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
                purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteDetailEntity::getPicketageQuoteId));
            }
            for(PicketageQuoteEntity quote:quoteList){
                if (quote.getBidFlag()==1){
                    ResultEntity result = new ResultEntity();
                    result.setId(IdWorker.getId());
                    result.setPicketageId(entity.getId());
                    result.setPicketageSelfFlag(entity.getSelfFlag());
                    result.setProjectId(entity.getProjectId());
                    result.setProjectName(entity.getProjectName());
                    result.setOrgId(entity.getOrgId());
                    result.setOrgName(entity.getOrgName());
                    result.setPurchaseSubject(entity.getName());
                    result.setPricingType(entity.getPricingType());
                    switch (result.getPricingType().intValue())
                    {
                        case 1:
                            result.setPricingTypeName("劳务分包");
                            break;
                        case 2:
                            result.setPricingTypeName("专业分包");
                            break;
                        case 3:
                            result.setPricingTypeName("设备采购");
                            break;
                        case 4:
                            result.setPricingTypeName("设备租赁");
                            break;
                        default:
                            result.setPricingTypeName("其他");
                    }
                    result.setPurchaseType(entity.getPurchaseType());
                    result.setPurchaseTypeName(entity.getPurchaseType()==1 ? "项目自采" : "公司集采");
                    result.setBillCode(entity.getBillCode());
                    result.setInquiryMny(entity.getInquiryMny());
                    result.setBidFlag(1);
                    result.setHandleDate(entity.getHandleDate());
                    result.setBidMny(quote.getBidMny());

                    result.setSupplierId(quote.getSupplierId());
                    result.setSupplierName(quote.getSupplierName());
                    result.setSocialCreditCode(quote.getSocialCreditCode());
                    result.setLegal(quote.getLegal());
                    result.setInquiryId(entity.getInquiryId());
                    result.setQuoteId(quote.getQuoteId());
                    result.setTelephone(quote.getTelephone());
                    result.setBidMemo(quote.getBidMemo());
                    result.setBidFlag(quote.getBidFlag());
                    result.setQuoteMemo(quote.getQuoteMemo());
                    result.setHandleDate(quote.getQuoteTime());
                    result.setTotalMny(quote.getPurchaseMny());
                    if (CollectionUtils.isNotEmpty(purchaseListMap.get(quote.getId()))){

                        List<PicketageQuoteDetailEntity> purchaseDetailList = purchaseListMap.get(quote.getId());
                        List<ResultDetailEntity> materialResultPurchaseDetail = new ArrayList<>();
                        for (PicketageQuoteDetailEntity purchase:purchaseDetailList){
                            ResultDetailEntity purchaseDetail = new ResultDetailEntity();
                            purchaseDetail.setId(IdWorker.getId());
                            purchaseDetail.setPid(result.getId());
                            purchaseDetail.setSourceId(purchase.getId());
                            purchaseDetail.setDetailName(purchase.getDetailName());
                            purchaseDetail.setDetailCode(purchase.getDetailCode());
                            purchaseDetail.setMaterialId(purchase.getMaterialId());
                            purchaseDetail.setSpec(purchase.getSpec());
                            purchaseDetail.setUnit(purchase.getUnit());
                            purchaseDetail.setResidueNum(purchase.getResidueNum());
                            purchaseDetail.setReferPrice(purchase.getReferPrice());
                            purchaseDetail.setBidNum(purchase.getBidNum());
                            purchaseDetail.setBidPrice(purchase.getBidPrice());
                            purchaseDetail.setBidMny(purchase.getBidMny());
                            materialResultPurchaseDetail.add(purchaseDetail);
                        }
                        savePurchaseList.addAll(materialResultPurchaseDetail);
//                            result.setMaterialResultPurchaseDetailList(materialResultPurchaseDetail);
                    }
                    resultList.add(result);
                }
            }
            if (CollectionUtils.isNotEmpty(savePurchaseList)){
                resultPurchaseDetailService.saveOrUpdateBatch(savePurchaseList);
                logger.info("savePurchaseList--{}",JSONObject.toJSONString(savePurchaseList));
            }
            if (CollectionUtils.isNotEmpty(resultList)){
                materialResultService.saveOrUpdateBatch(resultList);
                logger.info("materialResultData--{}",JSONObject.toJSONString(resultList));


            }
        }
        return resultList;

    }


    /**
     * 定标单生效后，给中标供应商手机号发信息.
     * 消息模板：【联系人】您好，您在【报价时间】的针对【采购主题】的投标报价已中标，中标金额为【中标金额】元，可联系客户方负责人了解中标详情！
     */
    @Override
    public void sendMsg(Long id) {
        PicketageEntity entity = super.selectById(id);
        //查询到对应的供应商 条件 已中标
        QueryWrapper<PicketageQuoteEntity> quoteWrapper = new QueryWrapper<>();
        quoteWrapper.eq("picketage_id",entity.getId());
        quoteWrapper.eq("bid_flag",1);
        List<PicketageQuoteEntity> quoteList = quoteService.list(quoteWrapper);
        for (PicketageQuoteEntity quote:quoteList){
            if(StringUtils.isNotEmpty(quote.getLegal())&&StringUtils.isNotEmpty(quote.getTelephone())){
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                DecimalFormat decimalFormat = new DecimalFormat("0.00");
                try {
                    sendVerifyCode(quote.getTelephone(),quote.getLegal(),sdf.format(quote.getQuoteTime()),entity.getName(),
                            decimalFormat.format(quote.getBidMny()),null);
                } catch (Exception e) {
                    logger.error("定标生效给中标供应商手机号:{}发送短信失败！时间：{}", quote.getTelephone(), DateUtil.getCurrentDay(DateUtil.DATE_TIME));
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     *  发送短信
     * @param phone 手机号
     * @param userName 联系人姓名
     * @param publishTime 时间
     * @param title 询价主题
     * @param amount 金额
     * @param templateCode 模板编号
     * @throws Exception 异常
     */
    public void sendVerifyCode(String phone, String userName, String publishTime, String title, String amount, String templateCode) throws Exception {
        Assert.hasText(phone, "电话号码不能为空！");
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", phone);
        Map<String, String> params = new HashMap<>();
        params.put("userName", userName);
        params.put("publishTime", publishTime);
        params.put("title", title);
        params.put("amount", amount);
        messageParam.put("params", params);
        if (org.apache.commons.lang3.StringUtils.isBlank(templateCode)) {
            messageParam.put(TEMPLATE_CODE, DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put(TEMPLATE_CODE, templateCode);
        }
        logger.info("发送短信参数：[{}]", messageParam);
        String messageUrl = environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson(messageUrl, JSON.toJSONString(messageParam));
        logger.info("向手机号[{}]发送短信结果：[{}]", phone, responseStr);
        CommonResponse<String> response = JSON.parseObject(responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("短信发送失败！");
        }
    }

    /**
     * 定标打印模板配置
     * @param detailJsonStr
     * @return
     */
    @Override
    public CommonResponse<JSONObject> handlePrintDetail(String detailJsonStr) {
        if(StringUtils.isBlank(detailJsonStr)) {
            return CommonResponse.success(null);
        }
        JSONObject data = JSONObject.parseObject(detailJsonStr);
        if(null == data) {
            return CommonResponse.success(null);
        }
        JSONObject detailJson = data.getJSONObject("detailJson");
        if(null == detailJson) {
            return CommonResponse.success(null);
        }
        JSONObject picketage = detailJson.getJSONObject("MaterialPicketage");
        if (null == picketage) {
            return CommonResponse.success(null);
        }
       Long id = (Long) picketage.get("id");
        if (null==picketage.get("MaterialPicketageQuote")){
            List<JSONObject> picketageQuoteList = (List<JSONObject>) picketage.get("MaterialPicketageQuote");
            Map<Long, List<PicketageQuoteDetailEntity>> purchaseListMap = new HashMap<>();
            QueryWrapper<PicketageQuoteDetailEntity> quotePurchaseWrapper = new QueryWrapper<>();
            quotePurchaseWrapper.eq("picketage_id",id);
            List<PicketageQuoteDetailEntity> purchaseDetailEntities = purchaseDetailService.list(quotePurchaseWrapper);
            if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
                purchaseListMap = purchaseDetailEntities.stream().collect(Collectors.groupingBy(PicketageQuoteDetailEntity::getPicketageQuoteId));
            }

            for (JSONObject quote:picketageQuoteList){
                Integer bidFlag = (Integer) quote.get("bidFlag");
                if (bidFlag==1){
                    if (CollectionUtils.isNotEmpty(purchaseDetailEntities)){
                        quote.put("PicketageQuotePurchaseDetail",purchaseListMap.get(quote.get("id")));
                    }
                }
            }
            picketage.put("MaterialPicketageQuote",picketageQuoteList);
        }
       picketage.put("AAA","picketageQuoteList");

       detailJson.put("MaterialPicketage", picketage);
       return CommonResponse.success(detailJson);
    }
}
