package com.ejianc.foundation.outcontract.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 中标交底
 * 
 * @author generator
 * 
 */
public class BidWinDisclosureVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String projectAddress; // 工程地点
    private BigDecimal bidWinMny; // 中标金额
    private BigDecimal constructionArea; // 建筑面积
    private String confessAddress; // 交底地点
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date confessDate; // 交底时间
    private String confidant; // 交底人
    private String receiver; // 接收人
    private String projectOverview; // 工程概况
    private String quotedPriceData; // 本工程投标报价依据的资料
    private String shouldSaveData; // 所属公司和项目部应该保存的资料
    private String quoteIdeas; // 报价的整体思路
    private String quoteAdjustmentItem; // 报价时主要调增，调减的子目
    private String memo; // 备注
    private String projectCareQuestion; // 合同谈判及项目实施时需要注意的问题
    private String peopleCareQuestion; // 商务人员需要注意的问题
    private String techniqueCareQuestion; // 技术上需要注意的问题:
    private String qualityRequire; // 质量和安全文明要求
    private String dateRequire; // 工期要求
    private String techniquePlan; // 投标技术方案
    private String designPlan; // 投标设计方案
    private String billStateName; // 单据状态名称

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public BigDecimal getBidWinMny() {
        return bidWinMny;
    }

    public void setBidWinMny(BigDecimal bidWinMny) {
        this.bidWinMny = bidWinMny;
    }
    public BigDecimal getConstructionArea() {
        return constructionArea;
    }

    public void setConstructionArea(BigDecimal constructionArea) {
        this.constructionArea = constructionArea;
    }
    public String getConfessAddress() {
        return confessAddress;
    }

    public void setConfessAddress(String confessAddress) {
        this.confessAddress = confessAddress;
    }
    public Date getConfessDate() {
        return confessDate;
    }

    public void setConfessDate(Date confessDate) {
        this.confessDate = confessDate;
    }
    public String getConfidant() {
        return confidant;
    }

    public void setConfidant(String confidant) {
        this.confidant = confidant;
    }
    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }
    public String getProjectOverview() {
        return projectOverview;
    }

    public void setProjectOverview(String projectOverview) {
        this.projectOverview = projectOverview;
    }
    public String getQuotedPriceData() {
        return quotedPriceData;
    }

    public void setQuotedPriceData(String quotedPriceData) {
        this.quotedPriceData = quotedPriceData;
    }
    public String getShouldSaveData() {
        return shouldSaveData;
    }

    public void setShouldSaveData(String shouldSaveData) {
        this.shouldSaveData = shouldSaveData;
    }
    public String getQuoteIdeas() {
        return quoteIdeas;
    }

    public void setQuoteIdeas(String quoteIdeas) {
        this.quoteIdeas = quoteIdeas;
    }
    public String getQuoteAdjustmentItem() {
        return quoteAdjustmentItem;
    }

    public void setQuoteAdjustmentItem(String quoteAdjustmentItem) {
        this.quoteAdjustmentItem = quoteAdjustmentItem;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getProjectCareQuestion() {
        return projectCareQuestion;
    }

    public void setProjectCareQuestion(String projectCareQuestion) {
        this.projectCareQuestion = projectCareQuestion;
    }
    public String getPeopleCareQuestion() {
        return peopleCareQuestion;
    }

    public void setPeopleCareQuestion(String peopleCareQuestion) {
        this.peopleCareQuestion = peopleCareQuestion;
    }
    public String getTechniqueCareQuestion() {
        return techniqueCareQuestion;
    }

    public void setTechniqueCareQuestion(String techniqueCareQuestion) {
        this.techniqueCareQuestion = techniqueCareQuestion;
    }
    public String getQualityRequire() {
        return qualityRequire;
    }

    public void setQualityRequire(String qualityRequire) {
        this.qualityRequire = qualityRequire;
    }
    public String getDateRequire() {
        return dateRequire;
    }

    public void setDateRequire(String dateRequire) {
        this.dateRequire = dateRequire;
    }
    public String getTechniquePlan() {
        return techniquePlan;
    }

    public void setTechniquePlan(String techniquePlan) {
        this.techniquePlan = techniquePlan;
    }
    public String getDesignPlan() {
        return designPlan;
    }

    public void setDesignPlan(String designPlan) {
        this.designPlan = designPlan;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
