package com.ejianc.foundation.sealApproval.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 用印审批
 * 
 * @author generator
 * 
 */
public class SealApprovalVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long contractId; // 合同id
    private String contractName; // 合同名称
    private Long applyDept; // 申请部门
    private String applyDeptName; // 申请部门名称
    private BigDecimal sealCount; // 用印数量
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String employeePhone; // 经办人联系电话
    private String memo; // 备注
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 借出日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date returnDate; // 归还日期
    private String sealReasons; // 用印事由
    private String bid; // 投标
    private String certification; // 资格审查
    private String contract; // 合同
    private String lawsuit; // 诉讼
    private String prove; // 证明
    private String guarantee; // 担保
    private String excellence; // 创优
    private String engineering; // 工程资料
    private String companySeal; // 公司章
    private String legalSeal; // 法人代表章
    private String contractSeal; // 合同专用章
    private String partySeal; // 党委章
    private String disciplineSeal; // 纪委章
    private String otherSeal; // 其他章
    private String sealMemo; // 其他章备注
    private String signed; // 签约
    private String others; // 其他
    private String billStateName; //单据状态名称
    private List<String> seal;
    private List<String> sealCategory;
    private List<String> text;
    private String sealContent;//用印内容
    private String stampCategory;//印章种类
    private String contractType; // 合同类型

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-incontract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getApplyDept() {
        return applyDept;
    }
    @ReferSerialTransfer
    public void setApplyDept(Long applyDept) {
        this.applyDept = applyDept;
    }
    public String getApplyDeptName() {
        return applyDeptName;
    }

    public void setApplyDeptName(String applyDeptName) {
        this.applyDeptName = applyDeptName;
    }
    public BigDecimal getSealCount() {
        return sealCount;
    }

    public void setSealCount(BigDecimal sealCount) {
        this.sealCount = sealCount;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeePhone() {
        return employeePhone;
    }

    public void setEmployeePhone(String employeePhone) {
        this.employeePhone = employeePhone;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Date getReturnDate() {
        return returnDate;
    }

    public void setReturnDate(Date returnDate) {
        this.returnDate = returnDate;
    }
    public String getSealReasons() {
        return sealReasons;
    }

    public void setSealReasons(String sealReasons) {
        this.sealReasons = sealReasons;
    }
    public String getBid() {
        return bid;
    }

    public void setBid(String bid) {
        this.bid = bid;
    }
    public String getCertification() {
        return certification;
    }

    public void setCertification(String certification) {
        this.certification = certification;
    }
    public String getContract() {
        return contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }
    public String getLawsuit() {
        return lawsuit;
    }

    public void setLawsuit(String lawsuit) {
        this.lawsuit = lawsuit;
    }
    public String getProve() {
        return prove;
    }

    public void setProve(String prove) {
        this.prove = prove;
    }
    public String getGuarantee() {
        return guarantee;
    }

    public void setGuarantee(String guarantee) {
        this.guarantee = guarantee;
    }
    public String getExcellence() {
        return excellence;
    }

    public void setExcellence(String excellence) {
        this.excellence = excellence;
    }
    public String getEngineering() {
        return engineering;
    }

    public void setEngineering(String engineering) {
        this.engineering = engineering;
    }
    public String getCompanySeal() {
        return companySeal;
    }

    public void setCompanySeal(String companySeal) {
        this.companySeal = companySeal;
    }
    public String getLegalSeal() {
        return legalSeal;
    }

    public void setLegalSeal(String legalSeal) {
        this.legalSeal = legalSeal;
    }
    public String getContractSeal() {
        return contractSeal;
    }

    public void setContractSeal(String contractSeal) {
        this.contractSeal = contractSeal;
    }
    public String getPartySeal() {
        return partySeal;
    }

    public void setPartySeal(String partySeal) {
        this.partySeal = partySeal;
    }
    public String getDisciplineSeal() {
        return disciplineSeal;
    }

    public void setDisciplineSeal(String disciplineSeal) {
        this.disciplineSeal = disciplineSeal;
    }
    public String getOtherSeal() {
        return otherSeal;
    }

    public void setOtherSeal(String otherSeal) {
        this.otherSeal = otherSeal;
    }

    public String getSealMemo() {
        return sealMemo;
    }

    public void setSealMemo(String sealMemo) {
        this.sealMemo = sealMemo;
    }

    public String getSigned() {
        return signed;
    }

    public void setSigned(String signed) {
        this.signed = signed;
    }
    public String getOthers() {
        return others;
    }

    public void setOthers(String others) {
        this.others = others;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<String> getSeal() {
        return seal;
    }

    public void setSeal(List<String> seal) {
        this.seal = seal;
    }

    public List<String> getSealCategory() {
        return sealCategory;
    }

    public void setSealCategory(List<String> sealCategory) {
        this.sealCategory = sealCategory;
    }

    public List<String> getText() {
        return text;
    }

    public void setText(List<String> text) {
        this.text = text;
    }

    public String getSealContent() {
        return sealContent;
    }

    public void setSealContent(String sealContent) {
        this.sealContent = sealContent;
    }

    public String getStampCategory() {
        return stampCategory;
    }

    public void setStampCategory(String stampCategory) {
        this.stampCategory = stampCategory;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }
}
