package com.ejianc.foundation.outcontractDisclosure.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 供方合同交底
 * 
 * @author generator
 * 
 */
public class OutcontractDisclosureVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long contractId; // 项目id
    private String contractName; // 合同名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractSignDate; // 合同签订时间
    private String confidant; // 交底人
    private String receiver; // 被交底人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date confessDate; // 交底日期
    private String confessAddress; // 交底地点
    private String contractContent; // 分供方合同工作内容及工期要求
    private String contractPrinciple; // 分供方合同计量计价原则
    private String contractPunishment; // 分供方合同违约罚则
    private String contractAgreement; // 分供方合同中关于甲供材消耗的约定
    private String otherContent; // 其他内容
    private String memo; // 备注
    private String contractType; // 合同类型
    private String billStateName;

    /**导出处理数据start**/
    private String contractSignDateShow; // 交底时间
    private String confessDateShow; // 交底日期
    /**导出处理数据end**/

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Date getContractSignDate() {
        return contractSignDate;
    }

    public void setContractSignDate(Date contractSignDate) {
        this.contractSignDate = contractSignDate;
    }
    public String getConfidant() {
        return confidant;
    }

    public void setConfidant(String confidant) {
        this.confidant = confidant;
    }
    public String getReceiver() {
        return receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }
    public Date getConfessDate() {
        return confessDate;
    }

    public void setConfessDate(Date confessDate) {
        this.confessDate = confessDate;
    }
    public String getConfessAddress() {
        return confessAddress;
    }

    public void setConfessAddress(String confessAddress) {
        this.confessAddress = confessAddress;
    }
    public String getContractContent() {
        return contractContent;
    }

    public void setContractContent(String contractContent) {
        this.contractContent = contractContent;
    }
    public String getContractPrinciple() {
        return contractPrinciple;
    }

    public void setContractPrinciple(String contractPrinciple) {
        this.contractPrinciple = contractPrinciple;
    }
    public String getContractPunishment() {
        return contractPunishment;
    }

    public void setContractPunishment(String contractPunishment) {
        this.contractPunishment = contractPunishment;
    }
    public String getContractAgreement() {
        return contractAgreement;
    }

    public void setContractAgreement(String contractAgreement) {
        this.contractAgreement = contractAgreement;
    }
    public String getOtherContent() {
        return otherContent;
    }

    public void setOtherContent(String otherContent) {
        this.otherContent = otherContent;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

	public String getContractSignDateShow() {
		return contractSignDateShow;
	}

	public void setContractSignDateShow(String contractSignDateShow) {
		this.contractSignDateShow = contractSignDateShow;
	}

	public String getConfessDateShow() {
		return confessDateShow;
	}

	public void setConfessDateShow(String confessDateShow) {
		this.confessDateShow = confessDateShow;
	}
    
}
